/*
 * Decompiled with CFR 0.152.
 */
package com.android.core.data;

import com.android.core.domain.model.BaseResponse;
import com.android.core.domain.model.GenericResponse;
import com.android.core.domain.model.RequestData;
import com.android.core.utils.Totals;
import com.android.core.utils.params.AndroidFilter;
import com.android.core.utils.params.QueryParamTypes;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.DbConnection;
import com.utility.Paging;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import com.utility.TncLog;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.NonNull;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AndroidRepository<T> {
    protected final DbConnection dbConnection;
    protected final TncLog log = new TncLog();
    private Integer totalCount = null;
    private Integer totalPages = null;

    public AndroidRepository(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BaseResponse<Map<String, Object>> getAsMap(RequestData request, Paging paging, LoginDto login) {
        try {
            String sql = this.makeSql(request, paging, login);
            if (sql == null) {
                BaseResponse baseResponse = new BaseResponse.Builder().build();
                return baseResponse;
            }
            BaseResponse baseResponse = new BaseResponse.Builder().data(this.dbConnection.getJdbcTemplate(login).queryForList(sql)).totalCount(this.totalCount).totalPages(this.totalPages).build();
            return baseResponse;
        }
        catch (Exception e) {
            this.log.info("exception - class: " + this.getClass().getSimpleName() + " - sql: " + e);
            BaseResponse baseResponse = new BaseResponse.Builder().withError(TncException.fromException((Throwable)e).makeAndroidError()).build();
            return baseResponse;
        }
        finally {
            this.deleteTempTableIfAny(login, paging);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BaseResponse<T> getAsObject(RequestData request, Paging paging, LoginDto login) throws RuntimeException {
        RowMapper rowMapper = this.getRowMapper();
        if (rowMapper == null) {
            throw new RuntimeException("*No RowMapper implemented for " + this.getClass().getSimpleName());
        }
        try {
            String sql = this.makeSql(request, paging, login);
            if (sql == null) {
                BaseResponse baseResponse = new BaseResponse.Builder().build();
                return baseResponse;
            }
            BaseResponse baseResponse = new BaseResponse.Builder().data(this.dbConnection.getJdbcTemplate(login).query(sql, rowMapper)).totalCount(this.totalCount).totalPages(this.totalPages).build();
            return baseResponse;
        }
        catch (Exception e) {
            this.log.info("exception - class: " + this.getClass().getSimpleName() + " - sql: " + e);
            BaseResponse baseResponse = new BaseResponse.Builder().withError(TncException.fromException((Throwable)e).makeAndroidError()).build();
            return baseResponse;
        }
        finally {
            this.deleteTempTableIfAny(login, paging);
        }
    }

    @Nullable
    protected final String makeSql(RequestData request, Paging paging, LoginDto login) {
        Paging.PageSqlData data = this.queryWithDefaultPaging(this.getSettingLoader(login));
        if (data == null) {
            data = this.queryWithDefaultPaging(request, this.getSettingLoader(login));
        }
        if (data == null) {
            return null;
        }
        data.setWhereStr(this.makeWhere(request, data));
        if (paging.getTableName().isEmpty()) {
            return login.makeUseDbSql() + data.getSelectSqlStr();
        }
        Totals totals = new Totals(paging, this.dbConnection, login);
        totals.calculateTotals(data);
        this.totalCount = totals.getTotalCount();
        this.totalPages = totals.getTotalPages();
        return paging.makeSql(data);
    }

    private void deleteTempTableIfAny(LoginDto login, @NotNull Paging paging) {
        if (!paging.getTableName().contains("#")) {
            return;
        }
        this.dbConnection.getJdbcTemplate(login).update(" IF (OBJECT_ID('tempdb.." + paging.getTableName() + "') IS NOT NULL) \n DROP TABLE " + paging.getTableName());
    }

    @NotNull
    private String makeWhere(RequestData request, @NotNull Paging.PageSqlData data) {
        String sqlWhere = this.getFilterParams(request).getFilterWithPrecedingWhere();
        if (data.getWhereStr().isEmpty()) {
            return sqlWhere;
        }
        String tWhere = data.getWhereStr().trim();
        if (tWhere.startsWith("WHERE") || tWhere.startsWith("where")) {
            tWhere = tWhere.replaceFirst("WHERE", "").replaceFirst("where", "");
        }
        sqlWhere = sqlWhere + (sqlWhere.isEmpty() ? " WHERE " + tWhere : " AND " + tWhere);
        return sqlWhere;
    }

    public BaseResponse<Map<String, Object>> customQuery(RequestData request, Paging paging, LoginDto login) {
        return null;
    }

    public BaseResponse<T> customQueryAsObject(RequestData request, Paging paging, LoginDto login) {
        return null;
    }

    public BaseResponse<GenericResponse> insertAll(@NotNull List<T> items, LoginDto login) {
        this.log.info("items to POST: " + items);
        BaseResponse.Builder response = new BaseResponse.Builder();
        for (T item : items) {
            response.mergeResponse((BaseResponse)this.dbConnection.getTransactionTemplate(login).execute(status -> this.insert(item, login, status)));
        }
        return response.build();
    }

    protected BaseResponse<GenericResponse> insert(T item, LoginDto login, TransactionStatus status) throws TncException {
        throw new TncException(TncExceptionMessages.DEFAULT_ERROR);
    }

    public final BaseResponse<GenericResponse> edit(List<T> entityList, LoginDto myLogin) {
        BaseResponse.Builder result = new BaseResponse.Builder();
        TransactionTemplate transactionTemplate = this.dbConnection.getTransactionTemplate(myLogin);
        for (T entity : entityList) {
            result.mergeResponse((BaseResponse)transactionTemplate.execute(status -> this.internalEdit(entity, myLogin, status)));
        }
        return result.build();
    }

    protected BaseResponse<GenericResponse> internalEdit(T entity, LoginDto myLogin, TransactionStatus status) {
        return null;
    }

    @Nullable
    protected Paging.PageSqlData queryWithDefaultPaging(SettingLoader settingsLoader) {
        return null;
    }

    @Nullable
    protected Paging.PageSqlData queryWithDefaultPaging(RequestData request, SettingLoader settingsLoader) {
        return null;
    }

    @NonNull
    protected QueryParamTypes queryParamType() {
        return QueryParamTypes.NO_QUERY;
    }

    protected final AndroidFilter getFilterParams(RequestData request) {
        return new AndroidFilter(request, this.queryParamType());
    }

    protected final SettingLoader getSettingLoader(LoginDto loginDto) {
        return new SettingLoader(this.dbConnection, loginDto);
    }

    @Nullable
    protected RowMapper<T> getRowMapper() {
        return null;
    }

    protected final TncJdbc getJdbc(LoginDto loginDto) {
        return this.dbConnection.getJdbcTemplate(loginDto);
    }

    protected final Integer getTotalCount() {
        return this.totalCount;
    }

    protected final Integer getTotalPages() {
        return this.totalPages;
    }

    protected final BaseResponse<GenericResponse> makeBaseGenericResponse(TransactionStatus status, Supplier<GenericResponse> genericResponse) {
        BaseResponse.Builder response = new BaseResponse.Builder();
        try {
            return response.data((Object)genericResponse.get()).build();
        }
        catch (TncException e) {
            status.setRollbackOnly();
            return response.withError(e.makeAndroidError()).build();
        }
    }
}

