/*
 * Decompiled with CFR 0.152.
 */
package com.android.core.data.api;

import com.Application;
import com.android.core.domain.AndroidService;
import com.android.core.domain.model.RequestData;
import com.dto.LoginDto;
import com.utility.TncLog;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import springfox.documentation.annotations.ApiIgnore;

public abstract class AndroidController<T> {
    protected final Application app;
    protected final AndroidService<T> service;
    protected final TncLog log = new TncLog();

    protected AndroidController(Application app, AndroidService<T> service) {
        this.app = app;
        this.service = service;
    }

    @ApiIgnore
    @GetMapping
    @Nullable
    public ResponseEntity<Map<String, Object>> getItems(HttpServletRequest request, @RequestParam(required=false, name="page", defaultValue="-1") int page, @RequestParam(required=false, name="itemsPerPage", defaultValue="-1") int itemsPerPage) {
        boolean isAndroid = ((LoginDto)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).isAndroid();
        if (!isAndroid) {
            return null;
        }
        RequestData requestData = RequestData.builder().paramMap(RequestData.normalizeServletParams((HttpServletRequest)request)).build();
        ResponseEntity result = this.service.getItems(requestData, page, itemsPerPage);
        this.log.info("GET result: " + result);
        return result;
    }

    @ApiIgnore
    @PostMapping
    @Nullable
    public final ResponseEntity<Map<String, Object>> postItems(@RequestBody List<T> body) {
        boolean isAndroid = ((LoginDto)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).isAndroid();
        if (!isAndroid) {
            return null;
        }
        ResponseEntity result = this.service.post(body);
        this.log.info("POST result: " + result);
        return result;
    }

    @ApiIgnore
    @PutMapping
    @Nullable
    public final ResponseEntity<Map<String, Object>> edit(@RequestBody List<T> body) {
        boolean isAndroid = ((LoginDto)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).isAndroid();
        if (!isAndroid) {
            return null;
        }
        ResponseEntity result = this.service.edit(body);
        this.log.info("PUT result: " + body);
        return result;
    }

    public Application getApp() {
        return this.app;
    }

    public AndroidService<T> getService() {
        return this.service;
    }

    public TncLog getLog() {
        return this.log;
    }
}

