/*
 * Decompiled with CFR 0.152.
 */
package com.android.core.utils;

import com.dto.LoginDto;
import com.utility.DbConnection;
import com.utility.Paging;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class Totals {
    private final Paging paging;
    private final DbConnection dbConnection;
    private final LoginDto loginDto;
    private Integer totalCount = null;
    private Integer totalPages = null;

    public void calculateTotals(Paging.PageSqlData sqlData) {
        this.totalPages = null;
        this.totalCount = null;
        if (this.paging.getPage() != 1) {
            return;
        }
        String sql = this.makeQuery(sqlData);
        if (sqlData.getGroupBy().isEmpty()) {
            this.totalCount = (Integer)this.dbConnection.getJdbcTemplate(this.loginDto).queryForObject(sql, Integer.class);
        } else {
            this.totalCount = 0;
            SqlRowSet rs = this.dbConnection.getJdbcTemplate(this.loginDto).queryForRowSet(sql + "\n GROUP BY " + sqlData.getGroupBy());
            while (rs.next()) {
                Integer n = this.totalCount;
                Integer n2 = this.totalCount = Integer.valueOf(this.totalCount + 1);
            }
        }
        this.totalCount = this.totalCount == null ? 0 : this.totalCount;
        int itemsPerPage = this.paging.getItemsPerPage();
        this.totalPages = itemsPerPage < 1 ? Integer.valueOf(1) : Integer.valueOf((int)Math.ceil((double)this.totalCount.intValue() / (double)itemsPerPage));
    }

    @Language(value="SQL")
    @NotNull
    private String makeQuery(Paging.PageSqlData sqlData) {
        String alias;
        String string = alias = this.paging.getTableName().contains("=") ? "" : sqlData.getAlias();
        String countStr = !sqlData.getCountColName().isEmpty() ? sqlData.getCountColName() : (!sqlData.getKeyField().contains("+") ? "*" : (sqlData.isUseDistinctForTotalCount() ? "DISTINCT " : "") + sqlData.getKeyField());
        return sqlData.getDeclare() + " \n" + sqlData.getBeforePart() + " \n SELECT COUNT(" + countStr + ") FROM (\n" + sqlData.getCompleteQuery() + "\n) AS " + alias;
    }

    public Totals(Paging paging, DbConnection dbConnection, LoginDto loginDto) {
        this.paging = paging;
        this.dbConnection = dbConnection;
        this.loginDto = loginDto;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public Integer getTotalPages() {
        return this.totalPages;
    }
}

