/*
 * Decompiled with CFR 0.152.
 */
package com.android.core.utils.params;

import com.android.core.utils.params.Param;
import com.utility.ConvertStr;
import com.utility.SearchQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class QueryParams {
    public static final String AND_SQL = " AND ";
    public static final String OR_SQL = " OR ";
    private final List<String> andParams = new ArrayList();
    private final MultivaluedMap<Integer, String> orGroupParams = new MultivaluedHashMap();
    protected SearchQuery searchQuery = new SearchQuery();

    @Nullable
    public String makeWhere() {
        StringBuilder sb = new StringBuilder();
        for (String andParam : this.andParams) {
            sb.append(andParam).append("\n").append(AND_SQL);
        }
        sb = ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)sb, (String)AND_SQL);
        for (List group : this.orGroupParams.values()) {
            sb.append(AND_SQL).append("(").append(ConvertStr.bindStrings((Collection)group, (String)OR_SQL)).append(")");
        }
        if (this.andParams.isEmpty()) {
            sb = ConvertStr.removeFromStringBuilderFirstIndexOf((StringBuilder)sb, (String)AND_SQL);
        }
        return sb.toString();
    }

    @Nullable
    public void addParam(String userGivenParam, String userGivenValue) {
        Param validParam = this.findValidParam(userGivenParam);
        if (validParam != null) {
            String generatedSqlWherePart = this.generateWhereStr(validParam, userGivenValue);
            if (!ConvertStr.isNullOrEmpty((String)generatedSqlWherePart)) {
                this.andParams.add(generatedSqlWherePart);
            }
            return;
        }
        this.addValidOrParam(userGivenParam, userGivenValue);
    }

    @Nullable
    private Param findValidParam(String paramName) {
        for (Param validParam : this.validParamsIgnoreCase()) {
            if (!paramName.equalsIgnoreCase(validParam.getUserSideParamName())) continue;
            return validParam;
        }
        return null;
    }

    @Nullable
    private void addValidOrParam(String paramName, String userGivenValue) {
        for (int i = 0; i < this.validParamGroupsOfOr().size(); ++i) {
            List paramGroup = (List)this.validParamGroupsOfOr().get(i);
            for (Param param : paramGroup) {
                String generatedSqlWhere;
                if (!paramName.equalsIgnoreCase(param.getUserSideParamName()) || ConvertStr.isNullOrEmpty((String)(generatedSqlWhere = this.generateWhereStr(param, userGivenValue)))) continue;
                this.orGroupParams.add((Object)i, (Object)generatedSqlWhere);
            }
        }
    }

    @Nullable
    protected String generateWhereStr(Param validParam, String userGivenValue) {
        if (validParam.getCustomQuery() != null) {
            return (String)validParam.getCustomQuery().apply(validParam.getSqlStandardValue(userGivenValue));
        }
        if (this.searchQuery.isTextSearch(userGivenValue)) {
            return this.searchQuery.makeSqlQuery(userGivenValue, validParam.getSqlFieldName(), validParam.getFieldAlias(), validParam.getFieldTableName(), validParam.getParamType());
        }
        return this.searchQuery.makeSqlQueryNoTextSearch(userGivenValue, validParam.getSqlFieldName(), validParam.getFieldAlias(), validParam.getParamType());
    }

    @NonNull
    protected abstract Param[] validParamsIgnoreCase();

    protected List<List<Param>> validParamGroupsOfOr() {
        return null;
    }
}

