/*
 * Decompiled with CFR 0.152.
 */
package com.android.customer.data.api;

import com.Application;
import com.android.core.data.api.AndroidController;
import com.android.core.domain.AndroidService;
import com.android.customer.domain.model.ACustomerDto;
import com.android.files.domain.FilesService;
import com.dto.LoginDto;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/android/customer"})
public class CustomerController
extends AndroidController<ACustomerDto> {
    private final FilesService filesService;

    protected CustomerController(Application app, AndroidService<ACustomerDto> service, FilesService filesService) {
        super(app, service);
        this.filesService = filesService;
    }

    @GetMapping(value={"/pic-data/{picId}"}, produces={"image/png"})
    public ResponseEntity<Resource> getImage(@PathVariable String picId) {
        boolean isAndroid = ((LoginDto)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).isAndroid();
        if (!isAndroid) {
            return null;
        }
        return this.filesService.getPicture(picId);
    }
}

