/*
 * Decompiled with CFR 0.152.
 */
package com.android.customer.data.repository;

import com.android.core.data.AndroidRepository;
import com.android.core.utils.params.QueryParamTypes;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.Paging;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class CustomerCheckRepo
extends AndroidRepository<Map<String, Object>> {
    public CustomerCheckRepo(DbConnection dbConnection) {
        super(dbConnection);
    }

    @Nullable
    protected Paging.PageSqlData queryWithDefaultPaging(SettingLoader settingsLoader) {
        if (settingsLoader.doNotSendCustomerData()) {
            return null;
        }
        this.populateTempTable(settingsLoader);
        return Paging.PageSqlData.builder().selectSqlStr("SELECT * FROM #CustomerChecks").keyField("checkCode").keyFieldType("nvarchar(200)").build();
    }

    private void populateTempTable(SettingLoader settingsLoader) {
        String userWhere = settingsLoader.showCustomerChequeForUser() ? " and IsNull(ch.UserCodeReciveCheck, 0) = " + settingsLoader.getLogin().getUserCodeInc() + "\n" : "";
        String userWhereTmp = settingsLoader.showCustomerChequeForUser() ? " and IsNull(S.C_CodeVaseteh, '') = '" + settingsLoader.getMidManId() + "'" : "";
        String join = "";
        if (settingsLoader.userHasLimitedAccessToCustomers()) {
            join = " INNER JOIN (SELECT * FROM RMUserArtAccess \n WHERE UserId = " + settingsLoader.getLogin().getUserCodeInc() + " \n AND IsNull(DataTypeId, 0) = 1) RMUA ON RMUA.Articleid = ch.C_Code_Source";
        }
        String wherePart = settingsLoader.onlySendMidManCustomers() ? " AND ch.C_Code_Source IN (SELECT C_Code FROM CustomerVaseteh WHERE VASETEH_CODE = " + ConvertStr.toQuotedSqlStr((String)settingsLoader.getMidManId()) + ")" : "";
        String query = "IF (OBJECT_ID('tempdb..#CustomerChecks') IS NOT NULL) \n DROP TABLE #CustomerChecks \nSELECT * INTO #CustomerChecks FROM ( \n  SELECT 0 AS id, CAST(ch.Check_Code AS nvarchar(100)) + ch.Check_Number AS checkCode, \n   ch.Check_Number AS chequeNo, ch.Back_Number AS backNo, \n   ch.Receive_Date AS dueDate, ch.Export_Date AS creationDate, \n   bank.Bank_Name AS bankName, ch.C_Code_Source AS partyCode, \n   ch.Account_Number AS accountNumber, ch.Sanad_Code AS documentNumber, \n   IsNull(Sayad_number, '') sayadNo, IsNull(Check_SeriesNo, '') serialNumber, \n   IsNull(Attain_Date, '') attainDate, cash.S_Name AS fundName, \n   IsNull(ch.cust, 0) AS amount, ch.Vosool isSettled \n FROM [CHECK] ch \n" + join + " \n LEFT JOIN dbo.NEWBANK bank ON bank.Bank_Code = ch.Bank_Code \n LEFT JOIN dbo.Cash ON cash.Id = ch.cash_id \n WHERE (ch.Show_Daftar = 1) " + userWhere + wherePart + " AND (Ch.Daryaft_Pardakht = 1) \n UNION \n SELECT 0 AS id, CAST(ch.id AS NVARCHAR(100)) + Ch.Check_Number as checkCode, ch.Check_Number AS chequeNo, \n  ch.Back_Number AS backNo, ch.Receive_Date AS dueDate, ch.Export_Date AS creationDate, \n  bank.Bank_Name AS bankName, S.C_Code AS partyCode, \n  ch.Account_Number AS accountNumber, 0 AS documentNumber, \n  IsNull(Sayad_number,'') sayadNo, '' serialNumber, \n  '' attainDate, '' AS fundName, IsNull(ch.cust, 0) AS amount, 0 isSettled \n FROM TmpCheck Ch \n INNER JOIN TmpSanad S ON ch.IDSanad = S.ID \n LEFT JOIN dbo.NEWBANK  bank ON bank.Bank_Code = ch.Bank_Code \n WHERE IsNull(S.Sanad_Code,'') = '' " + userWhereTmp + " \n UNION \n SELECT 0 AS id, CAST(ch.id AS NVARCHAR(100)) + Ch.Check_Number as checkCode, ch.Check_Number AS chequeNo, \n  ch.Back_Number AS backNo, ch.Receive_Date AS dueDate, ch.Export_Date AS creationDate, \n  bank.Bank_Name AS bankName, f.C_Code AS partyCode, \n  ch.Account_Number AS accountNumber, 0 AS documentNumber, \n  IsNull(Sayad_number,'') sayadNo, '' serialNumber, \n  '' attainDate, '' AS fundName, IsNull(ch.cust, 0) AS amount, 0 isSettled \n FROM TmpCheck Ch \n LEFT JOIN dbo.NEWBANK  bank ON bank.Bank_Code = ch.Bank_Code \n INNER JOIN TmpFacture f ON Ch.FactureId = f.ID\n WHERE (IsNULL(f.Fac_CodeK, 0) = 0 AND IsNULL(f.Fac_CodeF, 0) = 0 AND IsNULL(f.Fac_CodeX, 0) = 0 AND IsNULL(f.Fac_CodeY, 0) = 0 AND IsNULL(f.Fac_CodeZ, 0) = 0)) AS CustomerChecks";
        this.dbConnection.getJdbcTemplate(settingsLoader.getLogin()).update(query);
    }

    @NotNull
    protected QueryParamTypes queryParamType() {
        return QueryParamTypes.CUSTOMER_CHECK;
    }
}

