/*
 * Decompiled with CFR 0.152.
 */
package com.android.customer.data.repository;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.BaseResponse;
import com.android.core.domain.model.RequestData;
import com.android.core.utils.params.QueryParamTypes;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DateUtils;
import com.utility.DbConnection;
import com.utility.Paging;
import com.utility.TncJdbc;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class MoienReportRepository
extends AndroidRepository<Map<String, Object>> {
    public MoienReportRepository(DbConnection dbConnection) {
        super(dbConnection);
    }

    public BaseResponse<Map<String, Object>> customQuery(RequestData request, Paging paging, LoginDto login) {
        String sql;
        boolean showWithDetails;
        Map filter = this.getFilterParams(request).makeUserParamMap(true);
        TncJdbc jdbc = this.getJdbc(login);
        SettingLoader loader = this.getSettingLoader(login);
        String whereStrUser = loader.getReceiveMoienByUser() ? " UserCodeInc = " + login.getUserCodeInc() : "";
        String getByMoienSql = "";
        if (loader.getReceiveMoienByUser()) {
            getByMoienSql = ", @WhereSql = ' AND " + whereStrUser + "'";
        }
        if (showWithDetails = ConvertStr.boolStrToBool((String)filter.getOrDefault("with-details", "false"))) {
            String whereStrDetail = this.getDetailWhereStr(jdbc, filter);
            String andStr = "";
            if (!whereStrDetail.isEmpty() && !whereStrUser.isEmpty()) {
                andStr = " AND ";
            }
            sql = " EXEC sp_MoienAshkhas @DBName = '" + login.getDatabaseName() + "', \n @HazinehHaml = '" + ConvertStr.getBoolToInt((Boolean)loader.isUseHazHamlInFactEnabled()) + "', \n @HlpMoienQuery ='', \n @HlpTbl ='', \n @WhereCustomer= '" + whereStrDetail + "\n" + andStr + whereStrUser + "', \n @AutoService = 3";
        } else {
            sql = " EXEC spMoienAshkhas @C_Code = '" + this.decryptCustomerCode(filter.getOrDefault("customer-code", "0"), login) + "', @FromSanadDate = '" + filter.getOrDefault("from-date", "") + "', @ToSanadDate = '" + filter.getOrDefault("to-date", "") + "'" + getByMoienSql;
        }
        List result = jdbc.queryForList(sql);
        result = result.stream().peek(map -> {
            Timestamp date = (Timestamp)map.get("Sanad_Date");
            Timestamp time = (Timestamp)map.get("Sanad_Time");
            if (map.get("Sanad_Date") != null) {
                map.put("Sanad_Date", DateUtils.timestampToCommonDateTimeStr((Timestamp)date));
            }
            if (map.get("Sanad_Time") != null) {
                map.put("Sanad_Time", DateUtils.timestampToCommonDateTimeStr((Timestamp)time));
            }
        }).collect(Collectors.toList());
        return new BaseResponse.Builder().data(result).build();
    }

    private String getDetailWhereStr(TncJdbc jdbc, Map<String, String> filter) {
        SqlRowSet rs = jdbc.queryForRowSet(" SELECT Col_Code_Bed, Moien_Code_Bed, Tafzili_Code_Bed, \n Col_Code_Bes, Moien_Code_Bes, Tafzili_Code_Bes, \n (Col_Code_Bed + Moien_Code_Bed + Tafzili_Code_Bed) as CMTCode, \n (Col_Code_Bes + Moien_Code_Bes + Tafzili_Code_Bes) as CMTCodeBes \n  FROM CUSTOMER C  WHERE C_CODE = '" + this.decryptCustomerCode(filter.getOrDefault("customer-code", ""), jdbc.getLogin()) + "'");
        if (!rs.next()) {
            return "";
        }
        String colBed = ConvertStr.nullSafeString((String)rs.getString("Col_Code_Bed"));
        String moienBed = ConvertStr.nullSafeString((String)rs.getString("Moien_Code_Bed"));
        String tafsiliBed = ConvertStr.nullSafeString((String)rs.getString("Tafzili_Code_Bed"));
        String colBes = ConvertStr.nullSafeString((String)rs.getString("Col_Code_Bes"));
        String moienBes = ConvertStr.nullSafeString((String)rs.getString("Moien_Code_Bes"));
        String tafsiliBes = ConvertStr.nullSafeString((String)rs.getString("Tafzili_Code_Bes"));
        String bedSql = "";
        String besSql = "";
        if (!colBed.isEmpty()) {
            bedSql = tafsiliBed.isEmpty() ? " (Snd_List.Col_Code = ''" + colBed + "'' AND Snd_List.Moien_Code = ''" + moienBed + "'' AND (Snd_List.Tafzili_Code = '''' OR Snd_List.Tafzili_Code is null) )" : " (Snd_List.Col_Code = ''" + colBed + "'' AND Snd_List.Moien_Code = ''" + moienBed + "'' AND Snd_List.Tafzili_Code = ''" + tafsiliBed + "'' )";
        }
        if (!colBes.isEmpty()) {
            besSql = tafsiliBes.isEmpty() ? " (Snd_List.Col_Code = ''" + colBes + "'' AND Snd_List.Moien_Code = ''" + moienBes + "'' AND (Snd_List.Tafzili_Code = '''' OR Snd_List.Tafzili_Code IS NULL))" : " (Snd_List.Col_Code = ''" + colBes + "'' And Snd_List.Moien_Code = ''" + moienBes + "'' And Snd_List.Tafzili_Code = ''" + tafsiliBes + "'' )";
        }
        String result = "";
        if (!bedSql.isEmpty() && !besSql.isEmpty()) {
            result = "(" + bedSql + " Or " + besSql + ")";
        }
        if (bedSql.isEmpty() || besSql.isEmpty()) {
            result = "(" + bedSql + besSql + ")";
        }
        if (bedSql.isEmpty() && besSql.isEmpty()) {
            result = "(Snd_List.Col_Code = '''' AND Snd_List.Moien_Code = '''' AND (Snd_List.Tafzili_Code = '''' OR Snd_List.Tafzili_Code is null) )";
        }
        String fromDate = filter.getOrDefault("from-date", "");
        String toDate = filter.getOrDefault("to-date", "");
        if (!fromDate.isEmpty()) {
            result = result + " AND (Sanad.Sanad_Date >= ''" + fromDate + "'')";
        }
        if (!toDate.isEmpty()) {
            result = result + " AND (Sanad.Sanad_Date <= ''" + toDate + "'')";
        }
        return result;
    }

    private String decryptCustomerCode(String code, LoginDto login) {
        if (!login.isAndroid()) {
            return ConvertStr.decrypt((String)code);
        }
        return code;
    }

    @NotNull
    protected QueryParamTypes queryParamType() {
        return QueryParamTypes.MOIEN_REPORT;
    }
}

