/*
 * Decompiled with CFR 0.152.
 */
package com.android.customer.domain.use_case;

import com.android.core.domain.model.GenericResponse;
import com.android.customer.domain.model.ACustomerDto;
import com.android.customer.domain.use_case.InsertCustomer;
import com.dao.CustomerDao;
import com.dto.CustomerDto;
import com.dto.LoginDto;
import com.security.SecurityConstants;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncJdbc;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class InsertCustomer {
    private final DbConnection dbConnection;
    private final CustomerDao customerDao;
    private SettingLoader settingLoader;
    private TncJdbc jdbc;

    public GenericResponse invoke(ACustomerDto customer) throws TncException {
        LoginDto login = SecurityConstants.loadToken();
        this.settingLoader = new SettingLoader(this.dbConnection, login);
        this.jdbc = this.dbConnection.getJdbcTemplate(login);
        CustomerMapper mapper = new CustomerMapper(this.settingLoader);
        ResponseEntity response = this.customerDao.postCustomerList(CustomerDao.CustomerPostOptions.builder().customerDtoArray((CustomerDto[])ConvertStr.arrayOf((Object[])new CustomerDto[]{mapper.mapFromDto(customer)})).allowDuplicateCell(this.settingLoader.isAllowDuplicateCell()).isUpdate(customer.isEdited()).build());
        ArrayList successList = ((Map)Objects.requireNonNull(response.getBody())).getOrDefault("Success", new ArrayList());
        ArrayList failureList = ((Map)Objects.requireNonNull(response.getBody())).getOrDefault("Failure", new ArrayList());
        if (!failureList.isEmpty()) {
            throw new TncException(((Map)failureList.get(0)).getOrDefault("Error", "\u062e\u0637\u0627\u06cc \u0646\u0627\u0645\u0634\u062e\u0635").toString(), ((Map)failureList.get(0)).getOrDefault("ErrorCode", 0).intValue());
        }
        GenericResponse success = null;
        if (!successList.isEmpty()) {
            GenericResponse.GenericResponseBuilder successBuilder = new OldResponseToNewMapperCustomer(null).mapToDto((Map)successList.get(0));
            successBuilder.requestIdentifier(customer.getCode());
            successBuilder.clientId(customer.getClientId() == null ? -1L : customer.getClientId());
            success = successBuilder.build();
            customer.setCode(success.getGeneratedCode());
        }
        this.setCustomerAccessible(customer, login.getUserCodeInc());
        this.insertMidMan(customer);
        return success;
    }

    private void setCustomerAccessible(ACustomerDto customer, int userCodeInc) {
        if (!this.settingLoader.userHasLimitedAccessToCustomers()) {
            return;
        }
        String sql = "";
        if (customer.isEdited()) {
            sql = sql + " if Not Exists(Select * from RMUserArtAccess where ArticleId = '" + customer.getCode() + "')\n";
        }
        this.jdbc.execute(sql + " INSERT INTO RMUserArtAccess([ReadOnly], OwnerId, [LangId], Active, UserId, ArticleId, DataTypeId) \nVALUES(0, 0, 305, 1, " + userCodeInc + ",'" + customer.getCode() + "', 1)");
    }

    private void insertMidMan(ACustomerDto customer) {
        if (ConvertStr.isNullOrEmpty((String)customer.getMidManCode())) {
            return;
        }
        if (customer.isEdited()) {
            this.jdbc.execute("DELETE FROM CustomerVaseteh WHERE C_Code = '" + customer.getCode() + "'");
        }
        this.jdbc.update("INSERT INTO CustomerVaseteh(C_Code, Vaseteh_Code, Vaseteh_Porsant) \nVALUES(?, ?, ?)", new Object[]{customer.getCode(), customer.getMidManCode(), customer.getMidManCommission()});
    }

    public InsertCustomer(DbConnection dbConnection, CustomerDao customerDao) {
        this.dbConnection = dbConnection;
        this.customerDao = customerDao;
    }
}

