/*
 * Decompiled with CFR 0.152.
 */
package com.android.files.data;

import com.android.files.domain.model.FileData;
import com.android.files.domain.util.AndroidFilesHandler;
import com.android.files.domain.util.BinaryDataService;
import com.android.files.domain.util.FileIdData;
import com.utility.ConvertStr;
import com.utility.GetIdentity;
import com.utility.TncJdbc;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.web.multipart.MultipartFile;

public class FileSystemBinaryDataService
implements BinaryDataService {
    private final TncJdbc jdbc;

    public FileSystemBinaryDataService(TncJdbc jdbc) {
        this.jdbc = jdbc;
    }

    public long store(MultipartFile file, AndroidFilesHandler.PictureType type) throws IOException {
        FileIdData idData = this.getSrcIdCode(file.getOriginalFilename());
        this.jdbc.update("INSERT INTO HloPictures([CODE], [PICTURE], [TYPE], IMAGE_SRC) VALUES (?, '', ?, ?)", new Object[]{idData.getEntityCode().replace(".png", ""), type.getType(), idData.getFileSrc()});
        long id = GetIdentity.invoke((TncJdbc)this.jdbc);
        this.updatePath(file, type, this.jdbc);
        return id;
    }

    private Path load(String fileId) {
        FileIdData idData = this.getSrcIdCode(fileId);
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT PicturePath FROM HLOPictures \n WHERE image_src = ? AND [ID] = ? AND [CODE] = ?", new Object[]{idData.getFileSrc(), idData.getId(), idData.getEntityCode()});
        if (!rs.next()) {
            return null;
        }
        String path = rs.getString("PicturePath");
        if (ConvertStr.isNullOrEmpty((String)path)) {
            return null;
        }
        return Paths.get(path, new String[0]);
    }

    public Resource loadAsResource(String fileId) {
        try {
            Path file = this.load(fileId);
            if (file == null) {
                throw new MalformedURLException();
            }
            UrlResource resource = new UrlResource(file.toUri());
            if (resource.exists() || resource.isReadable()) {
                return resource;
            }
            throw new RuntimeException("could not read file: " + fileId);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("couldn't read file: " + fileId, e);
        }
    }

    public List<String> loadAllAsBase64(String entityId) {
        try {
            return this.loadAll(entityId);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("couldn't read file: " + entityId, e);
        }
        catch (IOException e) {
            throw new RuntimeException("could not read file: " + entityId);
        }
    }

    private List<String> loadAll(String entityId) throws IOException {
        SqlRowSet rs = this.jdbc.queryForRowSet("SELECT PicturePath FROM HLOPictures \n WHERE [CODE] = ?", new Object[]{entityId});
        ArrayList<String> result = new ArrayList<String>();
        Base64.Encoder encoder = Base64.getEncoder();
        while (rs.next()) {
            String pathStr = rs.getString("PicturePath");
            if (ConvertStr.isNullOrEmpty((String)pathStr)) continue;
            Path path = Paths.get(pathStr, new String[0]);
            String base64File = encoder.encodeToString(Files.readAllBytes(path));
            result.add(base64File);
        }
        return result;
    }

    public long getSize(FileData fileData) {
        return new File(fileData.getFilePath()).length();
    }
}

