/*
 * Decompiled with CFR 0.152.
 */
package com.android.files.domain.model;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FileData {
    private String id;
    private byte[] fileData;
    private String filePath;
    private String packName;
    private long fileSize;

    public String name() {
        return String.valueOf(this.id);
    }

    public Map<String, Object> toMap() {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        result.put("id", this.id);
        result.put("packName", this.packName);
        result.put("fileSize", this.fileSize);
        return result;
    }

    public String fetchIdWithExtension() {
        return this.id + ".png";
    }

    public String getId() {
        return this.id;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getPackName() {
        return this.packName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setPackName(String packName) {
        this.packName = packName;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileData)) {
            return false;
        }
        FileData other = (FileData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getFileSize() != other.getFileSize()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (!Arrays.equals(this.getFileData(), other.getFileData())) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        String this$packName = this.getPackName();
        String other$packName = other.getPackName();
        return !(this$packName == null ? other$packName != null : !this$packName.equals(other$packName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $fileSize = this.getFileSize();
        result = result * 59 + (int)($fileSize >>> 32 ^ $fileSize);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        result = result * 59 + Arrays.hashCode(this.getFileData());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        String $packName = this.getPackName();
        result = result * 59 + ($packName == null ? 43 : $packName.hashCode());
        return result;
    }

    public String toString() {
        return "FileData(id=" + this.getId() + ", fileData=" + Arrays.toString(this.getFileData()) + ", filePath=" + this.getFilePath() + ", packName=" + this.getPackName() + ", fileSize=" + this.getFileSize() + ")";
    }

    public FileData(String id, byte[] fileData, String filePath, String packName, long fileSize) {
        this.id = id;
        this.fileData = fileData;
        this.filePath = filePath;
        this.packName = packName;
        this.fileSize = fileSize;
    }
}

