/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.data.repo;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.BaseError;
import com.android.core.domain.model.BaseResponse;
import com.android.core.domain.model.GenericResponse;
import com.android.core.domain.model.RequestData;
import com.android.invoice.domain.AInvoiceType;
import com.android.invoice.domain.model.AInvoiceDto;
import com.android.invoice.domain.use_case.DeleteInvoice;
import com.android.invoice.domain.use_case.discount.CalcCommission;
import com.android.invoice.domain.use_case.discount.CalcDiscount;
import com.android.invoice.domain.use_case.invoice.MakeInvoiceQuery;
import com.android.invoice.domain.use_case.invoice.QueryInvoices;
import com.android.invoice.domain.use_case.invoice.post.CheckInvoiceErrors;
import com.android.invoice.domain.use_case.invoice.post.InsertAInvoice;
import com.android.invoice.domain.use_case.invoice.post.InsertAInvoiceDtl;
import com.android.invoice.domain.use_case.invoice.post.InsertAInvoiceProcess;
import com.android.payment.domain.use_case.InsertInvoiceChequeUseCase;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.CollectionBinder;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.Paging;
import com.utility.Pair;
import com.utility.TncException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
public class InvoiceRepository
extends AndroidRepository<AInvoiceDto> {
    private final ApplicationContext context;
    @Resource
    @Lazy
    private QueryInvoices queryInvoices;
    @Resource
    @Lazy
    private MakeInvoiceQuery makeInvoiceQuery;
    private CheckInvoiceErrors checkInvoiceErrors;
    private InsertAInvoiceDtl insertAInvoiceDtl;
    private InsertAInvoice insertAInvoice;
    private InsertAInvoiceProcess insertAInvoiceProcess;
    private InsertInvoiceChequeUseCase insertChequeUseCase;

    public InvoiceRepository(DbConnection dbConnection, ApplicationContext context) {
        super(dbConnection);
        this.context = context;
    }

    public BaseResponse<AInvoiceDto> customQueryAsObject(RequestData request, Paging paging, LoginDto login) {
        String sql = this.makeSql(request, paging, login);
        if (sql == null) {
            return null;
        }
        List result = this.queryInvoices.invoke(sql, login, request);
        return new BaseResponse.Builder().data(result).totalCount(this.getTotalCount()).totalPages(this.getTotalPages()).build();
    }

    @Nullable
    protected Paging.PageSqlData queryWithDefaultPaging(RequestData request, SettingLoader settingsLoader) {
        return this.makeInvoiceQuery.invoke(request, settingsLoader.getLogin());
    }

    public BaseResponse<GenericResponse> insertAll(@NotNull List<AInvoiceDto> items, LoginDto login) {
        this.checkInvoiceErrors = (CheckInvoiceErrors)this.context.getBean(CheckInvoiceErrors.class);
        this.insertAInvoiceDtl = (InsertAInvoiceDtl)this.context.getBean(InsertAInvoiceDtl.class);
        this.insertAInvoice = (InsertAInvoice)this.context.getBean(InsertAInvoice.class);
        this.insertAInvoiceProcess = (InsertAInvoiceProcess)this.context.getBean(InsertAInvoiceProcess.class);
        this.insertChequeUseCase = (InsertInvoiceChequeUseCase)this.context.getBean(InsertInvoiceChequeUseCase.class);
        return super.insertAll(items, login);
    }

    protected BaseResponse<GenericResponse> insert(AInvoiceDto invoice, LoginDto login, TransactionStatus status) throws TncException {
        InsertAInvoiceDtl.Result rcvArtsResult;
        BaseResponse.Builder response = new BaseResponse.Builder();
        invoice.setClientId(invoice.getId());
        this.setInvoiceTypeName(invoice);
        if (ConvertStr.parseNullSafeLong((String)invoice.getServerId()) > 0L) {
            this.deleteFormerInvoice(invoice.getServerId(), invoice.getAInvoiceTypeName());
        }
        try {
            this.checkInvoiceErrors.invoke(invoice);
            if (!ConvertStr.isNullOrEmpty((Collection)invoice.getChequeList())) {
                this.insertChequeUseCase.inspectChecks(invoice.getChequeList(), this.dbConnection.getJdbcTemplate());
            }
            invoice.setId(Long.valueOf(this.insertAInvoice.invoke(invoice)));
            rcvArtsResult = this.insertAInvoiceDtl.invoke(invoice, this.getSettingLoader(login));
            if (!ConvertStr.isNullOrEmpty((Collection)invoice.getChequeList())) {
                this.insertChequeUseCase.invoke(Long.valueOf(-1L), invoice.getId(), invoice.getChequeList(), this.dbConnection.getJdbcTemplate());
            }
            this.insertAInvoiceProcess.invoke(invoice);
        }
        catch (Throwable t) {
            status.setRollbackOnly();
            return response.withError(this.buildError(invoice, t)).build();
        }
        GenericResponse.GenericResponseBuilder responseBuilder = this.makeResponseBuilder(invoice);
        CollectionBinder binder = CollectionBinder.builder().build();
        if (rcvArtsResult != null) {
            responseBuilder.moreInfo(ConvertStr.buildMap(map -> {
                map.put("clientArtCodes", binder.justBind((Collection)rcvArtsResult.getClientArtCodes()));
                map.put("serverArtCodes", binder.justBind((Collection)rcvArtsResult.getServerArtCodes()));
            }));
        }
        return response.data((Object)responseBuilder.build()).build();
    }

    private void deleteFormerInvoice(String serverId, AInvoiceType type) {
        DeleteInvoice deleteInvoice = (DeleteInvoice)this.context.getBean(DeleteInvoice.class);
        deleteInvoice.invoke(serverId, type);
    }

    private void setInvoiceTypeName(AInvoiceDto invoice) {
        invoice.setAInvoiceTypeName(AInvoiceType.find((Integer)invoice.getInvoiceType()));
    }

    private BaseError buildError(@NotNull AInvoiceDto invoice, Throwable mainException) {
        TncException e = TncException.fromException((Throwable)mainException);
        if (invoice.getId() > 0L) {
            e.putMoreInfo("id", (Object)invoice.getCode());
        }
        e.putMoreInfo("errorDetail", (Object)("MESSAGE = " + mainException.getMessage() + " CAUSE = " + mainException.getCause()));
        return e.makeAndroidError();
    }

    @NotNull
    private GenericResponse.GenericResponseBuilder makeResponseBuilder(@NotNull AInvoiceDto invoice) {
        return GenericResponse.builder().id(invoice.getCode()).generatedCode(ConvertStr.nullSafeLong((Long)invoice.getId()).toString()).requestIdentifier(ConvertStr.nullSafeLong((Long)invoice.getClientId()).toString()).clientId(invoice.getClientId().longValue()).code(invoice.getCode());
    }

    public BaseResponse<Map<String, Object>> calcDiscount(AInvoiceDto dto) {
        CalcDiscount calcDiscount = (CalcDiscount)this.context.getBean(CalcDiscount.class);
        CalcCommission calcCommission = (CalcCommission)this.context.getBean(CalcCommission.class);
        BaseResponse.Builder response = new BaseResponse.Builder();
        try {
            Pair discountResult = calcDiscount.invoke(dto);
            return response.data((Object)ConvertStr.buildMap(map -> {
                map.put("discount", discountResult.getLeft());
                map.put("commission", calcCommission.invoke(dto, ((Double)discountResult.getRight()).doubleValue()));
            })).build();
        }
        catch (TncException e) {
            return response.withError(e.makeAndroidError()).build();
        }
    }

    public BaseResponse<GenericResponse> deleteInvoice(String invoiceId, int invoiceType) {
        BaseResponse.Builder response = new BaseResponse.Builder();
        try {
            this.deleteFormerInvoice(invoiceId, AInvoiceType.find((Integer)invoiceType));
            return response.data((Object)GenericResponse.builder().message("deleted successfully").code("200").build()).build();
        }
        catch (TncException e) {
            return response.withError(e.makeAndroidError()).build();
        }
    }
}

