/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.data.repo;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.BaseError;
import com.android.core.domain.model.BaseResponse;
import com.android.core.domain.model.GenericResponse;
import com.android.core.domain.model.RequestData;
import com.android.invoice.data.ResAInvoiceProcess;
import com.android.invoice.data.repo.ArticleExistUtil;
import com.android.invoice.domain.model.res_invoice.AResInvoiceDtlDto;
import com.android.invoice.domain.model.res_invoice.AResInvoiceDto;
import com.android.invoice.domain.model.res_invoice.ResInvoiceProcessDto;
import com.android.invoice.domain.model.res_invoice.ResInvoiceProcessDtoKt;
import com.android.invoice.domain.use_case.res_invoice.GetResInvoices;
import com.android.product.data.repository.ProductUtils;
import com.dao.SarfaslDao;
import com.dao.process.ProcessDao;
import com.dao.restaurant.ResTableDao;
import com.dao.use_case.OnlineFactureUseCase;
import com.dto.LoginDto;
import com.google.gson.Gson;
import com.service.SettingLoader;
import com.service.invoice.CheckPayError;
import com.utility.ConvertStr;
import com.utility.DateUtils;
import com.utility.DbConnection;
import com.utility.GetIdentity;
import com.utility.LockCode;
import com.utility.LockReader;
import com.utility.Paging;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import com.utility.TncLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
public class ResInvoiceRepository
extends AndroidRepository<AResInvoiceDto> {
    @Resource
    @Lazy
    private GetResInvoices getResInvoices;
    @Resource
    @Lazy
    private OnlineFactureUseCase onlineFactureUseCase;

    public ResInvoiceRepository(DbConnection dbConnection) {
        super(dbConnection);
    }

    public BaseResponse<Map<String, Object>> customQuery(RequestData request, Paging paging, LoginDto login) {
        return this.getResInvoices.invoke(request, login);
    }

    protected BaseResponse<GenericResponse> insert(@NotNull AResInvoiceDto resInvoice, LoginDto login, TransactionStatus status) throws TncException {
        BaseResponse.Builder response = new BaseResponse.Builder();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, login);
        resInvoice.setType(1);
        resInvoice.setServiceCommission(settingLoader.getServicePercent());
        try {
            if (settingLoader.userNotAllowedToPost()) {
                throw new TncException(TncExceptionMessages.CANNOT_POST_RES_INVOICE_UNTIL_ACCEPTED);
            }
            if (!login.isAndroid() && settingLoader.userNotAllowedToPostTakForoshi()) {
                throw new TncException(TncExceptionMessages.CANNOT_POST_RES_INVOICE_UNTIL_ACCEPTED);
            }
            if (resInvoice.isRetail()) {
                resInvoice.setPartycode(ConvertStr.decrypt((String)resInvoice.getPartycode()));
            } else if (ConvertStr.isNullOrEmpty((String)resInvoice.getPartycode())) {
                String defaultCustomer = settingLoader.getDefaultCustomer();
                if (!ConvertStr.isNullOrEmpty((String)defaultCustomer)) {
                    resInvoice.setPartycode(defaultCustomer);
                } else {
                    if (settingLoader.isSelectPartyEnabled()) {
                        throw new TncException(TncExceptionMessages.CUSTOMER_MUST_BE_FILLED);
                    }
                    throw new TncException(TncExceptionMessages.SELECT_ANDROID_DEFAULT_CUSTOMER);
                }
            }
            if (ConvertStr.isNullOrEmpty((String)resInvoice.getPartycode()) || this.customerNotExists(resInvoice.getPartycode(), jdbcTemplate)) {
                throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
            }
            resInvoice.setServiceCommission(settingLoader.getServicePercent());
            this.checkForErrorsInResInvoice(jdbcTemplate, resInvoice);
            resInvoice.setCode(this.nextFCodeC(jdbcTemplate, resInvoice.getFacType()));
            String[] dateTime = resInvoice.getInvoiceDate().split(" ");
            if (!ConvertStr.isNullOrEmpty((String)dateTime[1]) && dateTime[1].length() > 5) {
                dateTime[1] = dateTime[1].substring(0, 5);
            }
            String sqlStr = "INSERT INTO RES_FACTURE (F_TYPE,F_Nesieh, F_CODE_C, F_DATE, F_TIME, DESK_NAME, C_CODE, Alias_Name, F_COMMENT, USERCODE, F_NAGHD, F_POS, POS_CODE, FAC_TYPE, DARSADSERVICE, MONEY_CODE, MONEY_PRICE,ALIAS_MOBILE, BON_PRICE, BON_NO, C_CODE_PEIK, OUTER_ORD, ExporterSId, TasviehDate, F_TAKHFIF,HlpFieldL, IS_OnlineFacture, GuestCount) VALUES(" + resInvoice.getType() + "," + resInvoice.getCreditAmount() + "," + resInvoice.getCode() + ",'" + dateTime[0] + "','" + dateTime[1] + "','" + resInvoice.getTableName() + "','" + resInvoice.getPartycode() + "'," + ConvertStr.toQuotedSqlStr((String)resInvoice.getAliasName()) + "," + ConvertStr.toQuotedSqlStr((String)resInvoice.getDescription()) + ",'" + login.getUserCodeInc() + "'," + resInvoice.getCashAmount() + "," + resInvoice.getPosAmount() + "," + ConvertStr.toQuotedSqlStr((String)resInvoice.getPosHeading()) + ",'" + resInvoice.getFacType() + "'," + resInvoice.getServiceCommission() + ", 1, 1, " + ConvertStr.toQuotedSqlStr((String)resInvoice.getAliasMobile()) + "," + resInvoice.getCouponPrice() + "," + ConvertStr.toQuotedSqlStr((String)resInvoice.getCouponNumber()) + ", '00000', " + ConvertStr.boolToBit((Boolean)resInvoice.isIstakeaway()) + ", " + resInvoice.getId() + ", " + resInvoice.getSettleDate() + ", " + resInvoice.getServerDiscountPrice() + ", 1," + ConvertStr.boolToBit((Boolean)resInvoice.isIsonlinefacture()) + ", " + resInvoice.getGuestCount() + ")";
            jdbcTemplate.execute(sqlStr);
            long id = GetIdentity.invoke((TncJdbc)jdbcTemplate);
            if (id <= 0L) {
                throw new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            }
            resInvoice.setId(Long.valueOf(id));
            for (int i = 0; i < resInvoice.getDetailInfo().size(); ++i) {
                AResInvoiceDtlDto dtl = (AResInvoiceDtlDto)resInvoice.getDetailInfo().get(i);
                if (!login.isAndroid() && dtl.getPrice() == resInvoice.getCashAmount() + resInvoice.getPosAmount() + resInvoice.getCreditAmount()) {
                    jdbcTemplate.update("update Res_Facture set f_type = 2 where f_code = ?", new Object[]{resInvoice.getId()});
                }
                this.checkForErrorsInResDtl(dtl, jdbcTemplate, settingLoader);
                this.handleDtlCommonParts(dtl, (JdbcTemplate)jdbcTemplate, settingLoader, resInvoice.isRetail());
                ArticleExistUtil.checkExistArticleErrors((AResInvoiceDtlDto)dtl, (TncJdbc)jdbcTemplate, (SettingLoader)settingLoader);
                this.addToDiscount(resInvoice, dtl);
                sqlStr = "INSERT INTO RES_FAC_LIST(F_CODE, FL_INDEX, A_CODE, FL_FEW, FL_PRICE, FL_COMMENT, LEVY, SCOT, DARSAD_TAKHFIF, TAKHFIFSATRIR, DARSAD_TYPE, ART_OUTERORD, SUMTAKHFIFSATRI_P, MinA_Name, Buy_Price) VALUES(" + resInvoice.getId() + "," + (i + 1) + ",'" + dtl.getProductId() + "'," + dtl.getAmount() + "," + dtl.getPrice() + ",'" + dtl.getDescription() + "'," + dtl.getLevy() + "," + dtl.getScot() + "," + ConvertStr.getNonNull((Double)dtl.getDiscountPercent()) + "," + ConvertStr.getNonNull((Double)dtl.getDiscountPrice()) + ", " + ConvertStr.getBoolToInt((Boolean)(!settingLoader.useRialDiscountPercent() ? 1 : 0)) + ", " + ConvertStr.getBoolToInt((Boolean)dtl.getTakeOut()) + ", 0, '" + dtl.getProductName() + "', " + dtl.getBuyPrice() + ")";
                jdbcTemplate.execute(sqlStr);
            }
            if (!login.isAndroid() && resInvoice.getCashAmount() + resInvoice.getPosAmount() + resInvoice.getCreditAmount() + resInvoice.getCouponPrice() > 0.0) {
                jdbcTemplate.update("update Res_Facture set f_type = 2 where f_code = ?", new Object[]{resInvoice.getId()});
            }
            if (!resInvoice.isRetail()) {
                sqlStr = "INSERT INTO RMTEMPFACTURE(FACTID, DESKTITLE, FACTSTYLE, FCACTIONMODE, PRINTCONFIGTYPE, OLDDESKTITLE) VALUES (" + resInvoice.getId() + ", '" + resInvoice.getTableName() + "', 1 , 1, " + resInvoice.getPrintConfigType() + ", '')";
                jdbcTemplate.execute(sqlStr);
            }
            int kindVAT = this.handleCommonFactureParts(resInvoice, settingLoader);
            sqlStr = "UPDATE RES_FACTURE SET SUM_LEVY = ?, SUM_SCOT= ?, F_SUMPRICE = ?, ISLEVYANDSCOT = ?, kind_Vat = ?, F_TAKHFIF = ?, F_SERVICE = ?  WHERE F_CODE = ? AND FType_KF = 'F' and Fac_Type = ?";
            jdbcTemplate.update(sqlStr, new Object[]{resInvoice.getLevy(), resInvoice.getScot(), resInvoice.getSumPrice(), resInvoice.getLevy() + resInvoice.getScot() > 0.0 ? 1 : 0, kindVAT, resInvoice.getServerDiscountPrice(), resInvoice.getServiceCost(), resInvoice.getId(), resInvoice.getFacType()});
            List data = ResInvoiceProcessDtoKt.mapFromAResInvoiceDtl((long)resInvoice.getId(), (List)resInvoice.getDetailInfo(), (JdbcTemplate)jdbcTemplate);
            ArrayList productProcessDtoList = new ArrayList(data);
            ResInvoiceProcessDto resInvoiceProcessDto = new ResInvoiceProcessDto(resInvoice.getCashAmount(), resInvoice.getCreditAmount(), resInvoice.getCouponPrice(), resInvoice.getPosAmount(), resInvoice.getDiscount(), resInvoice.getServiceCost(), null, null, resInvoice.getLevy(), resInvoice.getScot(), resInvoice.getDescription(), productProcessDtoList);
            Gson gson = new Gson();
            byte[] bytes = gson.toJson((Object)resInvoiceProcessDto).getBytes();
            ResAInvoiceProcess resAInvoiceProcess = new ResAInvoiceProcess(this.dbConnection, login, gson.toJson((Object)resInvoice));
            resAInvoiceProcess.insert((Object)resInvoice, bytes, ProcessDao.ProcessKind.ADD);
            return response.data((Object)this.makeSuccessMap(resInvoice)).build();
        }
        catch (Throwable t) {
            status.setRollbackOnly();
            return response.withError(this.buildError(resInvoice, t)).build();
        }
    }

    private void addToDiscount(@NotNull AResInvoiceDto resInvoice, AResInvoiceDtlDto dtl) {
        if (resInvoice.isRetail()) {
            resInvoice.setServerDiscountPrice(resInvoice.getServerDiscountPrice() + this.calculateDiscount(dtl));
        }
    }

    private double calculateDiscount(@NotNull AResInvoiceDtlDto dtl) {
        double sum = dtl.getPrice() * dtl.getAmount();
        return !ConvertStr.isNullOrZero((Double)dtl.getDiscountPercent()) ? sum * dtl.getDiscountPercent() / 100.0 : dtl.getDiscountPrice();
    }

    private boolean customerNotExists(String customerCode, @NotNull TncJdbc jdbcTemplate) {
        SqlRowSet rs = jdbcTemplate.queryForRowSet("SELECT COUNT(*) cnt FROM CUSTOMER WHERE C_CODE = ?", new Object[]{customerCode});
        return !rs.next() || rs.getInt("cnt") == 0;
    }

    private void deleteRmTempForInvoice(@NotNull AResInvoiceDto resInvoice, @NotNull TncJdbc jdbcTemplate) {
        jdbcTemplate.execute("DELETE FROM RmTempFacture  WHERE FactId = " + resInvoice.getId());
        jdbcTemplate.execute("DELETE RMTempFactureDetail WHERE FactId = " + resInvoice.getId());
    }

    @NotNull
    private GenericResponse makeSuccessMap(@NotNull AResInvoiceDto resInvoice, ResTableDao.ActionMode actionMode) {
        GenericResponse.GenericResponseBuilder response = GenericResponse.builder();
        if (resInvoice.getId() != null) {
            response.id(ConvertStr.nullSafeLong((Long)resInvoice.getId()).toString());
        }
        if (resInvoice.getCode() != 0L) {
            response.code(String.valueOf(resInvoice.getCode()));
        }
        if (actionMode != null) {
            response.message(actionMode.getMessage());
        }
        return response.build();
    }

    @NotNull
    private GenericResponse makeSuccessMap(@NotNull AResInvoiceDto resInvoice) {
        return this.makeSuccessMap(resInvoice, null);
    }

    private int handleCommonFactureParts(@NotNull AResInvoiceDto resInvoice, @NotNull SettingLoader settingLoader) {
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(settingLoader.getLogin());
        int kindVat = settingLoader.getKindVAT();
        String sqlStr = "SELECT ROUND(SUM(FL_FEW * FL_PRICE), 0) SUM_PRICE FROM RES_FAC_LIST WHERE F_CODE= ?";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getId()});
        while (rs.next()) {
            resInvoice.setSumPrice(rs.getDouble("SUM_PRICE"));
        }
        resInvoice.setServiceCost((double)Math.round(resInvoice.getSumPrice() * resInvoice.getServiceCommission() / 100.0));
        sqlStr = " SELECT ISNULL(c.Porsant, 0) * SUM(((FL_FEW * FL_PRICE) - (FL_FEW * FL_PRICE * ISNULL(Darsad_Takhfif, 0)/100) - ISNULL(TakhfifSatrir, 0))) /100\n FROM Res_Fac_List l\n LEFT JOIN Res_Facture f ON l.F_Code = f.F_Code\n LEFT JOIN CUSTOMER c ON f.C_Code = c.C_Code\n WHERE f.F_Code = '" + resInvoice.getId() + "' \n Group by c.porsant";
        double customerDiscount = (Double)jdbcTemplate.queryForObject(sqlStr, Double.class);
        resInvoice.setCustomerDiscount(customerDiscount);
        if (kindVat == 0) {
            sqlStr = " SELECT ROUND((SUM(((FL_FEW * FL_PRICE) - (FL_FEW * FL_PRICE * ISNULL(Darsad_Takhfif, 0)/100) - ISNULL(TakhfifSatrir, 0)) * LEVY / 100)), 0) SUM_LEVY, \n ROUND((SUM(((FL_FEW * FL_PRICE) - (FL_FEW * FL_PRICE * ISNULL(Darsad_Takhfif, 0)/100) - ISNULL(TakhfifSatrir, 0)) * Scot / 100)), 0) SUM_SCOT \n FROM RES_FAC_LIST \n WHERE F_CODE='" + resInvoice.getId() + "'";
            Map sumScotLevyMap = jdbcTemplate.queryForMap(sqlStr);
            resInvoice.setLevy(((Double)sumScotLevyMap.get("SUM_LEVY")).doubleValue());
            resInvoice.setScot(((Double)sumScotLevyMap.get("SUM_SCOT")).doubleValue());
        } else if (kindVat == 1) {
            resInvoice.setLevy((double)Math.round((resInvoice.getSumPrice() - resInvoice.getTotalDiscount()) * settingLoader.getLevyPercent() / 100.0));
            resInvoice.setScot((double)Math.round((resInvoice.getSumPrice() - resInvoice.getTotalDiscount()) * settingLoader.getScotPercent() / 100.0));
        }
        if (!resInvoice.isRetail()) {
            String now = DateUtils.getNowTimeStr();
            sqlStr = "UPDATE RES_DESK SET DESK_OPEN = 1, STATUS = 0 WHERE [ID] = " + resInvoice.getTableId();
            jdbcTemplate.execute(sqlStr);
            sqlStr = "UPDATE RES_RESERVATION SET BUSY = 1 \n WHERE IsNull(BUSY, 0) = 0 AND \n CAST(TIME_IN AS TIME) <= '" + now + "' AND CAST(TIME_OUT AS TIME) >= '" + now + "' \n AND RESERVE_DATE = '" + DateUtils.getTodayStart() + "' AND DESK_ID = " + resInvoice.getTableId();
            jdbcTemplate.execute(sqlStr);
            double sumWithTax = resInvoice.getSumPrice() + resInvoice.getLevy() + resInvoice.getScot();
            double finalRawPrice = sumWithTax - resInvoice.getTotalDiscount();
            double roundedRemains = finalRawPrice - resInvoice.getFinalPrice();
            resInvoice.setServerDiscountPrice(resInvoice.getTotalDiscount() + roundedRemains);
        }
        if (!resInvoice.hasNoPaymentData() && this.unevenPayment(resInvoice)) {
            throw new TncException(TncExceptionMessages.UNEVEN_PAY_AND_TO_PAY_PRICES);
        }
        return kindVat;
    }

    private boolean unevenPayment(@NotNull AResInvoiceDto resInvoice) {
        return resInvoice.getSumPrice() + resInvoice.getScot() + resInvoice.getLevy() - resInvoice.getServerDiscountPrice() != resInvoice.getPosAmount() + resInvoice.getCashAmount() + resInvoice.getCreditAmount() + resInvoice.getCouponPrice();
    }

    private void handleDtlCommonParts(@NotNull AResInvoiceDtlDto dtl, JdbcTemplate jdbcTemplate, SettingLoader settingLoader, boolean isRetail) {
        boolean isCalcVatJ;
        dtl.setProductCode("");
        dtl.setProductName("");
        dtl.setBuyPrice(Double.valueOf(0.0));
        if (dtl.getLevy() == null) {
            dtl.setLevy(Double.valueOf(0.0));
        }
        if (dtl.getScot() == null) {
            dtl.setScot(Double.valueOf(0.0));
        }
        String levy = (isCalcVatJ = settingLoader.isCalcVatJ()) ? " ISNULL(LEVY, 0) " : String.valueOf(settingLoader.getLevyPercent());
        String scot = isCalcVatJ ? " ISNULL(SCOT, 0) " : String.valueOf(settingLoader.getScotPercent());
        String sqlStr = "SELECT A_CODE_C, A_NAME, ISNULL(BUY_PRICE, 0) BUY_PRICE, " + levy + " LEVY, \n" + ProductUtils.INSTANCE.getDiscountSql(settingLoader) + scot + " SCOT, ISNULL(INCLUDE_TAX, 0) INCLUDE_TAX FROM ARTICLE A \n INNER JOIN M_Group M ON SubString(A.A_Code, 1, 2) = M.M_GroupCode \n INNER JOIN S_Group S ON M.M_GroupCode = S.M_GroupCode AND SubString(a.A_Code, 3, 2) = S.S_GroupCode  WHERE A_CODE='" + dtl.getProductId() + "'";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            boolean includeTax;
            if (rs.getString("A_CODE_C") != null) {
                dtl.setProductCode(rs.getString("A_CODE_C"));
            }
            if (rs.getString("A_NAME") != null) {
                dtl.setProductName(rs.getString("A_NAME"));
            }
            dtl.setBuyPrice(Double.valueOf(rs.getDouble("BUY_PRICE")));
            boolean bl = includeTax = !isCalcVatJ || rs.getBoolean("INCLUDE_TAX");
            if (includeTax && dtl.getLevy() == 0.0 && dtl.getScot() == 0.0) {
                dtl.setLevy(Double.valueOf(rs.getDouble("LEVY")));
                dtl.setScot(Double.valueOf(rs.getDouble("SCOT")));
            }
            if (settingLoader.isUsePerRowDiscountPercent() && ConvertStr.isNullOrZero((Double)dtl.getDiscountPercent())) {
                dtl.setDiscountPercent(Double.valueOf(rs.getDouble("DiscountPercent")));
            }
            if (!settingLoader.isUsePerRowDiscountPrice() || !ConvertStr.isNullOrZero((Double)dtl.getDiscountPrice())) continue;
            double amount = 1.0;
            if (!isRetail) {
                amount = dtl.getAmount();
            }
            dtl.setDiscountPrice(Double.valueOf(amount * rs.getDouble("DiscountPrice")));
        }
    }

    private void checkForErrorsInResDtl(@NotNull AResInvoiceDtlDto dtl, TncJdbc jdbcTemplate, SettingLoader settingLoader) throws TncException {
        if (dtl.getProductId() == null) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        String sqlStr = "Select Count(*) cnt From Article where A_Code='" + dtl.getProductId() + "'";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        if (rs.next() && rs.getInt("cnt") == 0) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        if (dtl.getAmount() == null || dtl.getAmount() <= 0.0) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_AMOUNT);
        }
        if (dtl.getPrice() == null) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_PRICE);
        }
        if (dtl.getLevy() != null && dtl.getLevy() < 0.0 || dtl.getScot() != null && dtl.getScot() < 0.0) {
            throw new TncException(TncExceptionMessages.INVALID_LEVY_SCOT);
        }
        if (!settingLoader.isUsePerRowDiscountPercent() || dtl.getDiscountPercent() == null) {
            dtl.setDiscountPercent(Double.valueOf(0.0));
        }
        if (!settingLoader.isDiscountEnabled() || dtl.getDiscountPrice() == null) {
            dtl.setDiscountPrice(Double.valueOf(0.0));
        }
    }

    private void checkForErrorsInResInvoice(TncJdbc jdbcTemplate, @NotNull AResInvoiceDto resInvoice) throws TncException {
        if (!resInvoice.isRetail() && !resInvoice.isIstakeaway()) {
            if (resInvoice.getTableId() <= 0) {
                throw new TncException(TncExceptionMessages.INVALID_TABLE_NUMBER);
            }
            SqlRowSet rs = jdbcTemplate.queryForRowSet("SELECT COUNT(*) cnt FROM RES_DESK WHERE [ID]=" + resInvoice.getTableId());
            if (rs.next() && rs.getInt("CNT") == 0) {
                throw new TncException(TncExceptionMessages.INVALID_TABLE_NUMBER);
            }
            rs = jdbcTemplate.queryForRowSet("SELECT RTrim(LTrim(DESK_NAME)) AS DESK_NAME FROM RES_DESK WHERE [ID]=" + resInvoice.getTableId());
            if (rs.next()) {
                resInvoice.setTableName(rs.getString("DESK_NAME"));
            }
            if ((rs = jdbcTemplate.queryForRowSet(" SELECT COUNT(*) cnt FROM RES_FACTURE WHERE F_TYPE = '1'\n AND FType_KF = 'F' and Fac_Type = ? AND RTrim(LTrim(IsNull(DESK_NAME, ''))) = ?", new Object[]{resInvoice.getFacType(), resInvoice.getTableName()})).next() && rs.getInt("cnt") > 0) {
                throw new TncException(TncExceptionMessages.SELECTED_TABLE_OCCUPIED);
            }
            LockReader lockReader = new LockReader(jdbcTemplate);
            boolean isGiftEnabled = lockReader.isLockEnabled(LockCode.GIFT);
            if (!isGiftEnabled) {
                resInvoice.getDetailInfo().forEach(dtl -> {
                    if (dtl.getPrice() == null || dtl.getPrice() <= 0.0) {
                        throw new TncException(TncExceptionMessages.INVALID_FREE_PRODUCT);
                    }
                });
            }
        }
        if (resInvoice.getType() < 1 || resInvoice.getType() > 2) {
            throw new TncException(TncExceptionMessages.INVALID_INVOICE_TYPE);
        }
        if (resInvoice.getInvoiceDate() == null || DateUtils.parseDate((String)resInvoice.getInvoiceDate()) == null) {
            throw new TncException(TncExceptionMessages.INVALID_DATE);
        }
        this.checkPayments(resInvoice, jdbcTemplate.getLogin());
    }

    private void checkPayments(@NotNull AResInvoiceDto resInvoice, LoginDto login) throws TncException {
        if (resInvoice.hasNoPaymentData()) {
            return;
        }
        new CheckPayError(this.dbConnection, new SarfaslDao(this.dbConnection)).checkAll(CheckPayError.PaymentData.builder().cash(resInvoice.getCashAmount()).cashHeading(resInvoice.getCashHeading()).checkCashHeading(resInvoice.isRetail()).pos(resInvoice.getPosAmount()).posHeading(resInvoice.getPosHeading()).credit(resInvoice.getCreditAmount()).discount(resInvoice.getDiscount()).coupon(resInvoice.getCouponPrice()).couponNumber(resInvoice.getCouponNumber()).build(), login);
    }

    private BaseError buildError(@NotNull AResInvoiceDto resInvoice, Throwable mainException) {
        TncException e = TncException.fromException((Throwable)mainException);
        if (resInvoice.getCode() > 0L) {
            e.putMoreInfo("id", (Object)resInvoice.getCode());
        }
        if (!resInvoice.isRetail()) {
            e.putMoreInfo("errorDetail", (Object)("MESSAGE = " + mainException.getMessage() + " CAUSE = " + mainException.getCause()));
        }
        return e.makeAndroidError();
    }

    protected BaseResponse<GenericResponse> internalEdit(AResInvoiceDto resInvoice, LoginDto myLogin, TransactionStatus status) {
        BaseResponse.Builder response = new BaseResponse.Builder();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, myLogin);
        try {
            AResInvoiceDtlDto dtl;
            if (settingLoader.userNotAllowedToPost()) {
                throw new TncException(TncExceptionMessages.CANNOT_POST_RES_INVOICE_UNTIL_ACCEPTED);
            }
            resInvoice.setId(resInvoice.getServerId());
            this.checkInvoiceEditErrors(jdbcTemplate, resInvoice);
            String sqlStr = "SELECT F_CODE_C, RTrim(LTrim(DESK_NAME)) AS DESK_NAME FROM RES_FACTURE WHERE FType_KF = 'F' and Fac_Type = ? AND F_CODE = ?";
            SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getFacType(), resInvoice.getId()});
            while (rs.next()) {
                resInvoice.setCode((long)rs.getInt("F_CODE_C"));
                resInvoice.setTableName(rs.getString("DESK_NAME"));
            }
            ConcurrentHashMap oldDtls = this.fetchOldDtls(resInvoice, jdbcTemplate);
            for (AResInvoiceDtlDto dtl2 : resInvoice.getDetailInfo()) {
                long clientSentId = dtl2.getId() == null ? -1L : dtl2.getId();
                dtl2.setEdited(this.isDtlEdited(dtl2, (Map)oldDtls));
                dtl2.setOldAmount(this.getOldAmount((AResInvoiceDtlDto)oldDtls.get(clientSentId)));
                dtl2.setOldPrice(this.getOldPrice((AResInvoiceDtlDto)oldDtls.get(clientSentId)));
                dtl2.setNewlyInserted(dtl2.getId() == null);
            }
            boolean someArticlesAreDeleted = oldDtls.size() > resInvoice.getDetailInfo().size();
            sqlStr = "DELETE FROM RES_FAC_LIST WHERE F_CODE = " + resInvoice.getId();
            jdbcTemplate.execute(sqlStr);
            String whereStr = "(SELECT TOP 1 [ID] FROM RMTempFacture WHERE FactID=" + resInvoice.getId() + " AND FactStyle = 1)";
            String deleteTmpDtlStr = " DELETE FROM RMTempFactureDetail WHERE RMTempFactureID=" + whereStr;
            String deleteTmpStr = " DELETE FROM RMTempFacture WHERE FactID=" + resInvoice.getId() + " AND FactStyle = 1";
            sqlStr = deleteTmpDtlStr + " \n " + deleteTmpStr;
            jdbcTemplate.execute(sqlStr);
            boolean shouldMakeTempFact = false;
            Iterator iterator = resInvoice.getDetailInfo().iterator();
            while (iterator.hasNext() && !(shouldMakeTempFact = (dtl = (AResInvoiceDtlDto)iterator.next()).isEdited() || dtl.isNewlyInserted() || someArticlesAreDeleted || resInvoice.hasNoPaymentData())) {
            }
            long tmpId = -1L;
            sqlStr = "INSERT INTO RMTempFacture(FactID, DeskTitle, FactStyle, FCActionMode, PrintConfigType, OldDeskTitle) VALUES (" + resInvoice.getId() + ", '" + resInvoice.getTableName() + "', 1, 3, " + resInvoice.getPrintConfigType() + ", '')";
            jdbcTemplate.execute(sqlStr);
            sqlStr = "SELECT [ID] FROM RMTempFacture WHERE FactId = " + resInvoice.getId() + " AND FactStyle = 1";
            rs = jdbcTemplate.queryForRowSet(sqlStr);
            if (rs.next()) {
                tmpId = rs.getLong("ID");
            }
            int flIndex = 1;
            for (AResInvoiceDtlDto dtl3 : resInvoice.getDetailInfo()) {
                this.checkForErrorsInResDtl(dtl3, jdbcTemplate, settingLoader);
                this.handleDtlCommonParts(dtl3, (JdbcTemplate)jdbcTemplate, settingLoader, resInvoice.isRetail());
                ArticleExistUtil.checkExistArticleErrors((AResInvoiceDtlDto)dtl3, (TncJdbc)jdbcTemplate, (SettingLoader)settingLoader);
                sqlStr = "INSERT INTO RES_FAC_LIST(F_CODE, FL_INDEX, A_CODE, FL_FEW, FL_PRICE, FL_COMMENT, LEVY, SCOT, DARSAD_TAKHFIF, TakhfifSatriR, DARSAD_TYPE, ART_OUTERORD, SUMTAKHFIFSATRI_P, MinA_Name, Buy_Price, SelPriceID) VALUES(" + resInvoice.getId() + ", " + flIndex++ + ", '" + dtl3.getProductId() + "'," + dtl3.getAmount() + "," + dtl3.getPrice() + ",'" + dtl3.getDescription() + "'," + dtl3.getLevy() + "," + dtl3.getScot() + "," + ConvertStr.nullSafeDouble((Double)dtl3.getDiscountPercent()) + "," + ConvertStr.nullSafeDouble((Double)dtl3.getDiscountPrice()) + ", " + ConvertStr.getBoolToInt((Boolean)(!settingLoader.useRialDiscountPercent() ? 1 : 0)) + ", " + ConvertStr.getBoolToInt((Boolean)dtl3.getTakeOut()) + ", 0, '" + dtl3.getProductName() + "', " + dtl3.getBuyPrice() + ", 0)";
                jdbcTemplate.execute(sqlStr);
                rs = jdbcTemplate.queryForRowSet(" Select SCOPE_IDENTITY() fl_inc ");
                if (!rs.next()) continue;
                dtl3.setNewId(Long.valueOf(rs.getLong("fl_inc")));
            }
            if (shouldMakeTempFact && tmpId != -1L) {
                StringBuilder sb = new StringBuilder("INSERT INTO RMTempFactureDetail (RMTempFactureId, OldAmount, FCDetailId, RowStatus, A_CODE, FL_PRICE, FactID, FactStyle) VALUES");
                List changedDtlList = this.findChangedDtlRows(resInvoice.getDetailInfo(), (Map)oldDtls);
                for (AResInvoiceDtlDto dtl4 : changedDtlList) {
                    sb.append("(").append(tmpId).append(",").append(dtl4.getOldAmount() == 0.0 ? dtl4.getAmount().doubleValue() : dtl4.getOldAmount()).append(",").append(dtl4.getNewId()).append(",'").append(this.calculateRowStatus(dtl4)).append("','").append(dtl4.getProductId()).append("',").append(dtl4.getPrice()).append(",").append(resInvoice.getId()).append(", 1),");
                }
                if (!changedDtlList.isEmpty()) {
                    jdbcTemplate.execute(ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)sb, (String)",").toString());
                }
                jdbcTemplate.update("UPDATE RMTempFacture SET FCActionMode =\n(CASE WHEN (SELECT COUNT(RowStatus)\nFROM RMTempFactureDetail\nWHERE RMTempFactureId = ? AND (RowStatus = 1 OR RowStatus = 0)) = 0\nTHEN '2' ELSE '3' END) WHERE FactId = ?", new Object[]{tmpId, resInvoice.getId()});
            }
            sqlStr = "UPDATE RES_FACTURE SET F_TAKHFIF = ?  WHERE F_CODE = ?";
            jdbcTemplate.update(sqlStr, new Object[]{resInvoice.getServerDiscountPrice(), resInvoice.getId()});
            int kindVat = this.handleCommonFactureParts(resInvoice, settingLoader);
            if (settingLoader.isDiscountEnabled()) {
                rs = jdbcTemplate.queryForRowSet(" SELECT SUM(ISNULL(TakhfifSatriR , 0)) PerRowDiscountR, SUM((FL_FEW * FL_PRICE * ISNULL(DARSAD_TAKHFIF , 0)) / 100) DiscountPercent FROM RES_FAC_LIST WHERE F_CODE='" + resInvoice.getId() + "'");
                double discountSatriR = 0.0;
                while (rs.next()) {
                    if (rs.getDouble("PerRowDiscountR") > 0.0) {
                        discountSatriR = rs.getDouble("PerRowDiscountR");
                        continue;
                    }
                    discountSatriR = rs.getDouble("DiscountPercent");
                }
                resInvoice.setDiscount(discountSatriR);
            }
            if (resInvoice.getDescription() == null) {
                resInvoice.setDescription("");
            }
            if (resInvoice.getPosHeading() == null) {
                resInvoice.setPosHeading("");
            }
            if (resInvoice.isRetail()) {
                resInvoice.setPartycode(ConvertStr.decrypt((String)resInvoice.getPartycode()));
            } else if (ConvertStr.isNullOrEmpty((String)resInvoice.getPartycode())) {
                String defaultCustomer = settingLoader.getDefaultCustomer();
                if (!ConvertStr.isNullOrEmpty((String)defaultCustomer)) {
                    resInvoice.setPartycode(defaultCustomer);
                } else {
                    if (settingLoader.isSelectPartyEnabled()) {
                        throw new TncException(TncExceptionMessages.CUSTOMER_MUST_BE_FILLED);
                    }
                    throw new TncException(TncExceptionMessages.SELECT_ANDROID_DEFAULT_CUSTOMER);
                }
            }
            if (ConvertStr.isNullOrEmpty((String)resInvoice.getPartycode()) || this.customerNotExists(resInvoice.getPartycode(), jdbcTemplate)) {
                throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
            }
            sqlStr = " UPDATE RES_FACTURE SET  SUM_LEVY = " + resInvoice.getLevy() + ", SUM_SCOT = " + resInvoice.getScot() + ", F_NAGHD = " + resInvoice.getCashAmount() + ", F_NESIEH = " + resInvoice.getCreditAmount() + ", F_TAKHFIF = " + resInvoice.getServerDiscountPrice() + ", F_POS = " + resInvoice.getPosAmount() + ", POS_CODE = " + ConvertStr.toQuotedSqlStr((String)resInvoice.getPosHeading()) + ", F_SERVICE = " + resInvoice.getServiceCost() + ", F_SUMPRICE = " + resInvoice.getSumPrice() + ", F_COMMENT = '" + resInvoice.getDescription() + "', KIND_VAT = '" + kindVat + "', DARSADSERVICE = " + resInvoice.getServiceCommission() + ", ISLEVYANDSCOT = " + (resInvoice.getLevy() + resInvoice.getScot() > 0.0 ? 1 : 0) + ", ALIAS_NAME = " + ConvertStr.toQuotedSqlStr((String)resInvoice.getAliasName()) + ", ALIAS_MOBILE = " + ConvertStr.toQuotedSqlStr((String)resInvoice.getAliasMobile()) + ", TasviehDate = " + resInvoice.getSettleDate() + ", UserCode = " + myLogin.getUserCodeInc() + ", C_Code = '" + resInvoice.getPartycode() + "', IS_OnlineFacture = " + ConvertStr.boolToBit((Boolean)resInvoice.isIsonlinefacture()) + ", GuestCount = " + resInvoice.getGuestCount() + " WHERE F_CODE = ? AND FType_KF = 'F' AND Fac_Type = ? ";
            jdbcTemplate.update(sqlStr, new Object[]{resInvoice.getId(), resInvoice.getFacType()});
            List data = ResInvoiceProcessDtoKt.mapFromAResInvoiceDtl((long)resInvoice.getId(), (List)resInvoice.getDetailInfo(), (JdbcTemplate)jdbcTemplate);
            ArrayList productProcessDtoList = new ArrayList(data);
            ResInvoiceProcessDto resInvoiceProcessDto = new ResInvoiceProcessDto(resInvoice.getCashAmount(), resInvoice.getCreditAmount(), resInvoice.getCouponPrice(), resInvoice.getPosAmount(), resInvoice.getDiscount(), resInvoice.getServiceCost(), null, null, resInvoice.getLevy(), resInvoice.getScot(), resInvoice.getDescription(), productProcessDtoList);
            Gson gson = new Gson();
            byte[] bytes = gson.toJson((Object)resInvoiceProcessDto).getBytes();
            ResAInvoiceProcess resAInvoiceProcess = new ResAInvoiceProcess(this.dbConnection, myLogin, gson.toJson((Object)resInvoice));
            resAInvoiceProcess.insert((Object)resInvoice, bytes, ProcessDao.ProcessKind.EDIT);
            response.data((Object)this.makeSuccessMap(resInvoice));
        }
        catch (Throwable t) {
            status.setRollbackOnly();
            response.withError(this.buildError(resInvoice, t));
        }
        return response.build();
    }

    @NotNull
    private ConcurrentHashMap<Long, AResInvoiceDtlDto> fetchOldDtls(@NotNull AResInvoiceDto resInvoice, @NotNull TncJdbc jdbcTemplate) {
        ConcurrentHashMap<Long, AResInvoiceDtlDto> oldDtls = new ConcurrentHashMap<Long, AResInvoiceDtlDto>();
        String sqlStr = "SELECT A_CODE, FL_INC_INDEX, FL_FEW, FL_PRICE, FL_COMMENT, LEVY, SCOT, DARSAD_TAKHFIF, TakhfifSatriR, ART_OuterOrd FROM RES_FAC_LIST WHERE F_CODE=" + resInvoice.getId();
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            double oldFew = rs.getDouble("FL_FEW");
            String oldArtCode = rs.getString("A_CODE");
            oldDtls.put(rs.getLong("FL_INC_INDEX"), AResInvoiceDtlDto.builder().productId(oldArtCode).id(Long.valueOf(rs.getLong("FL_INC_INDEX"))).amount(Double.valueOf(rs.getDouble("FL_FEW"))).price(Double.valueOf(rs.getDouble("FL_PRICE"))).description(rs.getString("FL_COMMENT")).levy(Double.valueOf(rs.getDouble("LEVY"))).scot(Double.valueOf(rs.getDouble("SCOT"))).discountPercent(Double.valueOf(rs.getDouble("DARSAD_TAKHFIF"))).discountPrice(Double.valueOf(rs.getDouble("TakhfifSatriR"))).takeOut(Boolean.valueOf(rs.getBoolean("ART_OuterOrd"))).build());
            jdbcTemplate.execute(sqlStr);
        }
        return oldDtls;
    }

    private double getOldAmount(@Nullable AResInvoiceDtlDto oldDtl) {
        if (oldDtl == null) {
            return 0.0;
        }
        return oldDtl.getAmount();
    }

    private double getOldPrice(@Nullable AResInvoiceDtlDto oldDtl) {
        if (oldDtl == null) {
            return 0.0;
        }
        return oldDtl.getPrice();
    }

    private boolean isDtlEdited(@NotNull AResInvoiceDtlDto dtl, Map<Long, AResInvoiceDtlDto> oldDtlList) {
        if (dtl.getId() == null) {
            return false;
        }
        return dtl.notEquals(oldDtlList.get(dtl.getId()));
    }

    @NotNull
    private List<AResInvoiceDtlDto> findChangedDtlRows(@NotNull List<AResInvoiceDtlDto> newDtlList, Map<Long, AResInvoiceDtlDto> oldDtlMap) {
        ArrayList<AResInvoiceDtlDto> updatedDetails = new ArrayList<AResInvoiceDtlDto>();
        ConcurrentHashMap<Long, AResInvoiceDtlDto> tmpOldMap = new ConcurrentHashMap<Long, AResInvoiceDtlDto>(oldDtlMap);
        for (AResInvoiceDtlDto dtl : newDtlList) {
            if (dtl.getId() == null) {
                updatedDetails.add(dtl);
                continue;
            }
            AResInvoiceDtlDto oldDtl = (AResInvoiceDtlDto)tmpOldMap.remove(dtl.getId());
            if (oldDtl == null) {
                dtl.setNewlyInserted(true);
                updatedDetails.add(dtl);
                continue;
            }
            if (!dtl.notEquals(oldDtl)) continue;
            dtl.setEdited(true);
            updatedDetails.add(dtl);
        }
        updatedDetails.addAll(tmpOldMap.values());
        return updatedDetails;
    }

    private void checkInvoiceEditErrors(TncJdbc jdbcTemplate, @NotNull AResInvoiceDto dto) throws TncException {
        if (dto.getId() == null) {
            throw new TncException(TncExceptionMessages.INVALID_INVOICE_NUMBER);
        }
        String sqlStr = " SELECT F_TYPE FROM RES_FACTURE WHERE FType_KF = 'F' AND Fac_Type = ? AND F_CODE = ?";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{dto.getFacType(), dto.getId()});
        if (!rs.next()) {
            throw new TncException(TncExceptionMessages.INVALID_INVOICE_NUMBER);
        }
        if (rs.getShort("F_TYPE") != 1) {
            throw new TncException(TncExceptionMessages.INVOICE_NUMBER_ALREADY_SETTLED);
        }
        if (dto.getActionMode() < 0 || dto.getActionMode() > 8) {
            throw new TncException(TncExceptionMessages.INCORRECT_ACTION_MODE);
        }
        LockReader lockReader = new LockReader(jdbcTemplate);
        boolean isGiftEnabled = lockReader.isLockEnabled(LockCode.GIFT);
        if (!isGiftEnabled) {
            dto.getDetailInfo().forEach(dtl -> {
                if (dtl.getPrice() == null || dtl.getPrice() <= 0.0) {
                    throw new TncException(TncExceptionMessages.INVALID_FREE_PRODUCT);
                }
            });
        }
        this.checkPayments(dto, jdbcTemplate.getLogin());
    }

    private int calculateRowStatus(@NotNull AResInvoiceDtlDto dtl) {
        if (!dtl.isNewlyInserted()) {
            if (dtl.isEdited()) {
                return 1;
            }
            return 0;
        }
        return 2;
    }

    public BaseResponse<GenericResponse> sendRequest(AResInvoiceDto resInvoice, LoginDto login) {
        return (BaseResponse)this.dbConnection.getTransactionTemplate(login).execute(status -> this.internalSendRequest(resInvoice, login, status));
    }

    private BaseResponse<GenericResponse> internalSendRequest(AResInvoiceDto resInvoice, LoginDto login, TransactionStatus status) {
        BaseResponse.Builder response = new BaseResponse.Builder();
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, login);
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        TncLog log = new TncLog();
        try {
            int printConfigType;
            SqlRowSet rs;
            String sqlStr;
            if (resInvoice.getId() == null || resInvoice.getId() <= 0L) {
                throw new TncException(TncExceptionMessages.INVALID_INVOICE_NUMBER);
            }
            if (settingLoader.userNotAllowedToPost()) {
                throw new TncException(TncExceptionMessages.CANNOT_POST_RES_INVOICE_UNTIL_ACCEPTED);
            }
            ResTableDao.ActionMode actionMode = ResTableDao.ActionMode.find((int)resInvoice.getActionMode());
            if (!actionMode.equals((Object)ResTableDao.ActionMode.DELIVERED)) {
                sqlStr = "SELECT COUNT(F_CODE) CNT FROM RES_FACTURE \n WHERE FType_KF = 'F' and Fac_Type = ? AND F_CODE= ? AND F_TYPE = 1";
                rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getFacType(), resInvoice.getId()});
                int count = -1;
                if (rs.next()) {
                    count = rs.getInt("CNT");
                }
                if (count <= 0) {
                    throw new TncException(TncExceptionMessages.INVOICE_NUMBER_ALREADY_SETTLED);
                }
            }
            if (actionMode.equals((Object)ResTableDao.ActionMode.NONE)) {
                log.info(actionMode + " actionMode number = " + resInvoice.getActionMode());
                throw new TncException(TncExceptionMessages.INCORRECT_ACTION_MODE);
            }
            if (actionMode.equals((Object)ResTableDao.ActionMode.CHANGE_TABLE) && resInvoice.getTableId() <= 0) {
                throw new TncException(TncExceptionMessages.INVALID_TABLE_NUMBER);
            }
            sqlStr = "SELECT LTRIM(RTRIM(DESK_NAME)) AS DESK_NAME, F_CODE_C, IS_OnlineFacture FROM RES_FACTURE WHERE FType_KF = 'F' and Fac_Type = ? AND F_CODE= ?";
            rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getFacType(), resInvoice.getId()});
            String oldTableName = "";
            if (rs.next()) {
                oldTableName = rs.getString("DESK_NAME");
                resInvoice.setCode(rs.getLong("F_CODE_C"));
                resInvoice.setIsonlinefacture(rs.getBoolean("IS_OnlineFacture"));
            }
            String newTableName = "";
            if (actionMode.equals((Object)ResTableDao.ActionMode.CHANGE_TABLE)) {
                sqlStr = "SELECT RTrim(LTrim(DESK_NAME)) AS DESK_NAME FROM RES_DESK WHERE [ID] = ?";
                rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getTableId()});
                if (rs.next()) {
                    newTableName = rs.getString("DESK_NAME");
                }
                long oldDeskId = 0L;
                sqlStr = "SELECT TOP 1 [ID] FROM RES_DESK WHERE [DESK_NAME] = ?";
                rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{oldTableName});
                if (rs.next()) {
                    oldDeskId = rs.getLong("ID");
                }
                sqlStr = "UPDATE RES_FACTURE SET DESK_NAME = ? WHERE FType_KF = 'F' and Fac_Type = ? and F_CODE = ? AND F_TYPE = 1";
                jdbcTemplate.update(sqlStr, new Object[]{newTableName, resInvoice.getFacType(), resInvoice.getId()});
                sqlStr = "UPDATE RES_DESK SET DESK_OPEN = 0 WHERE DESK_NAME = ?";
                jdbcTemplate.update(sqlStr, new Object[]{oldTableName});
                sqlStr = " UPDATE RES_DESK SET DESK_OPEN = 1 WHERE DESK_NAME = ?";
                jdbcTemplate.update(sqlStr, new Object[]{newTableName});
                String now = DateUtils.getNowTimeStr();
                sqlStr = " UPDATE RES_RESERVATION SET DESK_ID = ? \n WHERE CAST(TIME_IN AS TIME) <= '" + now + "' AND CAST(TIME_OUT AS TIME) >= '" + now + "' \n AND RESERVE_DATE = '" + DateUtils.getTodayStart() + "' AND DESK_ID = ?";
                jdbcTemplate.update(sqlStr, new Object[]{resInvoice.getTableId(), oldDeskId});
            } else if (actionMode.equals((Object)ResTableDao.ActionMode.EMPTY_TABLE) || actionMode.equals((Object)ResTableDao.ActionMode.DELIVERED)) {
                this.emptyTheTable(resInvoice, jdbcTemplate, settingLoader);
                response.data((Object)this.makeSuccessMap(resInvoice, actionMode));
                return response.build();
            }
            sqlStr = "SELECT COUNT(FACTID) CNT FROM RMTEMPFACTURE WITH(NOLOCK) WHERE FACTID = ? AND FACTSTYLE = 1";
            rs = jdbcTemplate.queryForRowSet(sqlStr, new Object[]{resInvoice.getId()});
            boolean insert = true;
            while (rs.next()) {
                insert = rs.getInt("CNT") <= 0;
            }
            assert (newTableName != null);
            String oldTableTitleForDB = newTableName.isEmpty() ? "" : oldTableName;
            int n = printConfigType = resInvoice.getPrintConfigType() == -1 ? new SettingLoader(this.dbConnection, login).getPrintConfigType() : resInvoice.getPrintConfigType();
            if (insert) {
                sqlStr = "INSERT INTO RMTEMPFACTURE (FACTID, DeskTitle, FactStyle, FCActionMode,  PrintConfigType, OldDeskTitle) VALUES(?, ?, 1, ?, ?, ?)";
                jdbcTemplate.update(sqlStr, new Object[]{resInvoice.getId(), oldTableName, actionMode.getCode(), printConfigType, oldTableTitleForDB});
            } else {
                sqlStr = "UPDATE RMTEMPFACTURE SET DeskTitle = ?, FactStyle = 1, FCActionMode = ?, PrintConfigType = ? , OldDeskTitle = ? WHERE FactID = ?";
                jdbcTemplate.update(sqlStr, new Object[]{oldTableName, actionMode.getCode(), printConfigType, oldTableTitleForDB, resInvoice.getId()});
            }
            response.data((Object)this.makeSuccessMap(resInvoice, actionMode));
        }
        catch (Throwable t) {
            status.setRollbackOnly();
            response.withError(this.buildError(resInvoice, t));
        }
        return response.build();
    }

    public BaseResponse<GenericResponse> postMessage(String message, int printConfigType, LoginDto login) {
        return (BaseResponse)this.dbConnection.getTransactionTemplate(login).execute(status -> this.internalPostMessage(message, printConfigType, login, status));
    }

    private BaseResponse<GenericResponse> internalPostMessage(String message, int printConfigType, LoginDto login, TransactionStatus status) {
        BaseResponse.Builder response = new BaseResponse.Builder();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        ResTableDao.ActionMode actionMode = ResTableDao.ActionMode.find((int)12);
        try {
            if (ConvertStr.isNullOrEmpty((String)message)) {
                throw new TncException(TncExceptionMessages.MESSAGE_IS_EMPTY);
            }
            String sqlStr = "INSERT INTO RMTEMPFACTURE (FactId, FCActionMode, PrintConfigType, Message, UserCodeInc) VALUES(?, ?, ?, ?, ?)";
            jdbcTemplate.update(sqlStr, new Object[]{-1, actionMode.getCode(), printConfigType, message, login.getUserCodeInc()});
            GenericResponse.GenericResponseBuilder successResponse = GenericResponse.builder().message(actionMode.getMessage());
            response.data((Object)successResponse.build());
        }
        catch (Throwable t) {
            status.setRollbackOnly();
            TncException e = TncException.fromException((Throwable)t);
            response.withError(e.makeAndroidError());
        }
        return response.build();
    }

    private void emptyTheTable(AResInvoiceDto resInvoice, TncJdbc jdbcTemplate, SettingLoader settingLoader) {
        this.deleteRmTempForInvoice(resInvoice, jdbcTemplate);
        if (this.duplicateCodeExists(jdbcTemplate, resInvoice)) {
            resInvoice.setCode(this.nextFCodeC(jdbcTemplate, resInvoice.getFacType()));
        }
        if (resInvoice.isIsonlinefacture()) {
            this.onlineFactureUseCase.convertToOnlineFacture(resInvoice, settingLoader);
        } else {
            jdbcTemplate.update("UPDATE RES_FACTURE SET F_TYPE = 2, isDelivered = 1, F_CODE_C = ? \n WHERE FType_KF = 'F' AND Fac_Type = ? AND F_CODE = ?", new Object[]{resInvoice.getCode(), resInvoice.getFacType(), resInvoice.getId()});
        }
    }

    private boolean duplicateCodeExists(TncJdbc jdbc, AResInvoiceDto resInvoice) {
        SqlRowSet rs = jdbc.queryForRowSet("SELECT COUNT(F_CODE_C) cnt FROM RES_FACTURE \n WHERE F_CODE_C = ? AND F_TYPE = 2 AND FAC_TYPE = ? And F_Code <> ?", new Object[]{resInvoice.getCode(), resInvoice.getFacType(), resInvoice.getId()});
        return rs.next() && rs.getInt("cnt") > 0;
    }

    private long nextFCodeC(TncJdbc jdbc, String facType) {
        String sqlStr = " exec sp_Res_FactureMaxF_Code_C;1 '" + facType + "','F' ";
        SqlRowSet rs = jdbc.queryForRowSet(sqlStr);
        if (rs.next()) {
            return rs.getLong("MaxF_Code_C") + 1L;
        }
        return 1L;
    }
}

