/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain;

import com.utility.TncException;
import com.utility.TncExceptionMessages;

/*
 * Exception performing whole class analysis ignored.
 */
public enum AInvoiceType {
    NONE(""),
    ORDER_BUY("K"),
    ORDER_SALE("F"),
    BUY("K"),
    SALE("F"),
    RETURN_FROM_SALE("Y"),
    WASTAGE("Z"),
    RETURN_FROM_BUY("X"),
    DELIVERY_ARTICLE("T");

    private final String typeChar;

    private AInvoiceType(String typeChar) {
        this.typeChar = typeChar;
    }

    public static AInvoiceType find(Integer typeNumber) {
        if (typeNumber == null) {
            return NONE;
        }
        for (AInvoiceType value : AInvoiceType.values()) {
            if (value.ordinal() != typeNumber.intValue()) continue;
            return value;
        }
        return NONE;
    }

    public String getInvoiceTypeForVariety() {
        String varietyType = "0";
        if (this.equals((Object)ORDER_BUY)) {
            return "S";
        }
        if (this.equals((Object)ORDER_SALE)) {
            return "J";
        }
        switch (this.getTypeChar()) {
            case "K": {
                varietyType = "5";
                break;
            }
            case "F": {
                varietyType = "6";
                break;
            }
            case "X": {
                varietyType = "7";
                break;
            }
            case "Y": {
                varietyType = "8";
                break;
            }
            case "Z": {
                varietyType = "4";
            }
        }
        if (varietyType.equals("0")) {
            throw new TncException(TncExceptionMessages.INVALID_INVOICE_TYPE);
        }
        return varietyType;
    }

    public boolean isOrder() {
        return this.equals((Object)ORDER_BUY) || this.equals((Object)ORDER_SALE);
    }

    public String getTypeChar() {
        return this.typeChar;
    }
}

