/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain.param;

import com.android.core.utils.params.Param;
import com.android.core.utils.params.QueryParams;
import com.utility.ConvertStr;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InvoiceParams
extends QueryParams {
    public static final String PARAM_SETTLED_TYPE = "settle-type";
    public static final String PARAM_DATE_FROM = "date-from";
    public static final String PARAM_DATE_TO = "date-to";
    public static final String PARAM_INCLUDE_BUY = "include-buy";
    public static final String PARAM_INCLUDE_SALE = "include-sale";
    public static final String PARAM_INCLUDE_RET_SALE = "include-ret-sale";
    public static final String PARAM_INCLUDE_WASTE = "include-waste";
    public static final String PARAM_SETTLE_DATE_FROM = "settle-date-from";
    public static final String PARAM_SETTLE_DATE_TO = "settle-date-to";
    public static final String PARAM_CUSTOMER_IDS = "customer-ids";
    public static final String PARAM_PRODUCT_CODES = "product-codes";

    @NotNull
    protected Param[] validParamsIgnoreCase() {
        return (Param[])ConvertStr.arrayOf((Object[])new Param[]{new Param.Builder(PARAM_DATE_FROM).withCustomQuery(dateFrom -> "CAST(f.FDateTime AS DATE) >= '" + dateFrom + "'").build(), new Param.Builder(PARAM_DATE_TO).withCustomQuery(dateTo -> "CAST(f.FDateTime AS DATE) <= '" + dateTo + "'").build(), new Param.Builder(PARAM_SETTLE_DATE_FROM).withCustomQuery(date -> "CAST(f.TasviehDate AS DATE) >= '" + date + "'").build(), new Param.Builder(PARAM_SETTLE_DATE_TO).withCustomQuery(date -> "CAST(f.TasviehDate AS DATE) <= '" + date + "'").build(), new Param.Builder("C_CODE", PARAM_CUSTOMER_IDS, "f", "TmpFacture").build()});
    }

    protected List<List<Param>> validParamGroupsOfOr() {
        return ConvertStr.buildList(list -> list.add(this.buildFTypeGroup()));
    }

    private List<Param> buildFTypeGroup() {
        return ConvertStr.buildList(list -> {
            list.add(new Param.Builder(PARAM_INCLUDE_BUY).withCustomQuery(incRetSale -> "(f.Fac_CodeK = 0 AND f.FType = 'K')").build());
            list.add(new Param.Builder(PARAM_INCLUDE_SALE).withCustomQuery(incRetSale -> "(f.Fac_CodeF = 0 AND f.FType = 'F')").build());
            list.add(new Param.Builder(PARAM_INCLUDE_WASTE).withCustomQuery(incRetSale -> "(f.Fac_CodeZ = 0 AND f.FType = 'Z')").build());
            list.add(new Param.Builder(PARAM_INCLUDE_RET_SALE).withCustomQuery(incRetSale -> "(f.Fac_CodeY = 0 AND f.FType = 'Y')").build());
        });
    }
}

