/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain.use_case.invoice;

import com.android.core.domain.model.RequestData;
import com.android.core.utils.params.AndroidFilter;
import com.android.core.utils.params.QueryParamTypes;
import com.android.invoice.domain.use_case.invoice.InvoiceParamsHolder;
import com.android.invoice.domain.use_case.invoice.InvoiceReportType;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.DbConnection;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class GetHLOInvoice {
    private final DbConnection dbConnection;

    public String invoke(RequestData request, LoginDto login) {
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, login);
        AndroidFilter filter = new AndroidFilter(request, QueryParamTypes.HLO_INVOICE);
        String strWhere = filter.getFilter();
        InvoiceParamsHolder params = InvoiceParamsHolder.mapToUserParam((Map)filter.makeUserParamMap(false));
        if (params.getSettleType().equals((Object)InvoiceReportType.SYNC_NOT_SETTLED)) {
            return "";
        }
        String sql = " SELECT f.Fac_Code AS id, f.C_Code AS partyCode, \n f.Fac_code_c AS code, f.Fac_Date AS invoiceDate, u.Name as owner, \n CASE isNull(f.Fac_Type, 'F') \n WHEN 'K' THEN 0 WHEN 'F' THEN 1 WHEN 'Z' THEN 1 WHEN 'Y' THEN 0 END AS stockInfluence, \n CASE isNull(f.Fac_Type, 'F') \n WHEN 'K' then 1 WHEN 'F' THEN  2 when 'Z' Then 4 When 'Y' then 3 END AS factConfigId, \n (SELECT Sum(Few_article * Price_bs) \n  FROM factart WHERE Fac_code = f.Fac_code And fac_Type = f.Fac_type \n ) AS finalPrice, \n f.Fac_Code AS serverId, f.Fac_Comment AS [description], \n CONVERT(nvarchar(10), f.Fac_Date, 120) AS deliveryDate, \n CONVERT(nvarchar(8), f.FAC_DATE, 108) as deliveryTime, \n isNull(f.Takhfif, 0) AS discountPrice, 0 AS serverDiscountPrice, 0 AS serverCommissionPrice, \n isNull(HlpFieldL, 0) isInvoiceSettled, isNull(TasviehDate,'') settlementDate, \n isNull(FNaghd, 0.0) cashAmount, isNull(FNesieh, 0.0) creditAmount, \n isNull(Card, 0.0) posAmount, '' cashRegHeading, '' accountHeading, \n f.Fac_Type [type], f.Sum_Levy + f.Sum_Scot taxSum \n FROM FACTURE f \n LEFT JOIN USERDB u ON f.Usercode = u.UserCodeInc \n Where 1=1 ";
        if (params.getSettleType().equals((Object)InvoiceReportType.REPORT_NOT_SETTLED)) {
            sql = sql + " And (IsNull(TasviehDate, '') <> '' And (HlpFieldL = 0 OR HlpFieldL IS NULL) AND FNesieh > 0) ";
            if (!params.getSettleDateFrom().isEmpty()) {
                sql = sql + " And (TasviehDate >= '" + params.getSettleDateFrom() + "')";
            }
            if (!params.getSettleDateTo().isEmpty()) {
                sql = sql + " And (TasviehDate <= '" + params.getSettleDateTo() + "')";
            }
        }
        if (settingLoader.onlyAllowUserInvoicesGetOrEdit()) {
            sql = sql + " And f.UserCode = " + login.getUserCodeInc();
        }
        return sql + (strWhere.isEmpty() ? "" : "\n AND " + strWhere);
    }

    public GetHLOInvoice(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

