/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain.use_case.invoice;

import com.android.core.domain.model.RequestData;
import com.android.core.utils.params.AndroidFilter;
import com.android.core.utils.params.QueryParamTypes;
import com.android.invoice.domain.use_case.invoice.GetHLOInvoice;
import com.android.invoice.domain.use_case.invoice.InvoiceReportType;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.Paging;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class MakeInvoiceQuery {
    private final DbConnection dbConnection;
    private final GetHLOInvoice getHLOInvoice;

    public Paging.PageSqlData invoke(RequestData request, LoginDto login) {
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, login);
        if (settingLoader.isUserForbiddenToFetchInvoices()) {
            return null;
        }
        String whereStr = "WHERE 1 = 1 " + this.getWhereStr(request);
        String sql = " SELECT f.ID AS id, f.C_Code AS partyCode, f.Fac_code_c AS code, \n f.FDateTime AS invoiceDate, u.Name as owner, \n CASE IsNull(f.FType, 'F') WHEN 'K' then 0 WHEN 'F' THEN 1 when 'Z' Then 1 When 'Y' then 0 END AS stockInfluence, \n CASE IsNull(f.FType, 'F') WHEN 'K' then 1 WHEN 'F' THEN 2 when 'Z' Then 4 When 'Y' then 3 END AS factConfigId, \n (Select Sum(A_Few * A_Price) \n From TmpFactart \n where IDFacture = f.ID) AS finalPrice, \n CAST(f.ID AS nvarchar(100)) AS serverId, f.Comment as [description], \n CONVERT(nvarchar(10), f.FDateTime, 120) as deliveryDate, \n CONVERT(nvarchar(8), f.FDateTime, 108) as deliveryTime, \n IsNull(f.Takhfif, 0) AS discountPrice, IsNull(f.serverDiscountPrice, 0) as serverDiscountPrice, \n IsNull(f.serverCommissionPrice, 0) as serverCommissionPrice, 0 isInvoiceSettled, \n IsNull(TasviehDate, '') settlementDate, IsNull(FNaghd, 0.0) cashAmount, \n IsNull(FNesiyeh, 0.0) creditAmount, IsNull(FCard, 0.0) posAmount, \n IsNull(FNaghdSarfasl, '') cashRegHeading, IsNull(FCardSarfasl, '') accountHeading, \n '' [type], Isnull(SumLevy, 0) taxSum \nFROM TmpFacture f \nLEFT JOIN USERDB u ON f.Usercode = u.UserCodeInc \n";
        if (settingLoader.onlyAllowUserInvoicesGetOrEdit()) {
            whereStr = whereStr + " AND f.UserCode = " + login.getUserCodeInc();
        }
        if (settingLoader.onlySendMidManCustomers()) {
            whereStr = whereStr + " AND f.C_Code IN (SELECT C_Code FROM CustomerVaseteh WHERE Vaseteh_Code = " + ConvertStr.toQuotedSqlStr((String)settingLoader.getMidManId()) + ")";
        }
        sql = sql + whereStr;
        String hloInvoice = this.getHLOInvoice.invoke(request, login);
        if (!hloInvoice.isEmpty()) {
            sql = sql + "\n UNION \n" + hloInvoice;
        }
        return Paging.PageSqlData.builder().selectSqlStr(sql).alias("f").keyField("id").build();
    }

    @NotNull
    private String getWhereStr(RequestData request) {
        Map paramMap;
        AndroidFilter filter = new AndroidFilter(request, QueryParamTypes.INVOICE);
        String whereStr = filter.getFilter();
        if (!whereStr.isEmpty() && !whereStr.startsWith(" AND ")) {
            whereStr = " AND " + whereStr;
        }
        if (ConvertStr.parseNullSafeInt((String)(paramMap = filter.makeUserParamMap(false)).getOrDefault("settle-type", "0")) == InvoiceReportType.REPORT_NOT_SETTLED.ordinal()) {
            whereStr = whereStr + " And IsNull(TasviehDate, '') <> '' AND FNesiyeh > 0 ";
        }
        return whereStr;
    }

    public MakeInvoiceQuery(DbConnection dbConnection, GetHLOInvoice getHLOInvoice) {
        this.dbConnection = dbConnection;
        this.getHLOInvoice = getHLOInvoice;
    }
}

