/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain.use_case.invoice.post;

import com.android.invoice.domain.AInvoiceType;
import com.android.invoice.domain.model.AInvoiceDto;
import com.android.order.domain.model.AOrderDto;
import com.customer.domain.use_case.GetCustomerCount;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DateUtils;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.util.Arrays;
import org.springframework.stereotype.Service;

@Service
public class CheckInvoiceErrors {
    private static final String[] allowedTypes = (String[])ConvertStr.arrayOf((Object[])new String[]{"K", "F", "Y", "Z", "T"});
    private final DbConnection dbConnection;
    private final GetCustomerCount getCustomerCount;

    public void invoke(AOrderDto orderDto) throws TncException {
        this.invoke(AInvoiceDto.builder().aInvoiceTypeName(orderDto.getAOrderTypeName()).withNewCustomer(orderDto.isWithNewCustomer()).partyCode(orderDto.getPartyCode()).build());
    }

    public void invoke(AInvoiceDto invoice) throws TncException {
        if (Arrays.stream(allowedTypes).noneMatch(s -> s.equals(invoice.getAInvoiceTypeName().getTypeChar()))) {
            throw new TncException(TncExceptionMessages.INVALID_INVOICE_TYPE);
        }
        this.checkCustomerExists(invoice);
        this.checkNotSettledCustomerInvoice(invoice);
    }

    private void checkNotSettledCustomerInvoice(AInvoiceDto invoice) {
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate();
        String nowDateTimeStr = DateUtils.getNowDateTimeStr();
        Integer maxDateDiffHloInvoice = (Integer)jdbc.queryForObject(" SELECT MAX(DateDiff(day, TasviehDate, '" + nowDateTimeStr + "')) \n FROM FACTURE \n INNER JOIN CUSTOMER ON FACTURE.C_Code = CUSTOMER.C_Code \n WHERE Fac_Type = 'F' AND FACTURE.C_Code = '" + invoice.getPartyCode() + "' \n  AND FACTURE.FNesieh > 0 AND HlpFieldL = 0 \n  AND Facture.TasviehDate < '" + nowDateTimeStr + "'", Integer.class);
        Integer maxDateDiffInvoice = (Integer)jdbc.queryForObject("SELECT MAX(DateDiff(day, TasviehDate, '" + nowDateTimeStr + "' )) \n FROM TmpFacture Tm \n INNER JOIN (SELECT IsNull(SUM(A_few * A_price), 0) Sum_price, IdFacture FROM TmpFactart \n     GROUP BY IdFacture) Fa ON Fa.IdFacture = Tm.Id \n INNER JOIN CUSTOMER ON Tm.C_Code = CUSTOMER.C_Code \n WHERE Tm.FType = 'F' AND Tm.Fac_CodeF = 0 \n AND kind = 0 AND Tm.C_Code = '" + invoice.getPartyCode() + "' \n AND IsNull(TasviehDate, '') <> '' \n AND IsNull(tm.TasviehDate, '') < '" + nowDateTimeStr + "' \n AND (CASE WHEN (FNaghd + FCard + FNesiyeh) = 0 THEN Sum_price ELSE FNesiyeh END) > 0 ", Integer.class);
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, jdbc.getLogin());
        Boolean checkInvoiceDueDatesForCustomer = (Boolean)settingLoader.getUserDBField("TasviehC", (Object)false);
        Boolean checkCustomerUnSettledInvoices = (Boolean)settingLoader.getUserDBField("OpenFNesieh", (Object)false);
        if (checkInvoiceDueDatesForCustomer.booleanValue() && invoice.getAInvoiceTypeName().equals((Object)AInvoiceType.SALE) && ConvertStr.nullSafeInt((Integer)maxDateDiffHloInvoice) > 0 && ConvertStr.nullSafeInt((Integer)maxDateDiffInvoice) > 0) {
            throw new TncException(TncExceptionMessages.EXPIRED_DUE_INVOICE_FOR_CUSTOMER);
        }
        Integer hloInvoiceUnsettledCount = (Integer)jdbc.queryForObject(" SELECT count(*) from FACTURE \n INNER JOIN CUSTOMER on FACTURE.C_Code = CUSTOMER.C_Code WHERE Fac_Type = 'F' \n AND FACTURE.C_Code = '" + invoice.getPartyCode() + "' \n AND FACTURE.FNesieh > 0 AND HlpFieldL = 0 ", Integer.class);
        Integer invoiceUnsettledCount = (Integer)jdbc.queryForObject("SELECT Count(*) from TmpFacture Tm \n INNER JOIN (SELECT IsNull(SUM(A_few * A_price), 0) Sum_price, IdFacture \n  FROM TmpFactart GROUP BY IdFacture) Fa on Fa.IdFacture = Tm.Id \n INNER JOIN CUSTOMER ON Tm.C_Code = CUSTOMER.C_Code \n WHERE Tm.FType = 'F' AND Tm.Fac_CodeF = 0 And kind = 0 \n AND Tm.C_Code = '" + invoice.getPartyCode() + "' \n AND IsNull(TasviehDate, '') <> '' \n AND (CASE WHEN(FNaghd + FCard + FNesiyeh) = 0 THEN Sum_price ELSE FNesiyeh END) > 0", Integer.class);
        if (checkCustomerUnSettledInvoices.booleanValue() && invoice.getAInvoiceTypeName().equals((Object)AInvoiceType.SALE) && ConvertStr.nullSafeInt((Integer)hloInvoiceUnsettledCount) > 0 && ConvertStr.nullSafeInt((Integer)invoiceUnsettledCount) > 0) {
            throw new TncException(TncExceptionMessages.UNSETTLED_INVOICE_FOR_CUSTOMER);
        }
    }

    private void checkCustomerExists(AInvoiceDto invoice) throws TncException {
        if (invoice.isWithNewCustomer()) {
            return;
        }
        int customerCount = this.getCustomerCount.invoke(ConvertStr.buildMap(map -> map.put("code", invoice.getPartyCode())));
        if (customerCount == 0) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
        }
    }

    public CheckInvoiceErrors(DbConnection dbConnection, GetCustomerCount getCustomerCount) {
        this.dbConnection = dbConnection;
        this.getCustomerCount = getCustomerCount;
    }
}

