/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain.use_case.invoice.post;

import com.android.invoice.domain.AInvoiceType;
import com.android.invoice.domain.model.AInvoiceDtlDto;
import com.android.invoice.domain.model.AInvoiceDto;
import com.android.invoice.domain.use_case.invoice.post.InsertADtlVarieties;
import com.android.invoice.domain.use_case.invoice.post.InsertAInvoiceDtl;
import com.android.product.domain.use_case.CheckProductExists;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class InsertAInvoiceDtl {
    private final DbConnection dbConnection;
    private final CheckProductExists checkProductExists;
    Result.ResultBuilder resultBuilder = Result.builder();
    @Resource
    @Lazy
    private InsertADtlVarieties insertADtlVarieties;

    public Result invoke(AInvoiceDto dto, SettingLoader settingLoader) {
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate();
        for (AInvoiceDtlDto dtl : dto.getDtlDto()) {
            dtl.setInvoiceId(String.valueOf(dto.getId()));
            dtl.setType(dto.getAInvoiceTypeName());
            dtl.setRowIndex(Integer.valueOf(dto.getDtlDto().indexOf(dtl) + 1));
            this.doDeliveryArticleOperations(dtl, jdbc);
            this.calcThreeUnitNewAmount(settingLoader, dtl, jdbc);
            this.checkDtlErrors(dtl);
        }
        this.batchInsert(dto.getDtlDto(), jdbc);
        for (AInvoiceDtlDto dtl : dto.getDtlDto()) {
            this.insertADtlVarieties.invoke(dtl.getVarietyList(), dtl);
        }
        return this.resultBuilder.build();
    }

    private void doDeliveryArticleOperations(AInvoiceDtlDto dtl, TncJdbc jdbc) {
        if (!dtl.getType().equals((Object)AInvoiceType.DELIVERY_ARTICLE) || !ConvertStr.nullSafeBool((Boolean)dtl.getIsNewArticle()) || this.productAlreadyInserted(dtl)) {
            return;
        }
        SqlRowSet rs = this.insertDeliveryProducts(dtl, jdbc);
        if (rs != null) {
            this.setDeliveryArtResults(dtl, rs);
        }
    }

    private boolean productAlreadyInserted(AInvoiceDtlDto dtl) {
        int index = this.resultBuilder.getClientArtCodes().indexOf(dtl.getProductCode());
        if (index > -1) {
            dtl.setProductCode((String)this.resultBuilder.getServerArtCodes().get(index));
        }
        return index > -1;
    }

    private void checkDtlErrors(AInvoiceDtlDto dtl) {
        if (!this.checkProductExists.invoke(dtl.getProductCode())) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        if (dtl.getAmount() <= 0.0) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_AMOUNT);
        }
    }

    private void batchInsert(List<AInvoiceDtlDto> dtlList, TncJdbc jdbc) {
        StringBuilder insertSql = new StringBuilder("INSERT INTO TmpFactArt(IDFacture, A_Code, A_few, A_few2, \n A_Few3, A_Price, A_Comment, Unit_Code, TakhfifSatriR, DarsadTakhfif, A_FewKarton, \n A_fewBasteh, Moddat, IsGift, A_index, IsUsingBoxPrice, Levy, selPriceId) \n VALUES ");
        for (AInvoiceDtlDto dtl : dtlList) {
            String description = dtl.getDescription();
            if (description != null) {
                description = description.replace("'", "''");
            }
            insertSql.append("(").append(dtl.getInvoiceId()).append(", ").append("'").append(dtl.getProductCode()).append("', ").append(dtl.getAmount()).append(", ").append(dtl.getSecondAmount()).append(", ").append(dtl.getThirdAmount()).append(", ").append(dtl.getPrice()).append(", ").append(ConvertStr.toQuotedSql((Object)description)).append(", ").append(ConvertStr.toQuotedSqlStr((String)dtl.getUnitCode())).append(", ").append(dtl.getPerRowDiscountAmount()).append(", ").append(dtl.getPerRowDiscountPercent()).append(", ").append(dtl.getBox()).append(", ").append(dtl.getPack()).append(", ").append(dtl.getDue()).append(", ").append(ConvertStr.boolToBit((Boolean)dtl.getIsGift())).append(", ").append(dtl.getRowIndex()).append(", ").append(ConvertStr.boolToBit((Boolean)dtl.getUsingBoxPrice())).append(", ").append(dtl.getSumTax()).append(", ").append(dtl.getPriceIndex()).append("), \n");
        }
        jdbc.execute(ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)insertSql, (String)",").toString());
    }

    private void setDeliveryArtResults(AInvoiceDtlDto dtl, SqlRowSet rs) {
        if (Objects.equals(rs.getString("ErrorId"), "0")) {
            throw new TncException(rs.getString("ErrorMessage"), ConvertStr.parseNullSafeInt((String)rs.getString("ErrorId")));
        }
        this.resultBuilder.addToClientArtCodes(dtl.getProductCode());
        dtl.setProductCode(rs.getString("A_Code"));
        this.resultBuilder.addToServerArtCodes(dtl.getProductCode());
    }

    private SqlRowSet insertDeliveryProducts(AInvoiceDtlDto dtl, TncJdbc jdbc) {
        SqlRowSet rs = jdbc.queryForRowSet("EXEC dbo.SP_InsertArt @A_code = '', \n @GroupCode = '" + dtl.getProductCode().substring(0, 4) + "', \n @A_code_C = '" + dtl.getBarcode() + "', \n @A_Name = '" + dtl.getProductTitle() + "'");
        if (!rs.next()) {
            return null;
        }
        return rs;
    }

    private void calcThreeUnitNewAmount(SettingLoader settingLoader, AInvoiceDtlDto dtl, TncJdbc jdbc) {
        SqlRowSet rs = jdbc.queryForRowSet("SELECT isNull(Karton, 0) [box], isNull(basteh, 0) [pack], isNull(Moddat, 0) [due] \n FROM Article WHERE A_CODE = ?", new Object[]{dtl.getProductCode()});
        if (!rs.next()) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        double tmpAmount = dtl.getAmount();
        dtl.setBox(rs.getDouble("box"));
        dtl.setPack(rs.getDouble("pack"));
        dtl.setDue(rs.getDouble("due"));
        if (settingLoader.isThreeUnitEnabled() && settingLoader.isThreeUnitNewEnabled()) {
            tmpAmount = dtl.getSecondAmount() * dtl.getBox() * dtl.getPack() + dtl.getThirdAmount() * dtl.getPack() + dtl.getAmount();
        }
        dtl.setAmount(tmpAmount);
    }

    public InsertAInvoiceDtl(DbConnection dbConnection, CheckProductExists checkProductExists) {
        this.dbConnection = dbConnection;
        this.checkProductExists = checkProductExists;
    }
}

