/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain.use_case.res_invoice;

import com.android.core.domain.model.BaseResponse;
import com.android.core.domain.model.RequestData;
import com.android.core.utils.params.AndroidFilter;
import com.android.core.utils.params.QueryParamTypes;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.DbConnection;
import com.utility.TncJdbc;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class GetResInvoices {
    private final DbConnection dbConnection;

    public BaseResponse<Map<String, Object>> invoke(RequestData request, LoginDto login) {
        String whereStr = this.getWhereStr(request);
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, login);
        boolean isActiveMenu = settingLoader.isSendActiveResMenuProducts();
        List invoices = this.getInvoices(settingLoader, whereStr, (JdbcTemplate)jdbcTemplate, request);
        List details = this.getDetails(isActiveMenu, whereStr, (JdbcTemplate)jdbcTemplate, request);
        invoices.forEach(invoice -> {
            List list = details.stream().filter(map -> map.get("invoiceId").equals(invoice.get("id"))).collect(Collectors.toList());
            invoice.put("detailInfo", list);
        });
        return new BaseResponse.Builder().data(invoices).build();
    }

    @NotNull
    private String getWhereStr(RequestData request) {
        String whereStr = new AndroidFilter(request, QueryParamTypes.RES_INVOICE).getFilter();
        if (!whereStr.isEmpty()) {
            whereStr = " AND " + whereStr;
        }
        return whereStr;
    }

    @NotNull
    private List<Map<String, Object>> getInvoices(SettingLoader settingLoader, String whereStr, JdbcTemplate jdbcTemplate, RequestData request) {
        boolean isTakeaway = request.getParamMap().containsKey("isTakeaway");
        whereStr = whereStr + " AND rf.F_Type = 1 ";
        if (isTakeaway) {
            whereStr = " AND Outer_Ord = 1 AND ISNULL(isDelivered, 0) = 0 AND ISNULL(ExporterSId, -1) >= 0 ";
            String customerWhere = "";
            if (request.getParamMap().containsKey("cCode") && request.getParamMap().get("cCode") != null) {
                customerWhere = " AND rf.C_Code = " + (String)request.getParamMap().get("cCode");
            }
            whereStr = whereStr + customerWhere;
        }
        String sql = " SELECT rf.F_Code AS id, rf.C_Code AS partyCode, Desk_Name AS tableName, rf.F_Code_C AS code, \n CONVERT(NVARCHAR(50), rf.F_Date, 120) AS invoiceDate, rf.F_Time as invoiceTime, 1 AS stockInfluence, \n rf.F_Comment AS description, IsNull(rf.F_SumPrice, 0) AS finalPrice, rf.F_Code AS serverId, \n" + settingLoader.getPrintConfigType() + " printConfigType, rf.Alias_Name as aliasName, \n ALIAS_MOBILE aliasMobile, u.Name AS [owner], rf.F_Takhfif serverDiscountPrice, \n F_NAGHD cashAmount, F_NESIEH creditAmount, F_Pos posAmount, (CASE WHEN rf.IS_OnlineFacture = 1 THEN 'TRUE' ELSE 'FALSE' END) isOnlineFacture, \n (CASE WHEN rf.Outer_Ord = 1 THEN 'TRUE' ELSE 'FALSE' END) as isTakeaway, IsNULL(GuestCount, 0) guestCount, \n (ISNULL(rf.F_SumPrice, 0) + ISNULL(rf.Sum_Levy, 0) + ISNULL(rf.Sum_Scot, 0)\n + ISNULL(rf.F_Service, 0) + ISNULL(rf.F_Haz1, 0) + ISNULL(rf.F_Haz2, 0)\n - ISNULL(rf.F_Takhfif, 0) - ISNULL(rf.Bon_Price, 0) \n ) totalPrice FROM Res_Facture rf \n INNER JOIN USERDB u ON rf.UserCode = u.UserCodeInc \n WHERE rf.Fac_Type = 'R' \n AND rf.FType_KF = 'F' AND IsNull(u.Res_SaveSpdSel, 0) = 0 \n" + whereStr + " \n ORDER BY rf.F_Code";
        return jdbcTemplate.queryForList(sql);
    }

    @NotNull
    private List<Map<String, Object>> getDetails(boolean isActiveMenu, String whereStr, JdbcTemplate jdbcTemplate, RequestData request) {
        boolean isTakeaway = request.getParamMap().containsKey("isTakeaway");
        whereStr = whereStr + " AND rf.F_Type = 1 ";
        if (isTakeaway) {
            whereStr = " AND Outer_Ord = 1 AND ISNULL(isDelivered, 0) = 0 AND ISNULL(ExporterSId, -1) >= 0 ";
            if (request.getParamMap().containsKey("cCode")) {
                whereStr = whereStr + " AND rf.C_Code = " + (String)request.getParamMap().get("cCode");
            }
        }
        String joinGroupOrMenu = this.getJoinGroupOrMenu(isActiveMenu);
        String sql = "SELECT rfl.A_Code AS productId, " + this.getProductGroupCode(isActiveMenu) + " AS productGroupCode, rfl.F_Code AS invoiceId, \n Isnull(rfl.FL_Few,0) AS amount, IsNull(rfl.FL_Price, 0) AS price, \n rfl.Fl_Inc_Index AS serverId, rfl.FL_Comment as description, (CASE WHEN rfl.Art_OuterOrd = 1 THEN 'TRUE' ELSE 'FALSE' END) as takeOut, \n rfl.Darsad_takhfif discountPercent, (ISNULL(rfl.takhfifSatriR, 0) / rfl.FL_Few) discountPrice \n FROM Res_Fac_List rfl \n INNER JOIN Res_Facture rf ON rf.F_Code = rfl.F_Code \n INNER JOIN USERDB u ON rf.UserCode = u.UserCodeInc \n" + joinGroupOrMenu + " WHERE (rf.FType_KF = 'F') AND (IsNull(u.Res_SaveSpdSel, 0) = 0) \n AND (rf.Fac_Type = 'R') \n" + whereStr + " \n order by rfl.F_Code, rfl.FL_Index  ";
        return jdbcTemplate.queryForList(sql);
    }

    @Language(value="SQL")
    @NotNull
    private String getJoinGroupOrMenu(boolean isActiveMenu) {
        return isActiveMenu ? " INNER JOIN (SELECT DISTINCT A_Code, Max(A_Type) AS A_Type \n FROM Res_MenuArt GROUP BY A_Code) Ra ON Ra.A_Code = rfl.A_Code \n" : " INNER JOIN M_Group M ON SubString(rfl.A_Code, 1, 2) = M.M_GroupCode \n INNER JOIN S_Group S ON M.M_GroupCode = S.M_GroupCode AND \n SubString(rfl.A_Code, 3, 2) = S.S_GroupCode";
    }

    @NotNull
    private String getProductGroupCode(boolean isActiveMenu) {
        return isActiveMenu ? "Ra.A_Type" : "(S.M_groupcode+S.S_groupcode)";
    }

    public GetResInvoices(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

