/*
 * Decompiled with CFR 0.152.
 */
package com.android.order.domain.use_case;

import com.android.invoice.domain.use_case.invoice.post.InsertADtlVarieties;
import com.android.order.domain.model.AOrderDtlDto;
import com.android.order.domain.model.AOrderDto;
import com.android.order.domain.use_case.InsertSizeItems;
import com.android.product.domain.use_case.CheckProductExists;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

@Service
public class InsertAOrderDtl {
    private final DbConnection dbConnection;
    private final CheckProductExists checkProductExists;
    @Resource
    @Lazy
    private InsertADtlVarieties insertADtlVarieties;
    @Resource
    @Lazy
    private InsertSizeItems insertSizeItems;

    public void invoke(AOrderDto order, SettingLoader settingLoader) {
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate();
        for (AOrderDtlDto dtl : order.getDtlDto()) {
            this.calcThreeUnitNewAmount(settingLoader, dtl);
            dtl.setOrderId(order.getId().longValue());
            dtl.setType(order.getAOrderTypeName());
            dtl.setRowNumber(order.getDtlDto().indexOf(dtl) + 1);
            this.checkDtlErrors(dtl);
        }
        this.batchInsert(order.getDtlDto(), jdbc);
        for (AOrderDtlDto dtl : order.getDtlDto()) {
            this.insertADtlVarieties.invoke(dtl.getVarietyList(), dtl);
        }
        for (AOrderDtlDto dtl : order.getDtlDto()) {
            this.insertSizeItems.invoke(dtl.getSizeList(), dtl);
        }
    }

    private void calcThreeUnitNewAmount(SettingLoader settingLoader, AOrderDtlDto dtl) {
        TncJdbc jdbc = settingLoader.getJdbc();
        SqlRowSet rs = jdbc.queryForRowSet("SELECT isNull(Karton, 0) [box], isNull(basteh, 0) [pack], A_CODE_C, \n A_Name, isNull(Moddat, 0) [due] \n FROM Article WHERE A_CODE = ?", new Object[]{dtl.getProductCode()});
        if (!rs.next()) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        double tmpAmount = dtl.getAmount();
        dtl.setBox(rs.getDouble("box"));
        dtl.setPack(rs.getDouble("pack"));
        dtl.setProductCustomCode(rs.getString("A_CODE_C"));
        dtl.setProductName(rs.getString("A_Name"));
        dtl.setDue(rs.getDouble("due"));
        if (settingLoader.isThreeUnitEnabled() && settingLoader.isThreeUnitNewEnabled()) {
            tmpAmount = dtl.getSecondAmount() * dtl.getBox() * dtl.getPack() + dtl.getThirdAmount() * dtl.getPack() + dtl.getAmount();
        }
        dtl.setAmount(tmpAmount);
    }

    private void checkDtlErrors(AOrderDtlDto dtl) {
        if (!this.checkProductExists.invoke(dtl.getProductCode())) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        if (dtl.getAmount() <= 0.0) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_AMOUNT);
        }
    }

    private void batchInsert(List<AOrderDtlDto> dtlList, TncJdbc jdbc) {
        StringBuilder insertSql = new StringBuilder("INSERT INTO RqDetail (RqIndex, RqType, IndexHlp, R_ArCode, R_ArCode_C, R_ArName, R_Few, R_FewAval, DarsadTakhfif, TakhfifSatriR, R_Commen, Moddat, R_Few2, R_FewAval2, R_Few3, R_FewAval3, FewKarton, FewBasteh, R_Cost, Unit_Code, K_Fac_Code, k_FacType, A_IndexK_FacCode, Tool, Arz, ToolArzType, DeliveryTimeId, selPriceId) \n VALUES ");
        for (AOrderDtlDto dtl : dtlList) {
            String description = dtl.getDescription();
            if (description != null) {
                description = description.replace("'", "''");
            }
            insertSql.append("(").append(dtl.getOrderId()).append(", ").append("'").append(dtl.getType().getTypeChar()).append("', ").append(dtl.getRowNumber()).append(", ").append("'").append(dtl.getProductCode()).append("', ").append(ConvertStr.toQuotedSqlStr((String)dtl.getProductCustomCode())).append(", ").append(ConvertStr.toQuotedSqlStr((String)dtl.getProductName())).append(", ").append(dtl.getAmount()).append(", ").append(dtl.getAmount()).append(", ").append(ConvertStr.nullSafeDouble((Double)dtl.getDiscountPercent())).append(", ").append(dtl.getAmount() * ConvertStr.nullSafeDouble((Double)dtl.getDiscountPrice())).append(", ").append(ConvertStr.toQuotedSqlStr((String)description)).append(", ").append(dtl.getDue()).append(", ").append(ConvertStr.nullSafeDouble((Double)dtl.getSecondAmount())).append(", ").append(ConvertStr.nullSafeDouble((Double)dtl.getSecondAmount())).append(", ").append(ConvertStr.nullSafeDouble((Double)dtl.getThirdAmount())).append(", ").append(ConvertStr.nullSafeDouble((Double)dtl.getThirdAmount())).append(", ").append(dtl.getBox()).append(", ").append(dtl.getPack()).append(", ").append(dtl.getPrice()).append(", ").append(ConvertStr.toQuotedSql((Object)dtl.getUnitCode())).append(", ").append("'").append(dtl.getOrderCode()).append("', ").append(ConvertStr.toQuotedSqlStr((String)dtl.getOrderType())).append(", ").append(dtl.getMetricRowIndex()).append(", ").append(ConvertStr.toQuotedSql((Object)dtl.getLength())).append(", ").append(ConvertStr.toQuotedSql((Object)dtl.getWidth())).append(", ").append(ConvertStr.toQuotedSql((Object)dtl.getLengthWidthType())).append(", ").append(dtl.getMetricDeliveryDateId()).append(", ").append(dtl.getPriceIndex()).append("), \n");
        }
        jdbc.execute(ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)insertSql, (String)",").toString());
    }

    public InsertAOrderDtl(DbConnection dbConnection, CheckProductExists checkProductExists) {
        this.dbConnection = dbConnection;
        this.checkProductExists = checkProductExists;
    }
}

