/*
 * Decompiled with CFR 0.152.
 */
package com.android.order.domain.use_case.read;

import com.android.invoice.domain.VarietyMapper;
import com.android.invoice.domain.model.ADtlVarietyDto;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Scope;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
@Scope(value="session")
public class FetchAOrderDtlVariety {
    private final DbConnection dbConnection;

    public List<ADtlVarietyDto> invoke(LoginDto login, @Nullable List<String> orderIdList) {
        String commaBoundStr = ConvertStr.commaBindStringsWithQuotes(orderIdList);
        String idSql = (String)ConvertStr.ifElse((boolean)ConvertStr.isNullOrEmpty((String)commaBoundStr), () -> "", () -> " rq.RqIndex IN (" + commaBoundStr + ") AND ");
        String sql = "SELECT itf.ID AS serverId, rq.RqIndex AS invoiceId, rqd.RqIncIndex AS invoiceDtlId, \n itf.A_INDEX AS rowIndex, itf.Few AS amount, itf.A_Code AS articleCode, \n itf.PoshakIDF varietyIDF, itf.selPriceID \n FROM ItemFact itf \n INNER JOIN RQTITLE rq ON " + idSql + " rq.RqIndex = CAST(itf.Fac_Code AS int) \n INNER JOIN RQDETAIL rqd ON rqd.IndexHlp = itf.A_Index AND rqd.RqIndex = rq.RqIndex \n WHERE itf.Fac_Type IN ('J','S') AND (IsNull(rqd.Show_Or_Hide, 1) = 1) \n ORDER BY rqd.RqIndex, rqd.RqIncIndex, itf.id ";
        return this.dbConnection.getJdbcTemplate(login).query(sql, (RowMapper)new VarietyMapper());
    }

    public FetchAOrderDtlVariety(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

