/*
 * Decompiled with CFR 0.152.
 */
package com.android.order.domain.use_case.read;

import com.android.order.domain.AOrderMapper;
import com.android.order.domain.model.AOrderDto;
import com.android.order.domain.use_case.read.BuildAOrderDtl;
import com.dto.LoginDto;
import com.utility.DbConnection;
import com.utility.TncJdbc;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class QueryOrders {
    private final DbConnection dbConnection;
    @Resource
    @Lazy
    private BuildAOrderDtl buildAOrderDtl;

    public List<AOrderDto> invoke(String sql, LoginDto login) {
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(login);
        List dtoList = jdbc.query(sql, (RowMapper)new AOrderMapper());
        List dtlList = this.buildAOrderDtl.invoke(login, dtoList.stream().map(dto -> dto.getServerId().toString()).collect(Collectors.toList()));
        return dtoList.stream().peek(dto -> dto.setDtlDto(dtlList.stream().filter(dtl -> dtl.getOrderId() == dto.getServerId().longValue()).collect(Collectors.toList()))).filter(orderDto -> !orderDto.getDtlDto().isEmpty()).collect(Collectors.toList());
    }

    public QueryOrders(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

