/*
 * Decompiled with CFR 0.152.
 */
package com.android.payment.domain.use_case;

import com.android.payment.domain.model.ACheckDto;
import com.utility.ConvertStr;
import com.utility.DateUtils;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class InsertInvoiceChequeUseCase {
    public void invoke(Long sanadId, Long factureId, List<ACheckDto> checkDtoList, TncJdbc jdbc) {
        String sql = "INSERT INTO TmpCheck(IDSanad,Check_Number,Back_Number,Account_Number,Branch,BranchCode,cust,Bank_Code,Receive_Date,Export_Date,C_Comment,Sayad_Number,IsSayad,FactureId)Values";
        StringBuilder insert = new StringBuilder();
        for (ACheckDto check : checkDtoList) {
            insert.append("(").append(sanadId).append(",").append("'").append(check.getCheckNumber()).append("', ").append("'', ").append("'").append(check.getAccountNo()).append("', ").append(ConvertStr.toQuotedSqlStr((String)check.getBranch())).append(", ").append(ConvertStr.toQuotedSqlStr((String)check.getBranchCode())).append(", ").append(check.getAmount()).append(", ").append("'").append(check.getBankCode()).append("', ").append("'").append(check.getDueDate()).append("', ").append("'").append(check.getIssueDate()).append("', ").append(ConvertStr.toQuotedSqlStr((String)check.getDescription())).append(", ").append(ConvertStr.toQuotedSqlStr((String)check.getSayadId())).append(", ").append(ConvertStr.boolToBit((Boolean)check.isRecordedInSayad())).append(", ").append(factureId).append("), \n");
        }
        jdbc.execute("INSERT INTO TmpCheck(IDSanad,Check_Number,Back_Number,Account_Number,Branch,BranchCode,cust,Bank_Code,Receive_Date,Export_Date,C_Comment,Sayad_Number,IsSayad,FactureId)Values" + ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)insert, (String)","));
    }

    public void inspectChecks(List<ACheckDto> checkDtoList, TncJdbc jdbc) {
        for (ACheckDto check : checkDtoList) {
            Integer countCheck = (Integer)jdbc.queryForObject("if ((Select Count(*) From [Check] where Account_Number = ? \n And Check_Number = ?) > 0 or \n     (Select Count(*) From TmpCheck where Account_Number = ? And Check_Number = ?) > 0) \n select 1 as duplicateCheckNumbers \n else select 0 as mfield", Integer.class, new Object[]{check.getAccountNo(), check.getCheckNumber(), check.getAccountNo(), check.getCheckNumber()});
            if (ConvertStr.nullSafeInt((Integer)countCheck) == 1) {
                throw new TncException(TncExceptionMessages.DUPLICATE_CHECK_NUMBERS_FOR_ACCOUNT.setArgs(new Object[]{check.getAccountNo(), check.getCheckNumber(), "(\u0686\u06a9)"}));
            }
            if (ConvertStr.isNullOrEmpty((String)check.getIssueDate()) || ConvertStr.isNullOrEmpty((String)check.getDueDate())) {
                throw new TncException(TncExceptionMessages.INVALID_DATE);
            }
            if (!DateUtils.parseDate((String)check.getIssueDate()).after(DateUtils.parseDate((String)check.getDueDate()))) continue;
            throw new TncException(TncExceptionMessages.DUE_DATE_BEFORE_ISSUE_DATE);
        }
    }
}

