/*
 * Decompiled with CFR 0.152.
 */
package com.android.payment.domain.use_case;

import com.android.core.domain.model.GenericResponse;
import com.android.payment.domain.model.SettlementDto;
import com.android.payment.domain.use_case.InsertInvoiceChequeUseCase;
import com.core.util.filter.Filter;
import com.core.util.filter.GenericParamFactory;
import com.core.util.filter.InternalFilter;
import com.customer.data.CustomerRepo;
import com.dto.LoginDto;
import com.security.SecurityConstants;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.GetIdentity;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.util.Collection;
import org.springframework.stereotype.Service;

@Service
public class InsertOrReplaceSettlement {
    private final DbConnection dbConnection;
    private final CustomerRepo customerRepo;
    private final InsertInvoiceChequeUseCase insertChequeUseCase;

    public GenericResponse invoke(SettlementDto item) throws TncException {
        LoginDto login = SecurityConstants.loadToken();
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(login);
        long requestIdentifier = item.getId();
        if (item.getServerId() > 0L) {
            this.deleteOldSettlement(item.getServerId(), jdbc);
        }
        this.inspectSettlement(item);
        this.insertChequeUseCase.inspectChecks(item.getCheckDtoList(), jdbc);
        GenericResponse.GenericResponseBuilder responseBuilder = GenericResponse.builder();
        long id = this.insertSettlement(item, jdbc, login);
        item.setId(id);
        if (!ConvertStr.isNullOrEmpty((Collection)item.getCheckDtoList())) {
            this.insertChequeUseCase.invoke(Long.valueOf(item.getId()), null, item.getCheckDtoList(), jdbc);
        }
        return responseBuilder.requestIdentifier(String.valueOf(requestIdentifier)).clientId(requestIdentifier).message("\u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u062f\u0631\u062c \u0634\u062f").generatedCode(String.valueOf(id)).build();
    }

    private void deleteOldSettlement(long serverId, TncJdbc jdbc) {
        jdbc.execute("DELETE FROM TMPSanad WHERE ID = " + serverId);
        jdbc.execute("DELETE FROM TMPCheck WHERE IDSanad = " + serverId);
    }

    private void inspectSettlement(SettlementDto item) throws TncException {
        if (item.getCash() + item.getPos() + item.getSumCheck() + item.getDiscount() <= 0.0) {
            throw new TncException(TncExceptionMessages.INVALID_PRICE);
        }
        if (this.customerRepo.getCustomerCount((Filter)new InternalFilter(ConvertStr.buildMap(map -> map.put("code", item.getCustomerCode())), GenericParamFactory.CUSTOMER)) == 0) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
        }
    }

    private long insertSettlement(SettlementDto item, TncJdbc jdbc, LoginDto login) {
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, login);
        String sql = "INSERT INTO TmpSanad (AfoType, SDateTime, SNaghd, SCheck, SCard, C_Code, C_CodeVaseteh, \n Comment, accountsarfasl,bankcode,UserCode,FundSarfasl, discount) VALUES(" + ConvertStr.boolToBit((Boolean)item.isPayment()) + ", '" + item.getDate() + "', " + item.getCash() + ", " + item.getSumCheck() + ", " + item.getPos() + ", '" + item.getCustomerCode() + "', " + ConvertStr.toQuotedSqlStr((String)settingLoader.getMidManId()) + ", " + ConvertStr.toQuotedSqlStr((String)item.getDescription()) + ", " + ConvertStr.toQuotedSqlStr((String)item.getPosHeading()) + ", " + ConvertStr.toQuotedSqlStr((String)item.getBankCode()) + ", " + login.getUserCodeInc() + ", " + ConvertStr.toQuotedSqlStr((String)item.getCashHeading()) + ", " + item.getDiscount() + ")";
        jdbc.execute(sql);
        return GetIdentity.invoke((TncJdbc)jdbc);
    }

    public InsertOrReplaceSettlement(DbConnection dbConnection, CustomerRepo customerRepo, InsertInvoiceChequeUseCase insertChequeUseCase) {
        this.dbConnection = dbConnection;
        this.customerRepo = customerRepo;
        this.insertChequeUseCase = insertChequeUseCase;
    }
}

