/*
 * Decompiled with CFR 0.152.
 */
package com.android.product.data.repository;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.RequestData;
import com.android.core.utils.params.QueryParamTypes;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.Paging;
import com.utility.SoftwareInfo;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class ProductPriceRepository
extends AndroidRepository<Map<String, Object>> {
    public ProductPriceRepository(DbConnection dbConnection) {
        super(dbConnection);
    }

    @Nullable
    protected Paging.PageSqlData queryWithDefaultPaging(RequestData request, SettingLoader settingsLoader) {
        SoftwareInfo softwareInfo = new SoftwareInfo(this.dbConnection.getJdbcTemplate(settingsLoader.getLogin()));
        boolean userCannotAccessPriceTypes = settingsLoader.userCannotAccessPriceTypes();
        if (softwareInfo.isRestaurant()) {
            return null;
        }
        String userAccessiblePrices = settingsLoader.getUserAccessiblePrices();
        String sql = " SELECT A.[id], A.A_Code productCode, SelID priceIndex, " + (!ConvertStr.isNullOrEmpty((String)userAccessiblePrices) ? " (SELECT Sel_price FROM ArticlePrice WHERE [id]=A.ID AND  (SelID - 1) IN (" + userAccessiblePrices + "))" : "A.Sel_Price ") + " AS price, \n PoshakID varietyId, A.modifyDate, Min_Price minPrice, Max_Price maxPrice, \n TakhfifRialy discountAmount, A.DarsadTakhfif discountPercent, 0 buyPrice, \n (SELECT \n CASE WHEN A.SelID = 1 THEN Ac.Sel_Comm1 \n      WHEN A.SelID = 2 THEN Ac.Sel_Comm2 \n\t   WHEN A.SelID = 3 THEN Ac.Sel_Comm3 \n\t   WHEN A.SelID = 4 THEN Ac.Sel_Comm4 \n\t   WHEN A.SelID = 5 THEN Ac.Sel_Comm5 \n\t   WHEN A.SelID = 6 THEN Ac.Sel_Comm6 \n\t   WHEN A.SelID = 7 THEN Ac.Sel_Comm7 \n\t   WHEN A.SelID = 8 THEN Ac.Sel_Comm8 \n\t   WHEN A.SelID = 9 THEN Ac.Sel_Comm9 \n\t   WHEN A.SelID = 10 THEN Ac.Sel_Comm10 \n  END \n  FROM ART_SEL_COMMENT Ac WHERE Ac.A_Code = A.A_Code) [caption] \n FROM ArticlePrice A \n";
        if (settingsLoader.userHasLimitedAccessToProducts()) {
            sql = sql + " inner join (Select * from RMUserArtAccess where Userid= " + settingsLoader.getLogin().getUserCodeInc() + ") RMUA on RMUA.Articleid = A.A_Code\n";
        }
        sql = sql + "LEFT JOIN ARTICLE AS aa  on aa.A_Code = A.A_Code";
        String where = " ISNULL(aa.UseInPortable,0) = 1 ";
        if (userCannotAccessPriceTypes) {
            where = where + " AND A.SelID = 1";
        }
        String secondWhere = " where a.price is not null";
        return Paging.PageSqlData.builder().selectSqlStr(sql).whereStr(where).secondWhere(secondWhere).alias("A").keyField("id").build();
    }

    @NotNull
    protected QueryParamTypes queryParamType() {
        return QueryParamTypes.PRODUCT_PRICE;
    }
}

