/*
 * Decompiled with CFR 0.152.
 */
package com.android.product.data.repository;

import com.service.SettingLoader;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/product/data/repository/ProductUtils;", "", "()V", "getDiscountSql", "", "settingLoader", "Lcom/service/SettingLoader;", "TNCHolooWebService"})
public final class ProductUtils {
    @NotNull
    public static final ProductUtils INSTANCE = new ProductUtils();

    private ProductUtils() {
    }

    @Language(value="SQL")
    @NotNull
    public final String getDiscountSql(@NotNull SettingLoader settingLoader) {
        Intrinsics.checkNotNullParameter((Object)settingLoader, (String)"settingLoader");
        String discountSql = "IsNull(%s, 0) AS discountPercent, IsNull(%s, 0) AS discountPrice, \n";
        String sqlPercent = null;
        String sqlPrice = null;
        if (settingLoader.isProductDiscountPerMGroup()) {
            sqlPercent = "M.DarsadTakhfif";
            sqlPrice = "M.PriceTakhfif";
        } else if (settingLoader.isProductDiscountPerSGroup()) {
            sqlPercent = "S.DarsadTakhfif";
            sqlPrice = "S.PriceTakhfif";
        } else {
            sqlPercent = "a.DarsadTakhfif";
            sqlPrice = "a.PriceTakhfif";
        }
        if (settingLoader.isUsePerRowDiscountPrice()) {
            sqlPercent = "0";
        } else if (settingLoader.isUsePerRowDiscountPercent()) {
            sqlPrice = "0";
        } else {
            sqlPercent = "0";
            sqlPrice = "0";
        }
        Locale locale = Locale.ENGLISH;
        Object[] objectArray = new Object[]{sqlPercent, sqlPrice};
        String string = String.format(locale, discountSql, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }
}

