/*
 * Decompiled with CFR 0.152.
 */
package com.android.product.domain;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.AndroidService;
import com.android.core.domain.FetchOptions;
import com.android.core.domain.model.BaseError;
import com.android.core.domain.model.BaseResponse;
import com.android.product.domain.use_case.GetLastSellPrice;
import com.utility.TncExceptionMessages;
import java.util.Map;
import javax.annotation.Resource;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;

@Service
public class ProductPriceService
extends AndroidService<Map<String, Object>> {
    @Resource
    @Lazy
    private GetLastSellPrice getLastSellPrice;

    protected ProductPriceService(AndroidRepository<Map<String, Object>> productPriceRepository) {
        super(productPriceRepository);
    }

    @Nullable
    protected FetchOptions configFetch() {
        return FetchOptions.builder().tableNameForPaging("ArticlePrice").build();
    }

    public BaseResponse<Double> getLastSellPrice(String customerCode, String productCode) {
        try {
            Double result = this.getLastSellPrice.invoke(customerCode, productCode);
            if (result == null) {
                throw new EmptyResultDataAccessException(1);
            }
            BaseResponse.Builder response = new BaseResponse.Builder();
            return response.data((Object)result).build();
        }
        catch (EmptyResultDataAccessException e) {
            BaseError error = new BaseError().setErrorCode(String.valueOf(TncExceptionMessages.DATA_NOT_FOUND.getCode())).setMessage(TncExceptionMessages.DATA_NOT_FOUND.getMessage());
            BaseResponse.Builder response = new BaseResponse.Builder();
            response.withError(error);
            return response.build();
        }
    }
}

