/*
 * Decompiled with CFR 0.152.
 */
package com.android.product.domain;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.AndroidService;
import com.android.core.domain.FetchOptions;
import com.android.core.domain.model.BaseError;
import com.android.core.domain.model.BaseResponse;
import com.android.product.domain.model.ProductDto;
import com.android.product.domain.model.ProductInfoDto;
import com.android.product.domain.use_case.GetProductInfo;
import com.utility.ConvertStr;
import com.utility.TncExceptionMessages;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ProductService
extends AndroidService<ProductDto> {
    @Resource
    @Lazy
    private GetProductInfo getProductInfo;

    @Autowired
    public ProductService(AndroidRepository<ProductDto> androidRepository) {
        super(androidRepository);
    }

    protected Class<ProductDto> getItemClass() {
        return ProductDto.class;
    }

    protected FetchOptions configFetch() {
        return FetchOptions.builder().tableNameForPaging("ARTICLE").build();
    }

    public ResponseEntity<Map<String, Object>> getInfo(String productCode) {
        List productInfoList = this.getProductInfo.invoke(productCode);
        BaseError error = ConvertStr.isNullOrEmpty((Collection)productInfoList) ? new BaseError().setErrorCode(String.valueOf(TncExceptionMessages.EMPTY_RESPONSE.getCode())).setMessage(TncExceptionMessages.EMPTY_RESPONSE.getMessage()) : null;
        BaseResponse.Builder response = new BaseResponse.Builder();
        if (error != null) {
            response.withError(error);
        } else {
            response.data(productInfoList);
        }
        return this.makeAndroidResponse(response.build(), ProductInfoDto.class);
    }
}

