/*
 * Decompiled with CFR 0.152.
 */
package com.android.product.domain.use_case;

import com.android.files.data.repository.FilesRepository;
import com.android.product.data.repository.ProductRepository;
import com.android.product.domain.mapper.ProductRowMapper;
import com.android.product.domain.model.ProductInfoDto;
import com.android.product.domain.use_case.GetProductInfo;
import com.dto.LoginDto;
import com.security.SecurityConstants;
import com.service.SettingLoader;
import com.utility.DbConnection;
import com.utility.Paging;
import com.utility.TncJdbc;
import com.utility.TncLog;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GetProductInfo {
    private final DbConnection dbConnection;
    private final FilesRepository filesRepository;
    private final TncLog log;

    public List<ProductInfoDto> invoke(String productCode) {
        LoginDto login = SecurityConstants.loadToken();
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, login);
        ProductRepository.QueryBuilder query = new ProductRepository.QueryBuilder(settingLoader, false);
        Paging.PageSqlData pagingData = Paging.PageSqlData.builder().selectSqlStr(query.getSelectPart()).whereStr("WHERE a.A_CODE_C = '" + productCode + "' \n OR a.A_Code IN (SELECT A_Code FROM ArticleCodes WHERE A_Code_C = '" + productCode + "') \n").joinsStr(query.getJoinsPart()).alias("A").keyField("A_CODE").keyFieldType("nvarchar(7)").build();
        Paging paging = new Paging(0, 0, "ARTICLE");
        String sql = paging.makeSql(pagingData);
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(login);
        List productList = jdbc.query(sql, (RowMapper)new ProductRowMapper());
        List<ProductInfoDto> productInfoList = productList.stream().map(ProductInfoDto::fromProductDto).collect(Collectors.toList());
        String[] attrMSetupKeys = this.getAttrMSetupKeys();
        AtomicReference attrHolder = new AtomicReference();
        settingLoader.getMapMultiple(rs -> rs.getString("String"), map -> attrHolder.set(AttrLabelHolder.builder().label1(map.getOrDefault("ArtLableOther1", "")).label2(map.getOrDefault("ArtLableOther2", "")).label3(map.getOrDefault("ArtLableOther3", "")).label4(map.getOrDefault("ArtLableOther4", "")).label5(map.getOrDefault("ArtLableOther5", "")).label6(map.getOrDefault("ArtLableOther6", "")).label7(map.getOrDefault("ArtLableOther7", "")).label8(map.getOrDefault("ArtLableOther8", "")).label9(map.getOrDefault("ArtLableOther9", "")).label10(map.getOrDefault("ArtLableOther10", "")).build()), "[String]", "''", attrMSetupKeys);
        for (ProductInfoDto productInfoDto : productInfoList) {
            productInfoDto.setAttrLabel1(((AttrLabelHolder)attrHolder.get()).label1);
            productInfoDto.setAttrLabel2(((AttrLabelHolder)attrHolder.get()).label2);
            productInfoDto.setAttrLabel3(((AttrLabelHolder)attrHolder.get()).label3);
            productInfoDto.setAttrLabel4(((AttrLabelHolder)attrHolder.get()).label4);
            productInfoDto.setAttrLabel5(((AttrLabelHolder)attrHolder.get()).label5);
            productInfoDto.setAttrLabel6(((AttrLabelHolder)attrHolder.get()).label6);
            productInfoDto.setAttrLabel7(((AttrLabelHolder)attrHolder.get()).label7);
            productInfoDto.setAttrLabel8(((AttrLabelHolder)attrHolder.get()).label8);
            productInfoDto.setAttrLabel9(((AttrLabelHolder)attrHolder.get()).label9);
            productInfoDto.setAttrLabel10(((AttrLabelHolder)attrHolder.get()).label10);
            productInfoDto.setImageList(this.filesRepository.getPictureList(productInfoDto.getCode()));
        }
        this.log.info(productInfoList.toString());
        return productInfoList;
    }

    private String[] getAttrMSetupKeys() {
        String defaultPrefix = "ArtLableOther";
        String[] result = new String[10];
        for (int i = 1; i <= 10; ++i) {
            result[i - 1] = "ArtLableOther" + i;
        }
        return result;
    }

    public GetProductInfo(DbConnection dbConnection, FilesRepository filesRepository, TncLog log) {
        this.dbConnection = dbConnection;
        this.filesRepository = filesRepository;
        this.log = log;
    }
}

