/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.data;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.BaseResponse;
import com.android.core.domain.model.RequestData;
import com.dao.HolooSettingsDao;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.LockCode;
import com.utility.LockReader;
import com.utility.Paging;
import com.utility.SoftwareInfo;
import com.utility.TncJdbc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class SettingsRepository
extends AndroidRepository<Map<String, Object>> {
    public SettingsRepository(DbConnection dbConnection) {
        super(dbConnection);
    }

    public BaseResponse<Map<String, Object>> customQuery(RequestData request, Paging paging, LoginDto login) {
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        SoftwareInfo softwareInfo = new SoftwareInfo(jdbcTemplate);
        LockReader lockReader = new LockReader(jdbcTemplate);
        boolean isGiftEnabled = lockReader.isLockEnabled(LockCode.GIFT);
        String sql = "SELECT [name],  IsNull(CASE WHEN [BOOLEAN] = 1 THEN 'true' WHEN [BOOLEAN] = 0 THEN 'false' END, '') \n + IsNull(CAST([INTEGER] AS NVARCHAR(50)), '') + IsNull(CAST([DOUBLE] AS NVARCHAR(50)), '') \n + CAST(IsNull([STRING], '') AS NVARCHAR(4000)) AS [value] FROM MSETUP2 \n WHERE [NAME] IN ('SetExpireTime', 'Darsad_Maliyat', 'Darsad_Avarez', 'FreeCodeForCustomer', \n'CalcExistInReq', 'ArticleHasTax', 'SaveFactListSiah', 'ResHasCutomPrint', \n'ResPrintConfigType', 'Res_RoundTakhfifLow', 'Res_RoundTakhfif', 'NegativeInReq', \n'UseNewCheck')";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sql);
        List result = this.initResult(rs);
        result.addAll(this.addUserRelatedSettings(jdbcTemplate, softwareInfo.isRestaurant()));
        result.addAll(this.addMSetup3Settings(jdbcTemplate));
        result.addAll(this.getAttrNames(jdbcTemplate));
        result.add(this.makeSettingMap("isKitCarpet", (Object)softwareInfo.isKitCarpet()));
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, login);
        result.add(this.makeSettingMap("isGiftEnabled", (Object)isGiftEnabled));
        result.add(this.makeSettingMap("DBPnlOrderPriceTakhfif", (Object)settingLoader.isUsePerRowDiscountPrice()));
        result.add(this.makeSettingMap("DBPnlOrderDarsadTakhfif", (Object)settingLoader.isUsePerRowDiscountPercent()));
        result.add(this.makeSettingMap("IsCalcVat", (Object)settingLoader.isCalcVatK()));
        result.add(this.makeSettingMap("IsCalcVat_J", (Object)settingLoader.isCalcVatJ()));
        result.add(this.makeSettingMap("IsVatFactureAvarez_F", (Object)settingLoader.isVatInvoiceScotSell()));
        result.add(this.makeSettingMap("IsVatFactureMaliyat_F", (Object)settingLoader.isVatInvoiceLevySell()));
        result.add(this.makeSettingMap("IsVatFactureAvarez_K", (Object)settingLoader.isVATInvoiceScotBuy()));
        result.add(this.makeSettingMap("IsVatFactureMaliyat_K", (Object)settingLoader.isVATInvoiceLevyBuy()));
        result.add(this.makeSettingMap("showInvoicePayment", (Object)settingLoader.showInvoicePayment()));
        result.add(this.makeSettingMap("SETArticleExist2", (Object)settingLoader.getSecondUnitName()));
        result.add(this.makeSettingMap("IsGetGps", (Object)settingLoader.isGetGps()));
        result.add(this.makeSettingMap("accessInvoiceByGpsReport", (Object)settingLoader.userHasAccessToInvoiceBeforeTimeRecord()));
        result.add(this.makeSettingMap("IsGiftKit", (Object)login.isComplimentaryActive()));
        result.add(this.makeSettingMap("allowNegativeFact", (Object)settingLoader.isNegativeInvoiceAllowed()));
        result.add(this.makeSettingMap("IsUseUnit", (Object)settingLoader.isUseUnit()));
        result.add(this.makeSettingMap("IsCalcByUnit", (Object)settingLoader.isCalcByUnit()));
        result.add(this.makeSettingMap("IsUnitSellPrice", (Object)settingLoader.unitSellPriceEnabled()));
        result.add(this.makeSettingMap("IsSearchArtGroup", (Object)settingLoader.searchArtGroupEnabled()));
        result.add(this.makeSettingMap("IsSearchArtSubGroup", (Object)settingLoader.searchArtSubGroupEnabled()));
        result.add(this.makeSettingMap("IsPartyGroup", (Object)settingLoader.isPartyGroupEnabled()));
        result.add(this.makeSettingMap("IsAlarmEtebar", (Object)settingLoader.isCreditAlarmEnabled()));
        result.add(this.makeSettingMap("IsRepeatArt", (Object)(!settingLoader.isRepeatArtEnabled() ? 1 : 0)));
        result.add(this.makeSettingMap("IsRepeatArtAdd", (Object)settingLoader.isRepeatArtEnabled()));
        result.add(this.makeSettingMap("isKitShoes", (Object)settingLoader.isKitShoes()));
        result.add(this.makeSettingMap("aPartyMaxCode", (Object)settingLoader.getPartyMaxCode()));
        result.add(this.makeSettingMap("Serial", (Object)login.getSerial()));
        result.add(this.makeSettingMap("IsModdatTasvieh", (Object)settingLoader.isModatTasviehEnabled()));
        result.add(this.makeSettingMap("ArticlePorsant", (Object)settingLoader.articleCommissionEnabled()));
        result.add(this.makeSettingMap("Negative_OfSath", (Object)settingLoader.negativeOfSathEnabled()));
        result.add(this.makeSettingMap("CShowMsgNotBalancePoshak", (Object)settingLoader.showMsgNotBalanceVariety()));
        result.add(this.makeSettingMap("UseArticlePricePoshak", (Object)settingLoader.useArticlePriceVarietyEnabled()));
        result.add(this.makeSettingMap("UseArticleTakhfifPoshak", (Object)settingLoader.useArticleDiscountVarietyEnabled()));
        result.add(this.makeSettingMap("MinMaxArtPricePoshak", (Object)settingLoader.minMaxVarietyPriceEnabled()));
        result.add(this.makeSettingMap("WastagePriceType", (Object)settingLoader.getWastagePriceType()));
        result.add(this.makeSettingMap("isSelectPartyEnabled", (Object)settingLoader.isSelectPartyEnabled()));
        result.add(this.makeSettingMap("isOnlineFactureEnable", (Object)settingLoader.isOnlineFactureEnabled()));
        result.add(this.makeSettingMap("resFactureType", (Object)settingLoader.getResFactureType()));
        result.add(this.makeSettingMap("isTakeawayEnabled", (Object)settingLoader.isTakeawayEnabled()));
        result.add(this.makeSettingMap("resDefaultPartyCode", (Object)settingLoader.getDefaultCustomer()));
        result.add(this.makeSettingMap("hasChangePrintAccess", (Object)settingLoader.hasChangePrintAccess()));
        result.add(this.makeSettingMap("isAutoFewCartonEnabled", (Object)settingLoader.isAutoFewCartonEnabled()));
        return new BaseResponse.Builder().data(result).build();
    }

    private Collection<? extends Map<String, Object>> addMSetup3Settings(TncJdbc jdbcTemplate) {
        HolooSettingsDao settingDao = new HolooSettingsDao(this.dbConnection);
        LoginDto login = jdbcTemplate.getLogin();
        ArrayList<Map> result = new ArrayList<Map>();
        result.add(this.makeSettingMap("isEditBuyFactureEnabled", login.getSuperVizor() != false ? "true" : Boolean.valueOf(settingDao.getMSetup3Boolean(login, "W" + login.userCodeInc + "_N20EK"))));
        result.add(this.makeSettingMap("isEditSaleFactureEnabled", login.getSuperVizor() != false ? "true" : Boolean.valueOf(settingDao.getMSetup3Boolean(login, "W" + login.userCodeInc + "_N20EF"))));
        result.add(this.makeSettingMap("isEditReturnFromSaleFactureEnabled", login.getSuperVizor() != false ? "true" : Boolean.valueOf(settingDao.getMSetup3Boolean(login, "W" + login.userCodeInc + "_N20EY"))));
        result.add(this.makeSettingMap("isEditWastageFactureEnabled", login.getSuperVizor() != false ? "true" : Boolean.valueOf(settingDao.getMSetup3Boolean(login, "W" + login.userCodeInc + "_N20EZ"))));
        result.add(this.makeSettingMap("isDeleteBuyFactureEnabled", login.getSuperVizor() != false ? "true" : Boolean.valueOf(settingDao.getMSetup3Boolean(login, "W" + login.userCodeInc + "_N20DK"))));
        result.add(this.makeSettingMap("isDeleteSaleFactureEnabled", login.getSuperVizor() != false ? "true" : Boolean.valueOf(settingDao.getMSetup3Boolean(login, "W" + login.userCodeInc + "_N20DF"))));
        result.add(this.makeSettingMap("isDeleteReturnFromSaleFactureEnabled", login.getSuperVizor() != false ? "true" : Boolean.valueOf(settingDao.getMSetup3Boolean(login, "W" + login.userCodeInc + "_N20DY"))));
        result.add(this.makeSettingMap("isDeleteWastageFactureEnabled", login.getSuperVizor() != false ? "true" : Boolean.valueOf(settingDao.getMSetup3Boolean(login, "W" + login.userCodeInc + "_N20DZ"))));
        result.add(this.makeSettingMap("isEditBuyOrderEnabled", login.getSuperVizor() != false ? "true" : Boolean.valueOf(settingDao.getMSetup3Boolean(login, "W" + login.userCodeInc + "_NUpdRqEK"))));
        result.add(this.makeSettingMap("isEditSaleOrderEnabled", login.getSuperVizor() != false ? "true" : Boolean.valueOf(settingDao.getMSetup3Boolean(login, "W" + login.userCodeInc + "_NUpdRqEF"))));
        result.add(this.makeSettingMap("isDeleteBuyOrderEnabled", login.getSuperVizor() != false ? "true" : Boolean.valueOf(settingDao.getMSetup3Boolean(login, "W" + login.userCodeInc + "_NUpdRqDK"))));
        result.add(this.makeSettingMap("isDeleteSaleOrderEnabled", login.getSuperVizor() != false ? "true" : Boolean.valueOf(settingDao.getMSetup3Boolean(login, "W" + login.userCodeInc + "_NUpdRqDF"))));
        return result;
    }

    @NotNull
    private List<Map<String, Object>> initResult(SqlRowSet rs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            String name = rs.getString("name");
            String value = rs.getString("value");
            if (name != null && value != null && name.equals("FreeCodeForCustomer")) {
                value = value.substring(0, value.length() - 1);
            }
            if (value != null && (value.equals("false") || value.equals("true"))) {
                result.add(this.makeSettingMap(name, (Object)ConvertStr.boolStrToBool((String)value)));
                continue;
            }
            result.add(this.makeSettingMap(name, (Object)value));
        }
        return result;
    }

    private List<Map<String, Object>> addUserRelatedSettings(TncJdbc jdbcTemplate, boolean isRestaurant) {
        LoginDto login = jdbcTemplate.getLogin();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String sql = " SELECT isNull(RMDroidChangPrice, 0) canChangePrice, \n";
        sql = !isRestaurant ? sql + " WSendParty, WSearchFact, WInsertParty, WEditPartyByUser, \n WSendReminParty, WEditFactByUser, \n WSendReminChequeNotReceive, WSendChequeNotReceive, WPayoffParty_Pardakht, WPayoffParty, \n WReciveDiscount, WInsertReciveKind, WEditOrderByUser, \n WMoienReport, WNotAllowDiscount, NotAccessRecordTaradod, \n" : sql + " RmDroidEditFactorAccess, RmDroidTasviehFactorAccess, RmTasviehFactor_PosOnly, RmTasviehFactor_ForceTasvieh, Garson_Takhfif, ";
        sql = sql + " ChangeTakhfif, isNull(DBPnlOrderPriceType, 0) IsKitPriceType, ChangePriceFact_FK, \n ChangePriceFactKharid, ISNULL(ChangePriceFact_Y, 0) ChangePriceFact_Y, DroidGPSType, NotShowExist, \n IsNull(MiddleManId, '00000') MiddleManId, \n IsNull(DBPnlUserArtAmountRight, 0) IsCheckArticleCount, \n ISNULL(NotshowBuyPrice, 0) NotshowBuyPrice, ChangePriceKala, NotShowPursant, ISNULL(DBPnlOrderPrice, 0) DBPnlOrderPrice, \n ChangePursant, UseExist2Only \n FROM UserDb WHERE UserCodeInc = ?";
        Map userRelatedSettings = jdbcTemplate.queryForMap(sql, new Object[]{login.getUserCodeInc()});
        result.add(this.makeSettingMap("Ischangprice", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("canChangePrice", "false").toString())));
        boolean allowSendParty = ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WSendParty", "false").toString());
        result.add(this.makeSettingMap("allowSendParty", (Object)allowSendParty));
        result.add(this.makeSettingMap("searchInvoice", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WSearchFact", "false").toString())));
        result.add(this.makeSettingMap("allowAddParty", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WInsertParty", "false").toString())));
        result.add(this.makeSettingMap("editMyParty", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WEditPartyByUser", "false").toString())));
        result.add(this.makeSettingMap("allowPartyRemain", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WSendReminParty", "false").toString())));
        result.add(this.makeSettingMap("editMyInvoice", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WEditFactByUser", "false").toString())));
        result.add(this.makeSettingMap("allowPartyChequeReamin", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WSendReminChequeNotReceive", "false").toString())));
        result.add(this.makeSettingMap("allowShowPartyChequeInfo", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WSendChequeNotReceive", "false").toString())));
        boolean hasPayAccess = ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WPayoffParty_Pardakht", "false").toString());
        boolean hasReceiptAccess = ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WPayoffParty", "false").toString());
        result.add(this.makeSettingMap("hasPayAccess", (Object)(allowSendParty && hasPayAccess ? 1 : 0)));
        result.add(this.makeSettingMap("hasReceiptAccess", (Object)(allowSendParty && hasReceiptAccess ? 1 : 0)));
        result.add(this.makeSettingMap("allowRecieveCalcInfo", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WReciveDiscount", "false").toString())));
        result.add(this.makeSettingMap("allowRecieveArticle", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WInsertReciveKind", "false").toString())));
        result.add(this.makeSettingMap("searchRecieveArticle", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WEditOrderByUser", "false").toString())));
        result.add(this.makeSettingMap("allowPartyMoein", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WMoienReport", "false").toString())));
        result.add(this.makeSettingMap("NotAllowShowTakhfifVisitor", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("WNotAllowDiscount", "false").toString())));
        result.add(this.makeSettingMap("IsKitChangeTakhfif", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("ChangeTakhfif", "false").toString())));
        result.add(this.makeSettingMap("IsKitPriceType", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("IsKitPriceType", "false").toString())));
        result.add(this.makeSettingMap("IsPartyPrice", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("IsKitPriceType", "false").toString())));
        result.add(this.makeSettingMap("PriceChangeByUserSell", (Object)ConvertStr.boolStrToBool((String)(login.getSuperVizor() != false ? "true" : userRelatedSettings.getOrDefault("ChangePriceFact_FK", "false").toString()))));
        result.add(this.makeSettingMap("PriceChangeByUserBuy", (Object)ConvertStr.boolStrToBool((String)(login.getSuperVizor() != false ? "true" : userRelatedSettings.getOrDefault("ChangePriceFactKharid", "false").toString()))));
        result.add(this.makeSettingMap("PriceChangeByUserRetSell", (Object)ConvertStr.boolStrToBool((String)(login.getSuperVizor() != false ? "true" : userRelatedSettings.getOrDefault("ChangePriceFact_Y", "false").toString()))));
        result.add(this.makeSettingMap("MiddleManCode", (Object)userRelatedSettings.getOrDefault("MiddleManId", "00000").toString()));
        result.add(this.makeSettingMap("IsadminGps", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("DroidGPSType", "false").toString())));
        result.add(this.makeSettingMap("allowShowArticleStock", (Object)(!ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("NotShowExist", "false").toString()) ? 1 : 0)));
        result.add(this.makeSettingMap("IsCheckArticleCount", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("IsCheckArticleCount", "false").toString())));
        result.add(this.makeSettingMap("NotshowBuyPrice", (Object)ConvertStr.boolStrToBool((String)(login.getSuperVizor() != false ? "false" : userRelatedSettings.getOrDefault("NotshowBuyPrice", "false").toString()))));
        result.add(this.makeSettingMap("NotShowSellPrice", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("DBPnlOrderPrice", "false").toString())));
        result.add(this.makeSettingMap("NotShowPursant", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("NotShowPursant", "false").toString())));
        result.add(this.makeSettingMap("cannotManualRecordVisit", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("NotAccessRecordTaradod", "false").toString())));
        result.add(this.makeSettingMap("CanChangeCommission", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("ChangePursant", "false").toString())));
        result.add(this.makeSettingMap("UseExist2Only", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("UseExist2Only", "false").toString())));
        if (isRestaurant) {
            result.add(this.makeSettingMap("RmDroidEditFactorAccess", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("RmDroidEditFactorAccess", "false").toString())));
            boolean rmDroidTasviehFactorAccess = ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("RmDroidTasviehFactorAccess", "false").toString());
            boolean isPaymentJustWithPos = ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("RmTasviehFactor_PosOnly", "false").toString());
            boolean isForcePayment = ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("RmTasviehFactor_ForceTasvieh", "false").toString());
            result.add(this.makeSettingMap("RmDroidTasviehFactorAccess", (Object)rmDroidTasviehFactorAccess));
            result.add(this.makeSettingMap("isPaymentJustWithPos", (Object)(rmDroidTasviehFactorAccess && isPaymentJustWithPos ? 1 : 0)));
            result.add(this.makeSettingMap("isForcePayment", (Object)(rmDroidTasviehFactorAccess && isForcePayment ? 1 : 0)));
            result.add(this.makeSettingMap("isGarconDiscountEnabled", (Object)ConvertStr.boolStrToBool((String)userRelatedSettings.getOrDefault("Garson_Takhfif", "false").toString())));
        }
        return result;
    }

    private List<Map<String, Object>> getAttrNames(TncJdbc jdbcTemplate) {
        String sql = "SELECT [NAME], [STRING] FROM MSetup2 \n WHERE [NAME] IN ('ArtLableOther1', 'ArtLableOther2', 'ArtLableOther3', 'ArtLableOther4', \n'ArtLableOther5', 'ArtLableOther6', 'ArtLableOther7', 'ArtLableOther8', \n'ArtLableOther9', 'ArtLableOther10')";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sql);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            String name = rs.getString("NAME");
            if (name == null) continue;
            String numPart = name.replace("ArtLableOther", "");
            result.add(this.makeSettingMap("atrTitle" + numPart, (Object)rs.getString("STRING")));
        }
        return result;
    }

    private Map<String, Object> makeSettingMap(String aName, Object aValue) {
        return ConvertStr.buildMap(map -> {
            map.put("name", aName);
            map.put("value", aValue);
        });
    }

    public BaseResponse<Map<String, Object>> getFactConfig(LoginDto loginDto) {
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(loginDto);
        SoftwareInfo info = new SoftwareInfo(jdbc);
        String sql = "SELECT id, code, title, stockInfluence, factConfigId,\n  CAST(1 AS BIT) allowFinalSave, CAST(0 AS BIT) allowTmpSave\n FROM (SELECT cfc.id, cfc.code, cfc.Title AS Title, cfc.StockInfluence,\n   cfc.FactConfigId, rms.Value, ISNULL(rms.UserID, cfc.userid) UserID\n  FROM (\n   SELECT cfc.*, u.UserCodeInc UserID\n   FROM (\n    SELECT 1 AS id, 1 AS code, '\u0633\u0641\u0627\u0631\u0634 \u062e\u0631\u064a\u062f' AS Title, 0 AS StockInfluence, 0 AS FactConfigId\n    UNION\n    SELECT 2 AS id, 2 AS code, '\u0633\u0641\u0627\u0631\u0634 \u0641\u0631\u0648\u0634' AS Title, 1 AS StockInfluence, 0 AS FactConfigId\n" + (info.isNetworkMode() ? "    UNION\n    SELECT 3 AS id, 3 AS code, '\u062e\u0631\u064a\u062f' AS Title, 0 AS StockInfluence, 1 AS FactConfigId\n    UNION\n    SELECT 4 AS id, 4 AS code, '\u0641\u0631\u0648\u0634' AS Title, 1 AS StockInfluence, 2 AS FactConfigId\n    UNION\n    SELECT 5 AS id, 5 AS code, '\u0628\u0631\u06af\u0634\u062a \u0627\u0632 \u0641\u0631\u0648\u0634' AS Title, 0 AS StockInfluence, 3 AS FactConfigId\n    UNION\n    SELECT 6 AS id, 6 AS code, '\u0636\u0627\u064a\u0639\u0627\u062a' AS Title, 1 AS StockInfluence, 4 AS FactConfigId\n" : "") + "   ) cfc INNER JOIN USERDB AS u ON u.UserCodeInc > 0\n  ) cfc LEFT JOIN RMServerSetting rms \n   ON rms.EntityName = 'CommFactConfig' AND rms.EntityID = cfc.Id AND cfc.UserID = rms.UserID\n WHERE rms.[Value] > 0 and cfc.UserID = ?) a";
        List result = jdbc.queryForList(sql, new Object[]{loginDto.getUserCodeInc()});
        return new BaseResponse.Builder().data(result).build();
    }

    public BaseResponse<Map<String, Object>> getCompanyBackupId(LoginDto login) {
        HolooSettingsDao settingDao = new HolooSettingsDao(this.dbConnection);
        int backupId = settingDao.getMSetup2Integer(login, "F_EncCount");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ArrayList<HashMap<String, Integer>> result = new ArrayList<HashMap<String, Integer>>();
        result.add(map);
        map.put("backupId", backupId);
        return new BaseResponse.Builder().data(result).build();
    }
}

