/*
 * Decompiled with CFR 0.152.
 */
package com.category.data;

import com.category.domain.model.Category;
import com.category.domain.model.ProductCategory;
import com.dao.util.PoshakPropertiesBulkInsert;
import com.dto.LoginDto;
import com.utility.DbConnection;
import com.utility.GetIdentity;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class CategoryDao {
    private final DbConnection dbConnection;

    public LoginDto setToken() {
        return this.dbConnection.setToken();
    }

    public void bulkInsertPoshakProperties(List<ProductCategory> productCategoryList) throws TncException {
        new PoshakPropertiesBulkInsert(this.dbConnection).bulkInsert(this.setToken(), productCategoryList);
    }

    public List<Map<String, Object>> getPoshakProps(String sqlWhere) {
        return this.dbConnection.getJdbcTemplate(this.setToken()).queryForList(this.getCategoryQuerySql(sqlWhere));
    }

    public List<Category> getPoshakPropsAsObject(String sqlWhere) {
        String sql = this.getCategoryQuerySql(sqlWhere);
        return this.dbConnection.getJdbcTemplate(this.setToken()).query(sql, (rs, rowNum) -> Category.builder().id(Long.valueOf(rs.getLong("Id"))).parentId(rs.getLong("ParentId")).name(rs.getString("Name")).treeName(rs.getString("TreeName")).build());
    }

    @NotNull
    private String getCategoryQuerySql(String sqlWhere) {
        return "SELECT [Id], [ParentId], [Name], DBO.GetPropsTreeName(ID) TreeName, \nDBO.GetPropsTreeId(ID) TreeCode \nFROM [PoshakProperties] " + sqlWhere + " ORDER BY ID";
    }

    public long insertCategory(@NotNull Category category, LoginDto login) {
        Long resultId = (Long)this.dbConnection.getTransactionTemplate(login).execute(status -> {
            String sql = "INSERT INTO PoshakProperties(ParentID, Name) VALUES (?, ?)";
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
            jdbcTemplate.update(sql, new Object[]{category.getParentId(), category.getName()});
            long id = GetIdentity.invoke((TncJdbc)jdbcTemplate);
            if (id == -1L) {
                throw new TncException(TncExceptionMessages.ERROR_WHILE_ADDING_CATEGORY);
            }
            return id;
        });
        return resultId == null ? -1L : resultId;
    }

    public void update(@NotNull Category category, LoginDto login) {
        String sql = "UPDATE PoshakProperties SET [Name] = ? WHERE [ID] = ?";
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(login);
        jdbcTemplate.update(sql, new Object[]{category.getName(), category.getId()});
    }

    public DbConnection getDbConnection() {
        return this.dbConnection;
    }

    public CategoryDao(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

