/*
 * Decompiled with CFR 0.152.
 */
package com.category.domain;

import com.category.domain.model.Category;
import com.category.domain.model.ProductCategory;
import com.category.domain.use_case.category.AddCategory;
import com.category.domain.use_case.category.BatchInsertCategories;
import com.category.domain.use_case.category.CheckCategoryErrors;
import com.category.domain.use_case.category.GetCategories;
import com.category.domain.use_case.category.UpdateCategory;
import com.dto.LoginDto;
import com.google.gson.Gson;
import com.utility.ConvertStr;
import com.utility.TextNormalizer;
import com.utility.TncException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class CategoryService {
    private final GetCategories getCategories;
    private final BatchInsertCategories batchInsertCategories;
    private final AddCategory addCategory;
    private final UpdateCategory updateCategory;
    private final CheckCategoryErrors checkCategoryErrors;

    public ResponseEntity<Map<Object, List<Map<String, Object>>>> getCategories(@NotNull HttpServletRequest request) {
        return ConvertStr.getMapResponseEntity((String)"PoshakProps", (List)this.getCategories.invoke(request.getParameterMap()), (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    public synchronized ResponseEntity<Map<String, Object>> postCategories(@NotNull List<Category> categories) {
        ArrayList<Map> succeededList = new ArrayList<Map>();
        ArrayList<Map> failedList = new ArrayList<Map>();
        LoginDto login = this.addCategory.setToken();
        for (Category category : categories) {
            try {
                this.checkCategoryErrors.invoke(category);
            }
            catch (TncException e) {
                failedList.add(e.getErrorMap());
                continue;
            }
            long id = this.addCategory.invoke(category, login);
            category.setParentId(id);
            List subCatIds = this.insertSubCategories(category, login);
            succeededList.add(ConvertStr.buildMap(map -> {
                map.put("id", id);
                map.put("sub-category-ids", subCatIds);
            }));
        }
        return ConvertStr.getMapResponseEntity((String)"categoryItems", failedList, succeededList);
    }

    private List<Long> insertSubCategories(Category category, LoginDto login) {
        ArrayList<Long> insertedSubCatIds = new ArrayList<Long>();
        if (ConvertStr.isNullOrEmpty((Collection)category.getSubCategoryNames())) {
            return insertedSubCatIds;
        }
        for (String subCategoryName : category.getSubCategoryNames()) {
            insertedSubCatIds.add(this.addCategory.invoke(Category.builder().name(subCategoryName).parentId(category.getParentId()).build(), login));
        }
        return insertedSubCatIds;
    }

    public ResponseEntity<Map<String, Object>> updateCategories(@NotNull List<Category> categories) {
        ArrayList<Map> succeededList = new ArrayList<Map>();
        ArrayList<Map> failedList = new ArrayList<Map>();
        LoginDto login = this.updateCategory.setToken();
        for (Category category : categories) {
            try {
                this.checkCategoryErrors.invokeForUpdate(category);
            }
            catch (TncException e) {
                failedList.add(e.getErrorMap());
                continue;
            }
            this.updateCategory.invoke(category, login);
            succeededList.add(ConvertStr.buildMap(map -> map.put("id", category.getId())));
        }
        return ConvertStr.getMapResponseEntity((String)"categoryItems", failedList, succeededList);
    }

    public ResponseEntity<?> postSmartHelpCategories(byte[] zippedBody) {
        String body = ConvertStr.deCompressionGZip((byte[])zippedBody);
        body = body.substring(14, body.length() - 1);
        Gson gson = new Gson();
        ProductCategory[] items = (ProductCategory[])gson.fromJson(body, ProductCategory[].class);
        return ConvertStr.getMapResponseEntity((String)"PoshakProperties", new ArrayList(), (List)this.batchInsertCategories.invoke(Arrays.asList(items)));
    }

    public CategoryService(GetCategories getCategories, BatchInsertCategories batchInsertCategories, AddCategory addCategory, UpdateCategory updateCategory, CheckCategoryErrors checkCategoryErrors) {
        this.getCategories = getCategories;
        this.batchInsertCategories = batchInsertCategories;
        this.addCategory = addCategory;
        this.updateCategory = updateCategory;
        this.checkCategoryErrors = checkCategoryErrors;
    }
}

