/*
 * Decompiled with CFR 0.152.
 */
package com.category.domain.use_case.category;

import com.category.domain.model.Category;
import com.category.domain.use_case.category.GetCategories;
import com.utility.ConvertStr;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class CheckCategoryErrors {
    private final GetCategories getCategories;

    public void invoke(@NotNull Category category) throws TncException {
        boolean categoryExists;
        if (ConvertStr.isNullOrEmpty((String)category.getName())) {
            throw new TncException(TncExceptionMessages.INVALID_CATEGORY_NAME);
        }
        boolean bl = categoryExists = !this.categoryNotExists("name", category.getName());
        if (categoryExists) {
            throw new TncException(TncExceptionMessages.CATEGORY_PARENT_NAME_EXISTS);
        }
    }

    public void invokeForUpdate(@NotNull Category category) throws TncException {
        if (category.getId() == null || category.getId() == 0L) {
            throw new TncException(TncExceptionMessages.INVALID_CATEGORY_ID);
        }
        if (ConvertStr.isNullOrEmpty((String)category.getName())) {
            throw new TncException(TncExceptionMessages.INVALID_CATEGORY_NAME);
        }
        if (this.categoryNotExists("id", category.getId().toString())) {
            throw new TncException(TncExceptionMessages.INVALID_CATEGORY_ID);
        }
    }

    private boolean categoryNotExists(String field, String name) {
        return this.getCategories.invokeAsObject(this.makeNameParamMapFromSupplier(field, name)).isEmpty();
    }

    @NotNull
    private Map<String, String[]> makeNameParamMapFromSupplier(String field, String provideName) {
        HashMap<String, String[]> paramsMap = new HashMap<String, String[]>();
        paramsMap.put(field, new String[]{provideName});
        return paramsMap;
    }

    public CheckCategoryErrors(GetCategories getCategories) {
        this.getCategories = getCategories;
    }
}

