/*
 * Decompiled with CFR 0.152.
 */
package com.category.domain.use_case.category;

import com.category.data.CategoryDao;
import com.category.data.ProductCategoryDao;
import com.category.domain.model.Category;
import com.dto.LoginDto;
import org.springframework.stereotype.Service;

@Service
public class UpdateCategory {
    private final CategoryDao dao;
    private final ProductCategoryDao productCatDao;

    public void invoke(Category category, LoginDto login) {
        this.dao.getDbConnection().getTransactionTemplate(login).executeWithoutResult(status -> {
            this.dao.update(category, login);
            this.productCatDao.updateProductCatName(login, category);
        });
    }

    public LoginDto setToken() {
        return this.dao.setToken();
    }

    public UpdateCategory(CategoryDao dao, ProductCategoryDao productCatDao) {
        this.dao = dao;
        this.productCatDao = productCatDao;
    }
}

