/*
 * Decompiled with CFR 0.152.
 */
package com.category.domain.use_case.product_category;

import com.category.data.ProductCategoryDao;
import com.category.domain.model.ProductCategory;
import com.utility.ConvertStr;
import com.utility.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

@Service
public class FilterExistingProductCats {
    private final ProductCategoryDao dao;

    public List<ProductCategory> invoke(List<String> pidList) {
        String boundPIDs = this.boundPIDs(pidList);
        String sql = "DECLARE @NewTree VARCHAR(250)\nSET @NewTree = '" + boundPIDs + "' -- New tree structure to be added\n-- Create a temporary table to hold the new tree structure \nCREATE TABLE #NewTreeTable (pid INT)\n-- Populate the temporary table with values from the new tree structure\nDECLARE @Delimiter CHAR(" + "->".length() + ")\nSET @Delimiter = '" + "->" + "'\nDECLARE @Position INT\nSET @Position = CHARINDEX(@Delimiter, @NewTree)\n\nWHILE @Position > 0\n    BEGIN\n        INSERT INTO #NewTreeTable (pid)\n        VALUES (CAST(SUBSTRING(@NewTree, 1, @Position - 1) AS INT))\n        SET @NewTree = SUBSTRING(@NewTree, @Position + 2, LEN(@NewTree))\n        SET @Position = CHARINDEX(@Delimiter, @NewTree)\n    END\n\nINSERT INTO #NewTreeTable (pid)\nVALUES (CAST(@NewTree AS INT))\n\n-- Temporary table to hold the existing nodes\nCREATE TABLE #ExistingNodes (id int, parentId INT, pid INT, TreePath VARCHAR(250))\n\n-- Get the root node of the provided tree\nINSERT INTO #ExistingNodes (id, parentId, pid, TreePath)\nSELECT id, parentId, pid, CAST(pid AS VARCHAR(250)) AS TreePath\nFROM poshak\nWHERE pid = (SELECT TOP 1 pid FROM #NewTreeTable) AND ParentID = 0\n\nDECLARE @Parent INT\n\n-- Cursor to traverse through the tree structure\nDECLARE node_cursor CURSOR FOR\n    SELECT pid\n    FROM #ExistingNodes\n\nOPEN node_cursor\n\nFETCH NEXT FROM node_cursor INTO @Parent\n\nWHILE @@FETCH_STATUS = 0\n    BEGIN\n        INSERT INTO #ExistingNodes (id, parentId, pid, TreePath)\n        SELECT p.id, p.parentId, p.pid, \n           en.TreePath + '" + "->" + "' + CAST(p.pid AS VARCHAR(250))\n        FROM poshak p\n                 JOIN #ExistingNodes en ON p.parentId = en.id\n                 JOIN #NewTreeTable nt ON p.pid = nt.pid\n        WHERE en.pid = @Parent\n\n        FETCH NEXT FROM node_cursor INTO @Parent\n    END\n\nCLOSE node_cursor\nDEALLOCATE node_cursor\n\n-- Select all existing nodes corresponding to the provided tree structure\nSELECT distinct *\nFROM #ExistingNodes\n\n-- Drop temporary tables\nDROP TABLE #NewTreeTable\nDROP TABLE #ExistingNodes\n";
        SqlRowSet rs = this.dao.rawQueryForRowSet(sql);
        Pair lastParent = this.getLastParentIdWExistingPIDs(rs, boundPIDs);
        List pidToCategoryList = Arrays.stream(boundPIDs.split("->")).map(pid -> ProductCategory.builder().pid(Integer.valueOf(pid)).build()).collect(Collectors.toList());
        List<ProductCategory> toInsertList = pidToCategoryList.stream().filter(category -> !((List)lastParent.getRight()).contains(category.getPid())).collect(Collectors.toList());
        if (!toInsertList.isEmpty()) {
            ((ProductCategory)ConvertStr.getLast(toInsertList)).setParentid((Integer)lastParent.getLeft());
        } else if ((Integer)lastParent.getLeft() == 0) {
            toInsertList.addAll(pidToCategoryList);
        } else {
            toInsertList.add(ProductCategory.builder().parentid((Integer)lastParent.getLeft()).build());
        }
        return toInsertList;
    }

    private String boundPIDs(List<String> pidList) {
        if (ConvertStr.isNullOrEmpty(pidList)) {
            return "";
        }
        return ConvertStr.bindStringsWrapByCharacter(pidList, (String)"->", null, null);
    }

    private Pair<Integer, List<Integer>> getLastParentIdWExistingPIDs(SqlRowSet rs, String boundPIDs) {
        Pair parentToUse = new Pair((Object)0, (Object)this.mapBoundPIDsToIntList(boundPIDs));
        String maxTreePath = "";
        while (rs.next()) {
            String currentTreePath = Objects.requireNonNull(rs.getString("TreePath"));
            if (!boundPIDs.contains(currentTreePath) || maxTreePath.length() >= currentTreePath.length()) continue;
            maxTreePath = currentTreePath;
            parentToUse = new Pair((Object)rs.getInt("id"), (Object)this.mapBoundPIDsToIntList(currentTreePath));
        }
        return parentToUse;
    }

    @NotNull
    private List<Integer> mapBoundPIDsToIntList(String boundPIDs) {
        return Arrays.stream(boundPIDs.split("->")).map(Integer::parseInt).collect(Collectors.toList());
    }

    public FilterExistingProductCats(ProductCategoryDao dao) {
        this.dao = dao;
    }
}

