/*
 * Decompiled with CFR 0.152.
 */
package com.category.domain.use_case.product_category;

import com.category.data.ProductCategoryDao;
import com.category.domain.use_case.GetSellPrices;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.SearchQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class GetProductCategories {
    private final ProductCategoryDao dao;
    private final GetSellPrices getSellPrices;

    public List<Map<String, Object>> invoke(HttpServletRequest request, String aCode) {
        LoginDto login = this.dao.setToken();
        String sqlWhere = this.getFilter(request);
        sqlWhere = this.getSqlWhere(sqlWhere, aCode);
        List rowSetPoshak = this.dao.getProductCategories(login, sqlWhere);
        List rowSellPrices = this.dao.getPCategorySellPrices(login, sqlWhere);
        ArrayList<Map<String, Object>> mapPoshakList = new ArrayList<Map<String, Object>>();
        for (Map poshak : rowSetPoshak) {
            if (!ConvertStr.isNullOrEmpty((String)aCode) && !aCode.equals(poshak.get("A_Code"))) continue;
            this.getSellPrices.invoke(poshak, rowSellPrices);
            if (!login.getIsMyHoloo().booleanValue()) {
                poshak.put("A_code", ConvertStr.encrypt((String)((String)poshak.get("A_code"))));
            }
            mapPoshakList.add(poshak);
        }
        return mapPoshakList;
    }

    private String getSqlWhere(String sqlWhere, String aCode) {
        if (aCode == null) {
            return sqlWhere;
        }
        if (ConvertStr.isNullOrEmpty((String)sqlWhere)) {
            return " WHERE A.A_CODE=" + aCode;
        }
        return sqlWhere + " AND A.A_CODE=" + aCode;
    }

    private String getFilter(HttpServletRequest request) {
        String sqlWhere = "";
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        SearchQuery searchQuery = new SearchQuery();
        if (info.containsKey("id")) {
            sqlWhere = sqlWhere + "AND " + searchQuery.makeSqlQueryNoTextSearch((String)info.get("id"), "[poshakId]", "i");
        }
        if (info.containsKey("a_code")) {
            sqlWhere = sqlWhere + "AND " + searchQuery.makeSqlQueryNoTextSearch((String)info.get("a_code"), "[a_code]", "i");
        }
        if (info.containsKey("parentid")) {
            sqlWhere = sqlWhere + "AND " + searchQuery.makeSqlQueryNoTextSearch((String)info.get("parentid"), "[parentId]", "i");
        }
        if (info.containsKey("producterpcode")) {
            sqlWhere = sqlWhere + "AND " + searchQuery.makeSqlQueryNoTextSearch(ConvertStr.decrypt((String)((String)info.get("producterpcode"))), "[a_code]", "i");
        }
        if (!sqlWhere.isEmpty()) {
            sqlWhere = " Where 1 = 1 " + sqlWhere;
        }
        return sqlWhere;
    }

    public GetProductCategories(ProductCategoryDao dao, GetSellPrices getSellPrices) {
        this.dao = dao;
        this.getSellPrices = getSellPrices;
    }
}

