/*
 * Decompiled with CFR 0.152.
 */
package com.core.util.filter;

import com.android.core.utils.params.QueryParams;
import com.core.util.filter.Filter;
import com.core.util.filter.GenericParamFactory;
import com.utility.ConvertStr;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InternalFilter
implements Filter {
    private final Map<String, String> params;
    private final GenericParamFactory paramFactory;

    public String getFilter() {
        if (this.paramFactory.equals((Object)GenericParamFactory.NO_QUERY)) {
            return "";
        }
        QueryParams queryParams = this.paramFactory.getInstance();
        for (String nextParam : this.params.keySet()) {
            if (this.isPagingParam(nextParam)) continue;
            String paramValue = (String)this.params.get(nextParam);
            queryParams.addParam(nextParam, paramValue);
        }
        return ConvertStr.nullSafeString((String)queryParams.makeWhere());
    }

    public Map<String, String> makeUserParamMap(boolean lowerCaseParamNames) {
        ConcurrentHashMap<String, String> userGivenParamMap = new ConcurrentHashMap<String, String>();
        for (String nextParam : this.params.keySet()) {
            String paramValue;
            if (this.isPagingParam(nextParam) || (paramValue = (String)this.params.get(nextParam)) == null) continue;
            userGivenParamMap.put(lowerCaseParamNames ? nextParam.toLowerCase() : nextParam, paramValue);
        }
        return userGivenParamMap;
    }

    public InternalFilter(Map<String, String> params, GenericParamFactory paramFactory) {
        this.params = params;
        this.paramFactory = paramFactory;
    }
}

