/*
 * Decompiled with CFR 0.152.
 */
package com.customer.domain.use_case;

import com.android.invoice.domain.use_case.discount.CalcDiscount;
import java.util.Objects;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class DiscountBasedOnRowDetails {
    private final SqlRowSet tpMasterRS;
    private final CalcDiscount.TieredDiscountOrCommissionData data;

    public double calcGenerally() {
        switch (this.tpMasterRS.getInt("RType")) {
            case 0: {
                return this.tpMasterRS.getDouble("TPValue");
            }
            case 1: {
                switch (this.tpMasterRS.getInt("calc_Type")) {
                    case 0: {
                        return this.tpMasterRS.getDouble("TPValue") * (this.data.getPriceSum() - this.data.getPrevTp()) / 100.0;
                    }
                    case 1: {
                        return this.tpMasterRS.getDouble("TPValue") * this.data.getPriceSum() / 100.0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.tpMasterRS.getInt("calc_Type")) {
                    case 0: {
                        return this.tpMasterRS.getDouble("TPValue") * ((this.data.getPriceSum() - this.data.getPrevTp()) / this.data.getAmountSum());
                    }
                    case 1: {
                        return this.tpMasterRS.getDouble("TPValue") * this.data.getPriceSum() / this.data.getAmountSum();
                    }
                }
                break;
            }
            case 3: {
                switch (this.tpMasterRS.getInt("calc_Type")) {
                    case 0: {
                        return this.tpMasterRS.getDouble("TPValue") * this.data.getBoxAmount() * ((this.data.getPriceSum() - this.data.getPrevTp()) / this.data.getAmountSum());
                    }
                    case 1: {
                        return this.tpMasterRS.getDouble("TPValue") * this.data.getBoxAmount() * (this.data.getPriceSum() / this.data.getAmountSum());
                    }
                }
                break;
            }
            case 4: {
                switch (this.tpMasterRS.getInt("calc_Type")) {
                    case 0: {
                        return this.tpMasterRS.getDouble("TPValue") * this.data.getPackAmount() * ((this.data.getPriceSum() - this.data.getPrevTp()) / this.data.getAmountSum());
                    }
                    case 1: {
                        return this.tpMasterRS.getDouble("TPValue") * this.data.getPackAmount() * (this.data.getPriceSum() / this.data.getAmountSum());
                    }
                }
            }
        }
        return 0.0;
    }

    public double calcBasedOnPrice() {
        boolean priceSumBetweenTpMasterValues;
        boolean bl = priceSumBetweenTpMasterValues = this.data.getPriceSum() >= this.tpMasterRS.getDouble("ValueFrom") && this.data.getPriceSum() <= this.tpMasterRS.getDouble("ValueTo");
        if (!priceSumBetweenTpMasterValues) {
            return 0.0;
        }
        return this.calcGenerally();
    }

    public double calcBasedOnAmount() {
        boolean amountSumBetweenTpMasterValues;
        boolean bl = amountSumBetweenTpMasterValues = this.data.getAmountSum() >= this.tpMasterRS.getDouble("ValueFrom") && this.data.getAmountSum() <= this.tpMasterRS.getDouble("ValueTo");
        if (!amountSumBetweenTpMasterValues) {
            return 0.0;
        }
        return this.calcGenerally();
    }

    public double calcBasedOnUnit() {
        boolean amountSumBetweenTpMasterValues;
        if (!Objects.equals(this.data.getUnitCode(), String.valueOf(this.tpMasterRS.getLong("Unit_Code")))) {
            return 0.0;
        }
        boolean bl = amountSumBetweenTpMasterValues = this.data.getAmountSum() >= this.tpMasterRS.getDouble("ValueFrom") && this.data.getAmountSum() <= this.tpMasterRS.getDouble("ValueTo");
        if (!amountSumBetweenTpMasterValues) {
            return 0.0;
        }
        return this.calcGenerally();
    }

    public double calcBasedOnBox() {
        boolean boxAmountBetweenTpMasterValues;
        if (this.data.getAmountSum() <= 0.0) {
            return 0.0;
        }
        boolean bl = boxAmountBetweenTpMasterValues = this.data.getBoxAmount() >= this.tpMasterRS.getDouble("ValueFrom") && this.data.getBoxAmount() <= this.tpMasterRS.getDouble("ValueTo");
        if (!boxAmountBetweenTpMasterValues) {
            return 0.0;
        }
        return this.calcGenerally();
    }

    public double calcBasedOnPack() {
        boolean packAmountBetweenTpMasterValues;
        if (this.data.getAmountSum() <= 0.0) {
            return 0.0;
        }
        boolean bl = packAmountBetweenTpMasterValues = this.data.getPackAmount() >= this.tpMasterRS.getDouble("ValueFrom") && this.data.getPackAmount() <= this.tpMasterRS.getDouble("ValueTo");
        if (!packAmountBetweenTpMasterValues) {
            return 0.0;
        }
        return this.calcGenerally();
    }

    public DiscountBasedOnRowDetails(SqlRowSet tpMasterRS, CalcDiscount.TieredDiscountOrCommissionData data) {
        this.tpMasterRS = tpMasterRS;
        this.data = data;
    }
}

