/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncJdbc;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class HolooSettingsDao {
    private final DbConnection dbConnection;

    public <T> T doMultiple(Function<SqlRowSet, T> aFunc, String columnName, String defaultValue, LoginDto login, String ... names) {
        SqlRowSet result = this.dbConnection.getJdbcTemplate(login).queryForRowSet("SELECT [Name], isNull(" + columnName + ", " + defaultValue + ") " + columnName + " FROM MSetup2 WHERE [NAME] IN (" + ConvertStr.commaBindStringsWithQuotes(Arrays.asList(names)) + ")");
        return aFunc.apply(result);
    }

    public <T> Map<String, T> getMapMultiple(Function<SqlRowSet, T> doOnEachRow, String valueColName, String valueColDefaultValue, LoginDto login, String ... names) {
        SqlRowSet result = this.dbConnection.getJdbcTemplate(login).queryForRowSet("SELECT [Name], isNull(" + valueColName + ", " + valueColDefaultValue + ") " + valueColName + " FROM MSetup2 WHERE [NAME] IN (" + ConvertStr.commaBindStringsWithQuotes(Arrays.asList(names)) + ")");
        ConcurrentHashMap<String, T> resultMap = new ConcurrentHashMap<String, T>();
        block0: while (result.next()) {
            for (String name : names) {
                String setupName = result.getString("Name");
                if (setupName == null || !setupName.equalsIgnoreCase(name)) continue;
                resultMap.put(name, doOnEachRow.apply(result));
                continue block0;
            }
        }
        return resultMap;
    }

    public boolean getMSetup2Boolean(LoginDto login, String name) {
        String sqlStr = " Select [boolean] From MSETUP2 where [name]='" + name + "' ";
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr);
        if (rs.next()) {
            return rs.getBoolean("boolean");
        }
        return false;
    }

    public double getMSetup2Float(LoginDto login, String name) {
        String sqlStr = " Select Isnull([Double],0) [Double] From  MSETUP2  where [name]='" + name + "' ";
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr);
        if (rs.next()) {
            return rs.getDouble("Double");
        }
        return 0.0;
    }

    public int getMSetup2Integer(LoginDto login, String name) {
        return this.getMSetup2Integer(login, name, 0);
    }

    public int getMSetup2Integer(LoginDto login, String name, int defaultValue) {
        String sqlStr = " Select Isnull([Integer], " + defaultValue + ") [Integer] From MSETUP2 where [name]='" + name + "' ";
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr);
        if (rs.next()) {
            return rs.getInt("Integer");
        }
        return defaultValue;
    }

    public String getMSetup2String(LoginDto login, String name, String defaultVal) {
        String sqlStr = " Select IsNull([String], '') [String] From MSETUP2 where [name]='" + name + "' ";
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr);
        if (rs.next()) {
            return rs.getString("String");
        }
        return defaultVal;
    }

    public boolean getMSetupBoolean(LoginDto myLogin, String name) {
        boolean result = false;
        String sqlStr = " SELECT isNull(" + name + ", 0) " + name + " FROM MSETUP";
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(myLogin).queryForRowSet(sqlStr);
        while (rs.next()) {
            result = rs.getBoolean(name);
        }
        return result;
    }

    public boolean userHasLimitedAccessToProducts(LoginDto login) {
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(" SELECT isNull(DBPnlUserArtRight, 0) userHasLimitedProducts FROM USERDB WHERE UserCodeInc = ?", new Object[]{login.getUserCodeInc()});
        return rs.next() && rs.getBoolean("userHasLimitedProducts");
    }

    public TncJdbc getJdbcTemplate(LoginDto login) {
        return this.dbConnection.getJdbcTemplate(login);
    }

    public boolean getMSetup3Boolean(LoginDto login, String name) {
        String sqlStr = " Select [boolean] From MSETUP3 where [name]='" + name + "' ";
        SqlRowSet rs = this.dbConnection.getJdbcTemplate(login).queryForRowSet(sqlStr);
        if (rs.next()) {
            return rs.getBoolean("boolean");
        }
        return false;
    }

    public HolooSettingsDao(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

