/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dto.InvoiceDetailDto;
import com.dto.industrial.ArticleSarfasl;
import com.dto.industrial.GroupSarfasl;
import com.dto.industrial.IndustrialSarfaslDto;
import com.dto.industrial.SarfaslType;
import com.utility.DbLogin;
import com.utility.LockCode;
import com.utility.LockReader;
import com.utility.SoftwareInfo;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class IndustrialInvoiceDao {
    private final TncJdbc jdbcTemplate;

    public IndustrialInvoiceDao(DbLogin dbLogin) {
        this.jdbcTemplate = dbLogin.getDbConnection().getJdbcTemplate(dbLogin.getLogin());
    }

    public boolean isIndustrial() {
        LockReader lockReader = new LockReader(this.jdbcTemplate);
        SoftwareInfo info = new SoftwareInfo(this.jdbcTemplate, lockReader.getKey());
        return info.getLockInfo().endsWith("42") || info.getLockInfo().endsWith("24") || lockReader.isLockEnabled(LockCode.CALC_AVERAGE_BY_PERMANENT_WAY);
    }

    public ArticleSarfasl getArticleSarfaslFromInvoiceDtl(InvoiceDetailDto dtl) throws DataAccessException {
        return (ArticleSarfasl)this.jdbcTemplate.query(" SELECT S.[ID], [ArtID], [Main], [RetBuy], [Sell], [RetSell], [OffPrice], ISNULL(A.[BUY_PRICE], 0) BUY_PRICE FROM ArticleSarfasl S INNER JOIN ARTICLE A ON A.A_CODE = S.ArtID  WHERE ArtID = '" + dtl.getProductid() + "'", rs -> {
            if (rs.next()) {
                return ArticleSarfasl.builder().id(rs.getLong("ID")).code(rs.getString("ArtID")).mainSarfasl(rs.getString("Main")).retBuySarfasl(rs.getString("RetBuy")).sellSarfasl(rs.getString("Sell")).retSellSarfasl(rs.getString("RetSell")).offPriceSarfasl(rs.getString("OffPrice")).numberLine(dtl.getFew()).price(dtl.getPrice()).buyPrice(Double.valueOf(rs.getDouble("BUY_PRICE"))).build();
            }
            throw new TncException(TncExceptionMessages.ERROR_WHEN_MAKING_INDUSTRIAL_HEADINGS);
        });
    }

    public int getNextMGroupColCode(int defaultColCode, int typeId) {
        Integer nextColCode = (Integer)this.jdbcTemplate.queryForObject("SELECT ISNULL(MAX(COL_CODE) + 1, " + defaultColCode + ") A FROM SARFASL WHERE COL_CODE >= " + defaultColCode + " AND [TYPE] = " + typeId, Integer.class);
        return nextColCode != null ? nextColCode : defaultColCode;
    }

    public String getNextSGroupMoeenCode(String mGroupBuySarfasl) {
        String nextMoeenCode = (String)this.jdbcTemplate.queryForObject(" SELECT dbo.producCode4(ISNULL(MAX(Moien_Code) + 1, '1'), 4) A FROM SARFASL\n WHERE COL_CODE = '" + mGroupBuySarfasl + "' AND [TYPE] = '53'", String.class);
        return nextMoeenCode != null ? nextMoeenCode : "0001";
    }

    public String getNextProductTafsiliCode(String sGroupBuySarfasl) {
        String nextMoeenCode = (String)this.jdbcTemplate.queryForObject(" SELECT dbo.producCode4(ISNULL(MAX(Tafzili_Code) + 1, '1'), 4) A FROM SARFASL\n WHERE Sarfasl_Code = '" + sGroupBuySarfasl + "' AND [TYPE] = '53'", String.class);
        return nextMoeenCode != null ? nextMoeenCode : "0001";
    }

    public void insertGroupSarfasl(String id, Map<String, String> groupSarfaslResults) {
        this.jdbcTemplate.update(" INSERT INTO GroupSarfasl (GroupID, Main, RetBuy, SELL, RetSell, OffPrice) values (?, ?, ?, ?, ?, ?)", new Object[]{id, groupSarfaslResults.get(SarfaslType.Main.name()), groupSarfaslResults.get(SarfaslType.RetBuy.name()), groupSarfaslResults.get(SarfaslType.Sell.name()), groupSarfaslResults.get(SarfaslType.RetSell.name()), groupSarfaslResults.get(SarfaslType.OffPrice.name())});
    }

    public void insertArticleSarfasl(String id, Map<String, String> groupSarfaslResults) {
        this.jdbcTemplate.update(" INSERT INTO ArticleSarfasl (ArtID, Main, RetBuy, SELL, RetSell, OffPrice) values (?, ?, ?, ?, ?, ?)", new Object[]{id, groupSarfaslResults.get(SarfaslType.Main.name()), groupSarfaslResults.get(SarfaslType.RetBuy.name()), groupSarfaslResults.get(SarfaslType.Sell.name()), groupSarfaslResults.get(SarfaslType.RetSell.name()), groupSarfaslResults.get(SarfaslType.OffPrice.name())});
    }

    public IndustrialSarfaslDto getGroupSarfasl(String groupCode) {
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(" SELECT [ID], [GroupID], [Main], [RetBuy], [Sell], [RetSell], [OffPrice] FROM GroupSarfasl WHERE GroupId = '" + groupCode + "'");
        if (rs.next()) {
            return new GroupSarfasl((long)rs.getInt("ID"), rs.getString("GroupID"), rs.getString("Main"), rs.getString("RetBuy"), rs.getString("Sell"), rs.getString("RetSell"), rs.getString("OffPrice"));
        }
        return null;
    }

    public IndustrialSarfaslDto getArticleSarfasl(String articleCode) {
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(" SELECT [ID], [ArtID], [Main], [RetBuy], [Sell], [RetSell], [OffPrice] FROM ArticleSarfasl WHERE ArtId = '" + articleCode + "'");
        if (rs.next()) {
            return ArticleSarfasl.builder().id((long)rs.getInt("ID")).code(rs.getString("ArtID")).mainSarfasl(rs.getString("Main")).retBuySarfasl(rs.getString("RetBuy")).sellSarfasl(rs.getString("Sell")).retSellSarfasl(rs.getString("RetSell")).offPriceSarfasl(rs.getString("OffPrice")).build();
        }
        return null;
    }

    public Integer getWarehouseType(String mainGroupId) {
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(" SELECT Type_Anbar_C FROM M_GROUP WHERE M_GROUPCODE = '" + mainGroupId + "'");
        if (rs.next()) {
            return rs.getInt("Type_Anbar_C");
        }
        return null;
    }
}

