/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dao.SideGroupDao;
import com.dto.LoginDto;
import com.dto.MainGroupDto;
import com.google.gson.Gson;
import com.service.product.IndustrialProductService;
import com.utility.CallApi;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.DbLogin;
import com.utility.MyHolooMessageMaker;
import com.utility.TextNormalizer;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import com.utility.TransactionCheck;
import com.utility.UnavailableACode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class MainGroupDao {
    private final DbConnection dbConnection;

    public MainGroupDao(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public ResponseEntity<?> getMainGroupList(HttpServletRequest request) {
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        String sqlStr = " SELECT M_GROUPNAME  Name, M_GROUPCODE ErpCode, \n       ISNULL(DARSADTAKHFIF, 0) DiscountPercent, ISNULL(PRICETAKHFIF, 0) DiscountPrice  \n FROM M_GROUP";
        String sqlWhere = this.GetFilter(request);
        sqlStr = sqlStr + sqlWhere + " ORDER BY M_GROUPNAME ";
        List rowSet = jdbcTemplate.queryForList(sqlStr);
        if (myLogin.getIsMyHoloo().booleanValue()) {
            for (Map map : rowSet) {
                map.put("MainGroupCode", map.get("ErpCode"));
            }
        }
        ConvertStr.getMapRowSet((List)rowSet);
        return ConvertStr.getMapResponseEntity((String)"mainGroup", (List)rowSet, (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    private StringBuilder getInsertStatement() {
        StringBuilder sb = new StringBuilder();
        sb.append("Insert Into M_Group(").append("M_GroupCode,M_GroupName,Creation_Date,FromModatDate,ToModatDate, Type_Anbar_C)");
        return sb;
    }

    private void appendSelectStatement(StringBuilder sb, MainGroupDto p) {
        sb.append(" ( ").append("'").append(p.getCode()).append("',").append("'").append(p.getName()).append("',").append("GetDate(),GetDate(),GetDate(),").append(p.getWarehousetype()).append(" ) ");
    }

    private void appendUpdateStatement(StringBuilder sb, MainGroupDto p) {
        sb.append(" Update M_Group Set  M_GroupName = '").append(p.getName()).append("'");
        if (p.getWarehousetype() != null) {
            sb.append(", Type_Anbar_C =").append(p.getWarehousetype());
        }
        sb.append(" Where M_GroupCode='").append(p.getCode()).append("'");
        if (p.getWarehousetype() != null) {
            sb.append(" \n UPDATE ARTICLE SET TYPE_ANBAR_C = ").append(p.getWarehousetype()).append(" WHERE SUBSTRING(A_CODE, 0, 3) = '").append(p.getCode()).append("'");
        }
    }

    public synchronized ResponseEntity<Map<String, Object>> postMainGroupList(String Msg, int InsType, boolean rebuildJson) {
        MainGroupDto[] mainGroupDtos;
        ArrayList success = new ArrayList();
        LoginDto mylogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(mylogin);
        try {
            if (rebuildJson) {
                JSONObject obj = new JSONObject(Msg);
                obj = ConvertStr.rebuildJsonObject((JSONObject)obj);
                JSONArray jsonArray = obj.getJSONArray("maingroupinfo");
                Msg = jsonArray.toString();
            } else {
                Msg = Msg.substring(17, Msg.length() - 1);
            }
            Gson gson = new Gson();
            mainGroupDtos = (MainGroupDto[])gson.fromJson(Msg, MainGroupDto[].class);
        }
        catch (Exception ex) {
            TncException e = new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
            return ConvertStr.getMapResponseEntity((String)"MainGroup", Collections.singletonList(e.makeErrorWithCause((Throwable)ex)), Collections.emptyList());
        }
        if (mylogin.getIsMyHoloo().booleanValue() && mainGroupDtos.length > 0 && !ConvertStr.isNullOrEmpty((String)mainGroupDtos[0].getM_groupcode())) {
            return this.PostMGroupListOnly(mylogin, mainGroupDtos, InsType);
        }
        return (ResponseEntity)this.dbConnection.getTransactionTemplate(mylogin).execute(status -> {
            StringBuilder sb = new StringBuilder();
            for (MainGroupDto myclass : mainGroupDtos) {
                try {
                    myclass.setInputid(myclass.getId());
                    IndustrialProductService industrialService = new IndustrialProductService(DbLogin.getInstance((DbConnection)this.dbConnection, (LoginDto)mylogin));
                    if (ConvertStr.isNullOrEmpty((String)myclass.getName())) {
                        throw new TncException(TncExceptionMessages.EMPTY_MAIN_GROUP_NAME);
                    }
                    industrialService.checkWarehouseTypeValidity(myclass.getWarehousetype());
                    if (this.isUpdate(InsType)) {
                        myclass.setCode(ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)myclass.getErpcode())));
                    }
                    String sqlStr = "Select Count(*) cnt from M_GROUP where  M_groupname = '" + myclass.getName() + "' and m_Groupcode<>'" + myclass.getCode() + "'";
                    SqlRowSet rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                    while (rowSet.next()) {
                        if (rowSet.getInt("cnt") <= 0) continue;
                        throw new TncException(TncExceptionMessages.DUPLICATE_MAIN_GROUP_NAME);
                    }
                    if (this.isUpdate(InsType)) {
                        sqlStr = "Select Count(*) cnt from m_Group Where m_Groupcode='" + myclass.getCode() + "'";
                        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                        while (rowSet.next()) {
                            if (rowSet.getInt("cnt") != 0) continue;
                            throw new TncException(TncExceptionMessages.INVALID_MAIN_GROUP_ERP_CODE);
                        }
                    } else {
                        sqlStr = "declare @code int exec RETURN_MAX_MGROUP @code output select @code code";
                        rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                        while (rowSet.next()) {
                            myclass.setCode(rowSet.getString("code"));
                        }
                        if (ConvertStr.maxCodeReached((String)myclass.getCode())) {
                            throw new TncException(TncExceptionMessages.MAIN_GROUP_CAPACITY_FILLED);
                        }
                        if (myclass.getCode().length() < 2) {
                            myclass.setCode(ConvertStr.produceCode((int)ConvertStr.parseNullSafeInt((String)myclass.getCode()), (int)2));
                        }
                    }
                    sb.delete(0, sb.length());
                    if (this.isUpdate(InsType)) {
                        this.appendUpdateStatement(sb, myclass);
                    } else {
                        sb = this.getInsertStatement();
                        sb.append("values ");
                        this.appendSelectStatement(sb, myclass);
                    }
                    jdbcTemplate.execute(sb.toString());
                    if (!this.isUpdate(InsType)) {
                        industrialService.insertMainGroupSarfasl(myclass);
                    } else {
                        industrialService.updateMGroupSarfasl(myclass, mylogin);
                    }
                    LinkedHashMap<String, String> model = new LinkedHashMap<String, String>();
                    if (!ConvertStr.isNullOrEmpty((String)myclass.getInputid())) {
                        model.put("Id", myclass.getInputid());
                    }
                    model.put("ErpCode", ConvertStr.encrypt((String)myclass.getCode()));
                    success.add(model);
                }
                catch (TncException e) {
                    if (!ConvertStr.isNullOrEmpty((String)myclass.getInputid())) {
                        e.putMoreInfo("Id", (Object)myclass.getInputid());
                    }
                    return ConvertStr.getMapResponseEntity((String)"MainGroup", Collections.singletonList(e.getErrorMap()), Collections.emptyList());
                }
                catch (Exception ex) {
                    TncException e = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
                    return ConvertStr.getMapResponseEntity((String)"MainGroup", Collections.singletonList(e.makeErrorWithCause((Throwable)ex)), Collections.emptyList());
                }
            }
            return ConvertStr.getMapResponseEntity((String)"MainGroup", Collections.emptyList(), (List)success);
        });
    }

    private boolean isUpdate(int InsType) {
        return InsType == 1;
    }

    private ResponseEntity<Map<String, Object>> PostMGroupListOnly(LoginDto mylogin, MainGroupDto[] mgroupDtos, int InsType) {
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        UnavailableACode unavailableCode = new UnavailableACode(mylogin);
        try {
            this.insertOrDeleteMGroup(mylogin, mgroupDtos, InsType, unavailableCode);
        }
        catch (Exception ex) {
            TncException exception = new TncException(TncExceptionMessages.DATA_INPUT_ERROR);
            failure.add(exception.makeErrorWithCause((Throwable)ex));
            return ConvertStr.getMapResponseEntity((String)"MainGroup", failure, success);
        }
        LinkedHashMap<String, Boolean> model = new LinkedHashMap<String, Boolean>();
        model.put("Success", true);
        model.putAll(unavailableCode.getResultMap());
        success.add(model);
        return ConvertStr.getMapResponseEntity((String)"MainGroup", failure, success);
    }

    void insertOrDeleteMGroup(LoginDto mylogin, MainGroupDto[] mgroupDtos, int insType, UnavailableACode unavailableCode) {
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)mylogin.getDatabaseName()).transactionDeadLockWrapper(() -> this.insertMGroup(mylogin, mgroupDtos, insType, unavailableCode), new String[]{"M_GROUP"});
        }
        catch (Exception ex) {
            this.deleteRepeatMGroup(mylogin, mgroupDtos);
            if (ConvertStr.exceptionContains((Exception)ex, (String)"duplicate key")) {
                this.insertOrDeleteMGroup(mylogin, mgroupDtos, insType, unavailableCode);
            }
            throw ex;
        }
    }

    private void insertMGroup(LoginDto mylogin, MainGroupDto[] myarrclass, int insertType, UnavailableACode unavailableCode) {
        TncJdbc tncJdbc = this.dbConnection.getJdbcTemplate(mylogin);
        MyHolooMessageMaker messageMaker = new MyHolooMessageMaker();
        String insert = this.getInsertStatement().append(" values ").toString();
        StringBuilder sb = new StringBuilder();
        if (!this.isUpdate(insertType)) {
            sb.append(insert);
        }
        int counter = 0;
        for (MainGroupDto mGroup : myarrclass) {
            if (this.isUpdate(insertType)) {
                if (counter >= 50) {
                    tncJdbc.execute(sb.toString());
                    sb.delete(0, sb.length());
                    counter = 0;
                }
                mGroup.setCode(mGroup.getM_groupcode());
                this.appendUpdateStatement(sb, mGroup);
            } else {
                counter = SideGroupDao.resetAndGetCounter((TncJdbc)tncJdbc, (StringBuilder)sb, (String)insert, (int)counter);
                mGroup.setCode(mGroup.getM_groupcode());
                this.appendSelectStatement(sb, mGroup);
                sb.append(" , ");
                messageMaker.addIfAbsent(mGroup.getM_groupcode(), mGroup.getIsupdate());
            }
            ++counter;
        }
        if (!this.isUpdate(insertType)) {
            sb.deleteCharAt(sb.lastIndexOf(","));
        }
        tncJdbc.execute(sb.toString());
        unavailableCode.set(CallApi.callApiGetNotify((LoginDto)mylogin, (String)"M_Group", (int)(this.isUpdate(insertType) ? 1 : 0), (String)messageMaker.makeCodes(), null, (String)messageMaker.makeMessage("\u06af\u0631\u0648\u0647 \u0627\u0635\u0644\u06cc", this.isUpdate(insertType)), (String)"insertMGroup", (DbConnection)this.dbConnection));
    }

    private void deleteRepeatMGroup(LoginDto mylogin, MainGroupDto[] mgroupDtos) {
        TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)mylogin.getDatabaseName()).transactionDeadLockWrapper(() -> {
            StringBuilder M_GroupCode = new StringBuilder();
            TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(mylogin);
            int i = 0;
            while (i < mgroupDtos.length) {
                M_GroupCode.delete(0, M_GroupCode.length());
                M_GroupCode.append("'").append(mgroupDtos[i].getM_groupcode()).append("'");
                ++i;
                for (int j = 0; j < 50 && i < mgroupDtos.length; ++j, ++i) {
                    M_GroupCode.append(",'").append(mgroupDtos[i].getM_groupcode()).append("'");
                }
                jdbcTemplate.execute("Delete M_Group Where M_GroupCode in (" + M_GroupCode + ")");
            }
        }, new String[]{"M_GROUP"});
    }

    private String GetFilter(HttpServletRequest request) {
        String sqlWhere = "";
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        if (info.containsKey("erpcode")) {
            sqlWhere = sqlWhere + " Isnull(M_groupcode,0) = '" + ConvertStr.decrypt((String)ConvertStr.getNullIfEmpty((String)((String)info.get("erpcode")))) + "'";
        }
        if (info.containsKey("maingroupcode")) {
            if (!"".equals(sqlWhere)) {
                sqlWhere = sqlWhere + " And ";
            }
            sqlWhere = sqlWhere + " ISNULL(M_GROUPCODE, 0) = '" + (String)info.get("maingroupcode") + "'";
        }
        if (!"".equals(sqlWhere)) {
            sqlWhere = " Where " + sqlWhere;
        }
        return sqlWhere;
    }
}

