/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TextNormalizer;
import com.utility.TncJdbc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.dao.DataAccessException;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.InvalidResultSetAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class ReportDao {
    private final DbConnection dbConnection;

    public ReportDao(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public ResponseEntity<?> getReportList(HttpServletRequest request) {
        LoginDto loginDto = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(loginDto);
        String urlInfo = request.getServletPath();
        String sqlStr = "";
        if (urlInfo.contains("GetSarfasl")) {
            sqlStr = "exec Sp_ReturnMandehSarfasl ";
        } else if (urlInfo.contains("GetCash")) {
            sqlStr = "exec Sp_ReturnMandehSarfaslType 3,";
        } else if (urlInfo.contains("GetAccound")) {
            sqlStr = "exec Sp_ReturnMandehSarfaslType 4,";
        } else if (urlInfo.contains("GetMaxBedCustomer") || urlInfo.contains("GetMaxBesCustomer")) {
            sqlStr = "exec Sp_ReturnMandehCustomer ";
        } else if (urlInfo.contains("GetMaxFewProduct") || urlInfo.contains("GetMinFewProduct")) {
            sqlStr = "exec Sp_ReturnMandehArticle ";
        } else if (urlInfo.contains("GetMaxSelFewProduct") || urlInfo.contains("GetMinSelFewProduct") || urlInfo.contains("GetMaxSelPriceProduct") || urlInfo.contains("GetMinSelPriceProduct")) {
            sqlStr = "exec Sp_ReturnSellArticle ";
        } else if (urlInfo.contains("GetKardexSarfasl")) {
            sqlStr = "exec Sp_ReturnReportSarfasl ";
        } else if (urlInfo.contains("GetCustPay")) {
            sqlStr = "exec Sp_ReturnCustPay ";
        }
        String sqlWhere = this.getFilter(request);
        sqlStr = sqlStr + sqlWhere;
        ArrayList rowSet = new ArrayList();
        SqlRowSet rs = urlInfo.contains("GetCustPay") ? this.getCustomerPay(sqlWhere, (JdbcTemplate)jdbcTemplate) : jdbcTemplate.queryForRowSet(sqlStr);
        while (rs.next()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (urlInfo.contains("GetKardexSarfasl")) {
                map.put("Code", rs.getString("Sanad_Code_C"));
                map.put("Date", rs.getString("Sanad_Date"));
                map.put("Bed", Float.valueOf(rs.getFloat("Bed")));
                map.put("Bes", Float.valueOf(rs.getFloat("Bes")));
                map.put("Comment", rs.getString("Comment_Line"));
            } else {
                if (!ConvertStr.isNullOrEmpty((String)rs.getString("Code"))) {
                    map.put("Code", rs.getString("Code"));
                }
                map.put("Name", rs.getString("Name"));
                try {
                    if (rs.findColumn("Few") > 0) {
                        map.put("Few", Float.valueOf(rs.getFloat("Few")));
                    }
                }
                catch (InvalidResultSetAccessException e) {
                    e.printStackTrace();
                }
                map.put("Price", rs.getString("Price"));
                try {
                    if (rs.findColumn("Date") > 0) {
                        map.put("Date", rs.getString("Date"));
                    }
                }
                catch (InvalidResultSetAccessException e) {
                    e.printStackTrace();
                }
                try {
                    if (rs.findColumn("Mandeh") > 0) {
                        map.put("Mandeh", Float.valueOf(rs.getFloat("Mandeh")));
                    }
                }
                catch (InvalidResultSetAccessException e) {
                    e.printStackTrace();
                }
            }
            rowSet.add(map);
        }
        return ConvertStr.getMapResponseEntity((String)"report", rowSet, (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    private String getFilter(HttpServletRequest request) {
        String sqlWhere = "";
        Map info = ConvertStr.rebuildQueryString((HttpServletRequest)request);
        String urlInfo = request.getServletPath();
        if (urlInfo.contains("GetMaxBedCustomer") || urlInfo.contains("GetMaxBesCustomer") || urlInfo.contains("GetMinFewProduct") || urlInfo.contains("GetMaxSelFewProduct") || urlInfo.contains("GetMaxFewProduct") || urlInfo.contains("GetMinSelFewProduct") || urlInfo.contains("GetMaxSelPriceProduct") || urlInfo.contains("GetMinSelPriceProduct")) {
            sqlWhere = info.containsKey("count") ? sqlWhere + (String)info.get("count") : sqlWhere + "0";
            if (urlInfo.contains("GetMaxBedCustomer") || urlInfo.contains("GetMaxFewProduct") || urlInfo.contains("GetMaxSelFewProduct") || urlInfo.contains("GetMaxSelPriceProduct")) {
                sqlWhere = sqlWhere + ",1";
            } else if (urlInfo.contains("GetMaxBesCustomer") || urlInfo.contains("GetMinFewProduct") || urlInfo.contains("GetMinSelFewProduct") || urlInfo.contains("GetMinSelPriceProduct")) {
                sqlWhere = sqlWhere + ",2";
            }
            if (urlInfo.contains("GetMaxSelFewProduct") || urlInfo.contains("GetMinSelFewProduct")) {
                sqlWhere = sqlWhere + ",1";
            } else if (urlInfo.contains("GetMaxSelPriceProduct") || urlInfo.contains("GetMinSelPriceProduct")) {
                sqlWhere = sqlWhere + ",2";
            }
        } else {
            if (urlInfo.contains("GetKardexSarfasl")) {
                sqlWhere = info.containsKey("count") ? sqlWhere + (String)info.get("count") : sqlWhere + "0";
            }
            if (urlInfo.contains("GetSarfasl") || urlInfo.contains("GetKardexSarfasl") || urlInfo.contains("GetCustPay") || urlInfo.contains("GetCustReceive")) {
                if (!"".equals(sqlWhere)) {
                    sqlWhere = sqlWhere + " , ";
                }
                sqlWhere = info.containsKey("code") ? sqlWhere + "'" + (String)info.get("code") + "'" : sqlWhere + "''";
            }
        }
        if (!(urlInfo.contains("GetMaxBedCustomer") || urlInfo.contains("GetMaxBesCustomer") || urlInfo.contains("GetMaxFewProduct") || urlInfo.contains("GetMinFewProduct") || urlInfo.contains("GetCustPay") || urlInfo.contains("GetCustReceive"))) {
            if (!"".equals(sqlWhere)) {
                sqlWhere = sqlWhere + " , ";
            }
            if (!"".equals(sqlWhere = info.containsKey("date.from") ? sqlWhere + (String)info.get("date.from") : sqlWhere + "''")) {
                sqlWhere = sqlWhere + " , ";
            }
            sqlWhere = info.containsKey("date.to") ? sqlWhere + (String)info.get("date.to") : sqlWhere + "''";
        }
        return sqlWhere;
    }

    private SqlRowSet getCustomerPay(String sarfaslCode, JdbcTemplate jdbcTemplate) {
        String sqlStr = " DECLARE @Tmp TABLE(Id Int Identity, CustPay Float, sanad_code int, Sanad_Date DateTime, C_Code nvarchar(5), sanad_type int) \n INSERT INTO @Tmp(sanad_code, Sanad_Date, sanad_type, c_code, CustPay) \n SELECT S.sanad_code, sanad_date, Sanad_Type, SF.Common C_Code, Bes FROM Snd_List Sl \n INNER JOIN Sanad S ON S.Sanad_Code=Sl.Sanad_Code \n INNER JOIN SarFasl SF ON SF.sarfasl_code = Sl.Col_Code + Sl.Moien_Code + Sl.Tafzili_Code \n WHERE Sf.type IN (5,15) AND Bes > 0 AND IsNull(Type_Line, '') <> 'F' \n AND Sl.Sanad_Code IN (SELECT Sanad_Code FROM Snd_List WHERE Sanad_Code = Sl.Sanad_Code AND Col_Code IN ('101', '102', '104')) \n AND (" + sarfaslCode + " = '' OR Sf.sarfasl_code=" + sarfaslCode + ") \n ORDER BY Sanad_Date, Convert(Nvarchar(10), Sanad_Time, 108) \n SELECT * INTO #tmp FROM ( \n SELECT * FROM @Tmp A WHERE Id in (SELECT MAX(Id) FROM @Tmp WHERE C_Code=A.C_Code))A \n";
        jdbcTemplate.execute(sqlStr);
        sqlStr = " DECLARE @Sanad_Code INT , @Takhfif FLOAT,@Sanad_Type INT \n DECLARE C1 CURSOR FOR SELECT Sanad_Code,Sanad_Type FROM #tmp \n OPEN C1 \n FETCH C1 INTO @Sanad_Code, @Sanad_Type \n WHILE (@@Fetch_Status=0) \n BEGIN \n  SET @Takhfif = 0 \n  IF (@Sanad_Type=4) \n   Set @Takhfif=(SELECT Bed FROM Snd_List Where Sanad_Code = @Sanad_Code and        Col_Code='601' And Col_Code+moien_code <> '6010008' And Type_line = 'Z') \n  ELSE IF (SELECT Takhfif FROM facture WHERE Sanad_Code = @Sanad_Code) > 0 \n   Set @Takhfif= (SELECT Takhfif FROM facture WHERE Sanad_Code = @Sanad_Code) \n IF @Takhfif<>0 \n   UPDATE #tmp SET CustPay=CustPay-@Takhfif WHERE Sanad_Code=@Sanad_Code \n FETCH C1 INTO @sanad_Code,@Sanad_Type \n END \n CLOSE C1 \n DEALLOCATE C1 \n";
        jdbcTemplate.execute(sqlStr);
        sqlStr = "SELECT T.C_Code code, C.C_Name Name, CustPay Price, convert(nvarchar(10), Sanad_date, 111) Date, Round(Isnull(Mandeh,0),0) Mandeh FROM #tmp t\n INNER JOIN Customer C On C.C_Code = T.C_Code  LEFT JOIN W0_Calc_BedBes_UseInView V on V.c_code = C.c_code";
        SqlRowSet rs = jdbcTemplate.queryForRowSet(sqlStr);
        ConvertStr.deleteTempTableIfExists((String)"#tmp", (JdbcTemplate)jdbcTemplate);
        return rs;
    }

    public ResponseEntity<?> getCustomerReceive(HttpServletRequest request) {
        LoginDto login = this.dbConnection.setToken();
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(login);
        String sarfaslCode = this.getFilter(request);
        String sql = " SELECT S.SANAD_CODE SanadCode, CONVERT(NVARCHAR(10), SANAD_DATE, 111) SanadDate, SANAD_TYPE, SF.COMMON C_CODE, BED FROM SND_LIST SL \n INNER JOIN SANAD S ON S.SANAD_CODE = SL.SANAD_CODE \n INNER JOIN SARFASL SF ON SF.SARFASL_CODE = SL.COL_CODE + SL.MOIEN_CODE + SL.TAFZILI_CODE\n WHERE SF.TYPE IN (5,15) AND BED > 0 AND ISNULL(TYPE_LINE, '') <> 'F'\n AND SL.SANAD_CODE IN (SELECT SANAD_CODE FROM SND_LIST WHERE SANAD_CODE = SL.SANAD_CODE AND COL_CODE IN ('101', '102', '104', '402'))\n AND (" + sarfaslCode + " = '' OR SF.SARFASL_CODE=" + sarfaslCode + ")  ORDER BY SANAD_DATE, CONVERT(NVARCHAR(10), SANAD_TIME, 108)";
        List bedList = jdbc.queryForList(sql);
        double discount = 0.0;
        ArrayList result = new ArrayList();
        HashMap<String, String> m = new HashMap<String, String>();
        Map customer = new HashMap();
        StringBuilder cCode = new StringBuilder();
        for (Map map : bedList) {
            SqlRowSet rs;
            m.clear();
            customer.clear();
            cCode.delete(0, cCode.length());
            int sanadCode = (Integer)map.get("SanadCode");
            if ((Short)map.get("SANAD_TYPE") == 4) {
                try {
                    rs = jdbc.queryForRowSet("SELECT ISNULL(BED, 0) BED FROM SND_LIST  WHERE SANAD_CODE= ?  AND COL_CODE = '601' AND COL_CODE + MOIEN_CODE <> '6010008'  AND TYPE_LINE = 'Z' AND ACTIONS = 0", new Object[]{sanadCode});
                    if (rs.next()) {
                        discount = rs.getDouble("BED");
                    }
                }
                catch (DataAccessException dataAccessException) {}
            } else {
                rs = jdbc.queryForRowSet("SELECT ISNULL(TAKHFIF,0) TAKHFIF  FROM FACTURE WHERE SANAD_CODE = ?", new Object[]{sanadCode});
                if (rs.next()) {
                    discount = rs.getDouble("TAKHFIF");
                }
            }
            if (discount != 0.0) {
                double bed = (Double)map.get("BED");
                map.put("BED", bed - discount);
            }
            cCode.append((String)map.get("C_CODE"));
            customer = jdbc.queryForMap("SELECT CT.C_NAME, ROUND(ISNULL(V.MANDEH,0),0) MANDEH FROM CUSTOMER CT  LEFT JOIN W0_CALC_BEDBES_USEINVIEW V ON V.C_CODE = CT.C_CODE WHERE CT.C_CODE = ?", new Object[]{cCode.toString()});
            m.put("code", cCode.toString());
            m.put("name", (String)customer.get("C_NAME"));
            m.put("price", (String)map.get("BED"));
            m.put("date", (String)map.get("SanadDate"));
            m.put("remain", (String)customer.get("MANDEH"));
            result.add(m);
        }
        return ConvertStr.getMapResponseEntity((String)"report", result, (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }
}

