/*
 * Decompiled with CFR 0.152.
 */
package com.dao.process;

import com.dao.process.ProcessDao;
import com.dto.InvoiceDto;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class InvoiceProcessDao
extends ProcessDao<InvoiceDto.InvoiceInfo> {
    public InvoiceProcessDao(DbConnection dbConnection, LoginDto login, String blob) {
        super(dbConnection, login, blob);
    }

    protected String generateComment(InvoiceDto.InvoiceInfo data, ProcessDao.ProcessKind processKind) {
        StringBuilder sb = new StringBuilder();
        String result = "";
        int sanadCodeC = this.getSanadCodeC(data.getSanadcode());
        if (processKind.equals((Object)ProcessDao.ProcessKind.ADD) || processKind.equals((Object)ProcessDao.ProcessKind.EDIT)) {
            AtomicReference<Double> sumPrice = new AtomicReference<Double>(0.0);
            data.getDetailinfo().forEach(e -> {
                Double cfr_ignored_0 = (Double)sumPrice.updateAndGet(v -> new Double(v + e.getPrice()));
            });
        }
        if (processKind.equals((Object)ProcessDao.ProcessKind.ADD)) {
            sb.append(this.getInvoiceTypeStr(data));
            if (data.getRegisterType() == 2) {
                result = sb.append(this.getCustomerName(data)).append(" \u0628\u0647 \u0634\u0645\u0627\u0631\u0647 \u0641\u0627\u06a9\u062a\u0648\u0631 ").append(data.getCode()).append(" \u0628\u0647 \u0645\u0628\u0644\u063a ").append(data.getSumprice()).append(" + \u0637\u06cc \u0633\u0646\u062f: ").append(sanadCodeC).append(" \u0634\u0645\u0627\u0631\u0647 \u062b\u0627\u0628\u062a \u0633\u0646\u062f ").append(data.getSanadcode()).toString();
            } else if (data.getRegisterType() == 1) {
                result = sb.append("\u0627\u0631\u0633\u0627\u0644\u06cc: ").append(this.getCustomerName(data)).append(" \u0628\u0647 \u06a9\u0627\u0644\u0627\u0647\u0627\u06cc: ").append(this.getPreInvoiceArticlesComment(data.getId())).toString();
            }
        } else if (processKind.equals((Object)ProcessDao.ProcessKind.EDIT)) {
            if (data.getRegisterType() == 2) {
                result = sb.append("\u0627\u0635\u0644\u0627\u062d \u0641\u0627\u06a9\u062a\u0648\u0631").append(data.getInvoiceType().getFarsiName()).append(" \u0628\u0647 \u0634\u0645\u0627\u0631\u0647 ").append(data.getCode()).append(" \u0628\u0647 \u0645\u0628\u0644\u063a : ").append(data.getSumprice()).append("\u0628\u0647 \u0646\u0627\u0645 ").append(data.getCustomername()).append(" \u0633\u0646\u062f \u0634\u0645\u0627\u0631\u0647 ").append(sanadCodeC).append(" \u0634\u0645\u0627\u0631\u0647 \u062b\u0627\u0628\u062a \u0633\u0646\u062f ").append(data.getSanadcode()).toString();
            } else if (data.getRegisterType() == 1) {
                result = sb.append("\u0627\u0631\u0633\u0627\u0644\u06cc: ").append(this.getCustomerName(data)).append(" \u0628\u0647 \u06a9\u0627\u0644\u0627\u0647\u0627\u06cc: ").append(this.getPreInvoiceArticlesComment(data.getId())).toString();
            }
        } else if (processKind.equals((Object)ProcessDao.ProcessKind.DELETE)) {
            if (data.getRegisterType() == 2) {
                result = sb.append("\u062d\u0630\u0641 \u0633\u0646\u062f \u0634\u0645\u0627\u0631\u0647: ").append(sanadCodeC).append(" \u0634\u0645\u0627\u0631\u0647 \u062b\u0627\u0628\u062a \u0633\u0646\u062f ").append(data.getSanadcode()).append(" \u0648 \u0628\u0647 \u0634\u0645\u0627\u0631\u0647 \u0641\u0627\u06a9\u062a\u0648\u0631 ").append(data.getCode()).append("\u0628\u0647 \u0646\u0627\u0645 ").append(data.getCustomername()).append(" \u0648 \u062a\u0627\u0631\u06cc\u062e : ").append(data.getDate()).append("\u0648 \u0645\u0628\u0644\u063a :").append(data.getSumprice()).toString();
            } else if (data.getRegisterType() == 1) {
                result = sb.append("\u0627\u0631\u0633\u0627\u0644\u06cc: ").append(this.getCustomerName(data)).append(" \u0628\u0647 \u06a9\u0627\u0644\u0627\u0647\u0627\u06cc: ").append(this.getPreInvoiceArticlesComment(data.getId())).toString();
            }
        }
        if (result.length() > 485) {
            result = result.substring(0, 485);
        }
        return result;
    }

    private String getPreInvoiceArticlesComment(String id) {
        StringBuilder sb = new StringBuilder();
        List map = this.getJdbcTemplate().queryForList(" SELECT F.FEW_ARTICLE FEW, A.A_NAME A_NAME, F.PRICE_BS PRICE FROM ABAILPRE F INNER JOIN ARTICLE A ON A.A_CODE = F.A_CODE WHERE FAC_CODE = ? AND FAC_TYPE = ?", new Object[]{id, "P"});
        for (Map dtlRow : map) {
            sb.append(dtlRow.get("A_NAME")).append(" \u0628\u0647 \u062a\u0639\u062f\u0627\u062f ").append(dtlRow.get("FEW")).append(" \u0648 \u0642\u06cc\u0645\u062a: ").append(dtlRow.get("PRICE")).append(" + ");
            if (sb.length() <= 390) continue;
            break;
        }
        sb = ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)sb, (String)" + ");
        return sb.toString();
    }

    private int getSanadCodeC(int sanadCode) {
        SqlRowSet rs = this.getJdbcTemplate().queryForRowSet(" SELECT SANAD_CODE_C [SCC] from SANAD  WHERE SANAD_CODE=?", new Object[]{sanadCode});
        if (rs.next()) {
            return rs.getInt("SCC");
        }
        return -1;
    }

    private String getInvoiceTypeStr(InvoiceDto.InvoiceInfo data) {
        switch (this.getNameProc(data)) {
            case "F": {
                return "\u0641\u0631\u0648\u0634 \u0628\u0647 ";
            }
            case "Y": {
                return "\u0628\u0631\u06af\u0634\u062a \u0627\u0632 \u0641\u0631\u0648\u0634 \u0627\u0632 ";
            }
            case "K": {
                return "\u062e\u0631\u06cc\u062f \u0627\u0632 ";
            }
            case "X": {
                return "\u0628\u0631\u06af\u0634\u062a \u0627\u0632 \u062e\u0631\u06cc\u062f \u0627\u0632 ";
            }
            case "P": {
                return "\u067e\u06cc\u0634 \u0641\u0627\u06a9\u062a\u0648\u0631 \u0628\u0631\u0627\u06cc ";
            }
        }
        return "";
    }

    private String getCustomerName(InvoiceDto.InvoiceInfo data) {
        StringBuilder query = new StringBuilder();
        query.append(" SELECT C_NAME FROM CUSTOMER WHERE ");
        if (data.getCustid() == null) {
            query.append("C_CODE = '").append(data.getCustomerid()).append("'");
        } else {
            query.append("C_CODE_C='").append(data.getCustid()).append("'");
        }
        SqlRowSet customer = this.getJdbcTemplate().queryForRowSet(query.toString());
        if (customer.next()) {
            return customer.getString("C_NAME");
        }
        return "";
    }

    protected String getNumber(InvoiceDto.InvoiceInfo data) {
        return data.getRegisterType() == 1 ? data.getId() : String.valueOf(data.getSanadcode());
    }

    protected String getNameProc(InvoiceDto.InvoiceInfo data) {
        if (data.getRegisterType() == 2) {
            return data.getType();
        }
        if (data.getRegisterType() == 1) {
            return "P";
        }
        if (data.getRegisterType() == 0) {
            return "O";
        }
        return "N";
    }

    protected String getCCode(InvoiceDto.InvoiceInfo data) {
        return data.getCustomerid();
    }
}

