/*
 * Decompiled with CFR 0.152.
 */
package com.dao.process;

import com.dao.process.ProcessDao;
import com.dto.InvoiceDto;
import com.dto.LoginDto;
import com.utility.DbConnection;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class ReceiveFromCustomerDao
extends ProcessDao<InvoiceDto.InvoiceInfo> {
    public ReceiveFromCustomerDao(DbConnection dbConnection, LoginDto login, String blob) {
        super(dbConnection, login, blob);
    }

    protected String generateComment(InvoiceDto.InvoiceInfo data, ProcessDao.ProcessKind processKind) {
        StringBuilder sb = new StringBuilder();
        String result = "";
        int sanadCodeC = this.getSanadCodeC(data.getSanadcode());
        if (data.getRegisterType() == 0) {
            result = sb.append(" \u062f\u0631\u06cc\u0627\u0641\u062a \u0627\u0632 \u0637\u0631\u0641 \u062d\u0633\u0627\u0628 ").append(data.getCustomername()).append(" + \u0637\u06cc \u0633\u0646\u062f: ").append(sanadCodeC).append(" \u0634\u0645\u0627\u0631\u0647 \u062b\u0627\u0628\u062a \u0633\u0646\u062f ").append(data.getSanadcode()).toString();
        }
        if (result.length() > 485) {
            result = result.substring(0, 485);
        }
        if (data.getRegisterType() == 2) {
            StringBuilder res = data.getType().equals("F") ? sb.append(" \u062f\u0631\u06cc\u0627\u0641\u062a \u0686\u06a9 \u0627\u0632 ").append(data.getCustomername()) : sb.append(" \u067e\u0631\u062f\u0627\u062e\u062a \u0686\u06a9 ");
            result = res.append(" \u0628\u0627\u0628\u062a \u0641\u0627\u06a9\u062a\u0648\u0631 ").append(data.getCode()).append(" \u0628\u0647 \u0645\u0628\u0644\u063a ").append(data.getSumprice()).append(" + \u0637\u06cc \u0633\u0646\u062f: ").append(sanadCodeC).append(" \u0634\u0645\u0627\u0631\u0647 \u062b\u0627\u0628\u062a \u0633\u0646\u062f ").append(data.getSanadcode()).toString();
        }
        return result;
    }

    private int getSanadCodeC(int sanadCode) {
        SqlRowSet rs = this.getJdbcTemplate().queryForRowSet(" SELECT SANAD_CODE_C [SCC] from SANAD  WHERE SANAD_CODE=?", new Object[]{sanadCode});
        if (rs.next()) {
            return rs.getInt("SCC");
        }
        return -1;
    }

    protected String getNumber(InvoiceDto.InvoiceInfo data) {
        return data.getRegisterType() == 1 ? data.getId() : String.valueOf(data.getSanadcode());
    }

    protected String getNameProc(InvoiceDto.InvoiceInfo data) {
        if (data.getRegisterType() == 0) {
            return "S";
        }
        return "C";
    }

    protected String getCCode(InvoiceDto.InvoiceInfo data) {
        return data.getCustomerid();
    }
}

