/*
 * Decompiled with CFR 0.152.
 */
package com.dao.use_case;

import com.dao.process.BuildArtProcessDao;
import com.dao.use_case.BuildProductUseCase;
import com.dto.product.ConsumerProduct;
import com.dto.product.ProductBuildDto;
import com.dto.product.Production;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DateUtils;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.sql.ResultSet;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0012J?\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0012J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\b\u0010 \u001a\u00020\u000eH\u0016J\b\u0010!\u001a\u00020\u000bH\u0016J\b\u0010\"\u001a\u00020\u000bH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/dao/use_case/BuildProductUseCase;", "", "dbConnection", "Lcom/utility/DbConnection;", "(Lcom/utility/DbConnection;)V", "addConsumers", "", "consumers", "", "Lcom/dto/product/ConsumerProduct;", "facCode", "", "facCodeC", "buildTime", "Ljava/time/LocalTime;", "addProduction", "production", "Lcom/dto/product/Production;", "tPriceBs", "", "calcType", "", "(Lcom/dto/product/Production;Ljava/lang/String;Ljava/lang/String;Ljava/time/LocalTime;DLjava/lang/Integer;)V", "checkBuildErrors", "productBuildDto", "Lcom/dto/product/ProductBuildDto;", "settingLoader", "Lcom/service/SettingLoader;", "checkExist", "Lorg/springframework/jdbc/support/rowset/SqlRowSet;", "aCode", "few", "getBuildTime", "getNextFacCode", "getNextFacCodeC", "invoke", "", "TNCHolooWebService"})
@SourceDebugExtension(value={"SMAP\nBuildProductUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildProductUseCase.kt\ncom/dao/use_case/BuildProductUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n1855#2,2:327\n1549#2:330\n1620#2,3:331\n1855#2,2:334\n1864#2,3:336\n1#3:329\n*S KotlinDebug\n*F\n+ 1 BuildProductUseCase.kt\ncom/dao/use_case/BuildProductUseCase\n*L\n24#1:327,2\n154#1:330\n154#1:331,3\n176#1:334,2\n198#1:336,3\n*E\n"})
public class BuildProductUseCase {
    @NotNull
    private final DbConnection dbConnection;

    @Autowired
    public BuildProductUseCase(@NotNull DbConnection dbConnection) {
        Intrinsics.checkNotNullParameter((Object)dbConnection, (String)"dbConnection");
        this.dbConnection = dbConnection;
    }

    public boolean invoke(@NotNull ProductBuildDto productBuildDto) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)productBuildDto, (String)"productBuildDto");
        double tPriceBs = 0.0;
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, this.dbConnection.setToken());
        this.checkBuildErrors(productBuildDto, settingLoader);
        List list = productBuildDto.getConsumers();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ConsumerProduct)element$iv;
                boolean bl = false;
                SqlRowSet consumerData = this.checkExist(settingLoader, it.getDecryptedACode(), it.getFew());
                if (settingLoader.isBuildWithBuyPrice()) {
                    it.setPrice(Double.valueOf(consumerData.getDouble("buyPrice")));
                } else if (settingLoader.isBuildWithEndBuyPrice()) {
                    it.setPrice(Double.valueOf(consumerData.getDouble("endBuyPrice")));
                } else if (settingLoader.isBuildWithInputPrice() && it.getPrice() == null) {
                    throw new TncException(TncExceptionMessages.UNSPECIFIED_PRICE);
                }
                String string = (String)consumerData.getObject("calcType");
                it.setCalcType(string != null ? Integer.valueOf(Integer.parseInt(string)) : null);
                Double d = it.getPrice();
                tPriceBs += (d != null ? d : 0.0) * it.getFew() * it.getCalculatedData(it.getCalcType());
            }
        }
        String facCode = this.getNextFacCode();
        String facCodeC = this.getNextFacCodeC();
        LocalTime buildTime = this.getBuildTime();
        List list2 = productBuildDto.getConsumers();
        if (list2 != null) {
            it = list2;
            boolean bl = false;
            this.addConsumers((List)it, facCode, facCodeC, buildTime);
        }
        String calcTypeStr = "select case when ToolArzType = '' then null else ToolArzType end calcType from ARTICLE where A_Code = '" + productBuildDto.getProduction().getDecryptedACode() + '\'';
        SqlRowSet sqlRowSet = this.dbConnection.getJdbcTemplate().queryForRowSet(calcTypeStr);
        Intrinsics.checkNotNullExpressionValue((Object)sqlRowSet, (String)"queryForRowSet(...)");
        SqlRowSet rowSet = sqlRowSet;
        Integer calcType = null;
        if (rowSet.next()) {
            String string = (String)rowSet.getObject("calcType");
            calcType = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        }
        this.addProduction(productBuildDto.getProduction(), facCode, facCodeC, buildTime, tPriceBs, calcType);
        StringBuilder stringBuilder = new StringBuilder().append("SELECT * FROM ARTICLE WHERE A_CODE IN (").append(productBuildDto.getProduction().getDecryptedACode()).append(", ");
        List list3 = productBuildDto.getConsumers();
        Intrinsics.checkNotNull((Object)list3);
        String sqlArticles2 = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list3, null, null, null, (int)0, null, (Function1)((Function1)invoke.sqlArticles.1.INSTANCE), (int)31, null)).append(')').toString();
        SqlRowSet rs = this.dbConnection.getJdbcTemplate().queryForRowSet(sqlArticles2);
        String productName = "";
        String consumersName = "";
        while (rs.next()) {
            String string;
            String string2 = rs.getString("A_Code");
            boolean bl = string2 != null ? string2.equals(productBuildDto.getProduction().getDecryptedACode()) : false;
            if (bl) {
                String string3 = rs.getString("A_Name");
                if (string3 == null) {
                    string3 = "";
                }
                productName = string3;
                continue;
            }
            StringBuilder stringBuilder2 = new StringBuilder().append(consumersName);
            if (((CharSequence)consumersName).length() == 0) {
                string = rs.getString("A_Name");
                if (string == null) {
                    string = "";
                }
            } else {
                string = ", " + rs.getString("A_Name");
            }
            consumersName = stringBuilder2.append(string).toString();
        }
        String processComment = " \u062a\u0648\u0644\u064a\u062f \u0643\u0627\u0644\u0627\u064a " + productName + " \u0628\u0647 \u062a\u0639\u062f\u0627\u062f: " + productBuildDto.getProduction().getFew() + " \u0627\u0632 \u0643\u0627\u0644\u0627\u0647\u0627\u064a: " + consumersName + " \u0628\u0627 \u0634\u0645\u0627\u0631\u0647 \u062a\u0648\u0644\u064a\u062f :" + facCodeC;
        new BuildArtProcessDao(this.dbConnection, this.dbConnection.setToken(), productBuildDto.toString()).insertBuildProcess(facCode, "", processComment);
        return true;
    }

    @NotNull
    public SqlRowSet checkExist(@NotNull SettingLoader settingLoader, @NotNull String aCode, double few) {
        Intrinsics.checkNotNullParameter((Object)settingLoader, (String)"settingLoader");
        Intrinsics.checkNotNullParameter((Object)aCode, (String)"aCode");
        double exist = 0.0;
        String materialQuery = "SELECT A_Name, isNull(Buy_Price, 0) buyPrice, IsNull(EndBuy_Price, 0) endBuyPrice, isNull(karton, 0) karton, isNull(exist, 0) exist, case when ToolArzType = '' then null else ToolArzType end calcType FROM ARTICLE WHERE A_Code = '" + aCode + '\'';
        SqlRowSet sqlRowSet = this.dbConnection.getJdbcTemplate().queryForRowSet(materialQuery);
        Intrinsics.checkNotNullExpressionValue((Object)sqlRowSet, (String)"queryForRowSet(...)");
        SqlRowSet materialRowSet = sqlRowSet;
        if (materialRowSet.next()) {
            exist = materialRowSet.getDouble("exist");
        }
        if (few > exist && !settingLoader.negativeInvoiceEnabled() && !settingLoader.isNegativeMAvaliehEnable()) {
            throw new TncException(TncExceptionMessages.BELOW_PRODUCTS_HAVE_NO_STORE);
        }
        return materialRowSet;
    }

    @NotNull
    public LocalTime getBuildTime() {
        LocalTime localTime;
        DateTimeFormatter formatterWithoutSeconds = DateTimeFormatter.ofPattern("HH:mm");
        DateTimeFormatter formatterWithSeconds = DateTimeFormatter.ofPattern("HH:mm:ss");
        try {
            localTime = LocalTime.parse(DateUtils.getNowTimeStr(), formatterWithSeconds);
        }
        catch (Exception e) {
            localTime = LocalTime.parse(DateUtils.getNowTimeStr(), formatterWithoutSeconds);
        }
        LocalTime time = localTime;
        LocalTime localTime2 = time.minusNanos(3000000L);
        Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"minusNanos(...)");
        return localTime2;
    }

    @NotNull
    public String getNextFacCode() {
        Ref.ObjectRef facCode;
        block0: {
            String sqlStr = "Select dbo.produccode(Isnull(Max(Fac_Code), 0) + 1) Fac_Code From FAC_BILD";
            facCode = new Ref.ObjectRef();
            facCode.element = "";
            TncJdbc tncJdbc = this.dbConnection.getJdbcTemplate();
            if (tncJdbc == null) break block0;
            tncJdbc.query(sqlStr, arg_0 -> BuildProductUseCase.getNextFacCode$lambda$2(facCode, arg_0));
        }
        return (String)facCode.element;
    }

    @NotNull
    public String getNextFacCodeC() {
        String facCodeCQuery = "select isNull(MAX(Fac_Code_C), 0) fac_code_c from FAC_BILD";
        SqlRowSet sqlRowSet = this.dbConnection.getJdbcTemplate().queryForRowSet(facCodeCQuery);
        Intrinsics.checkNotNullExpressionValue((Object)sqlRowSet, (String)"queryForRowSet(...)");
        SqlRowSet facCodeCRowSet = sqlRowSet;
        String facCodeC = ConvertStr.produceCode((int)1, (int)6);
        while (facCodeCRowSet.next()) {
            int code = facCodeCRowSet.getInt("fac_code_c") + 1;
            facCodeC = ConvertStr.produceCode((int)code, (int)6);
        }
        String string = facCodeC;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private void checkBuildErrors(ProductBuildDto productBuildDto, SettingLoader settingLoader) {
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate();
        Collection collection = productBuildDto.getConsumers();
        if ((collection == null || collection.isEmpty()) && !settingLoader.isBuildWithNoArtEnable()) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        String sqlStr = null;
        Ref.IntRef count = new Ref.IntRef();
        Collection collection2 = productBuildDto.getConsumers();
        if (!(collection2 == null || collection2.isEmpty())) {
            void $this$mapTo$iv$iv;
            List list = productBuildDto.getConsumers();
            Intrinsics.checkNotNull((Object)list);
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ConsumerProduct consumerProduct = (ConsumerProduct)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(it.getDecryptedACode());
            }
            String aCodes = ConvertStr.commaBindStringsWithQuotes((Collection)((List)destination$iv$iv));
            sqlStr = "SELECT Count(*) cnt FROM Article Where A_Code in (" + aCodes + ')';
            TncJdbc tncJdbc = jdbcTemplate;
            if (tncJdbc != null) {
                tncJdbc.query(sqlStr, arg_0 -> BuildProductUseCase.checkBuildErrors$lambda$4(count, arg_0));
            }
            if (count.element != productBuildDto.getConsumers().size()) {
                throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
            }
        }
        sqlStr = "SELECT Count(*) cnt FROM Article Where A_Code = '" + productBuildDto.getProduction().getDecryptedACode() + '\'';
        TncJdbc tncJdbc = jdbcTemplate;
        if (tncJdbc != null) {
            tncJdbc.query(sqlStr, arg_0 -> BuildProductUseCase.checkBuildErrors$lambda$5(count, arg_0));
        }
        if (count.element != 1) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        if (productBuildDto.getProduction().getFew() <= 0.0) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_AMOUNT);
        }
        List list = productBuildDto.getConsumers();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConsumerProduct consumer = (ConsumerProduct)element$iv;
                boolean bl = false;
                if (consumer.getFew() <= 0.0) {
                    throw new TncException(TncExceptionMessages.INVALID_PRODUCT_AMOUNT);
                }
                if (consumer.getHeight() <= 0.0) {
                    consumer.setHeight(1.0);
                }
                if (!(consumer.getWidth() <= 0.0)) continue;
                consumer.setWidth(1.0);
            }
        }
        if (productBuildDto.getProduction().getHeight() <= 0.0) {
            productBuildDto.getProduction().setHeight(1.0);
        }
        if (productBuildDto.getProduction().getWidth() <= 0.0) {
            productBuildDto.getProduction().setWidth(1.0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addConsumers(List<ConsumerProduct> consumers, String facCode, String facCodeC, LocalTime buildTime) {
        ArrayList<String> buildArtQueries = new ArrayList<String>();
        Iterable $this$forEachIndexed$iv = consumers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void consumer;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ConsumerProduct consumerProduct = (ConsumerProduct)item$iv;
            int index = n;
            boolean bl = false;
            String comment = consumer.getComment() != null ? '\'' + consumer.getComment() + "'," : "NULL, ";
            double few = consumer.getFew() * consumer.getCalculatedData(consumer.getCalcType());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("insert into FAC_BILD (Fac_Code, A_Code, A_Index, A_Type, Fac_Code_C, Fac_Date, Fac_Time, Few, Few2, Price_BS, Comment, Extra_Field, Bild_Or_Tajzieh, resid_NO, Type_Hazineh, FacArtic_Comment, Tool, Arz, ToolArzType,  Ghotr, Tedad, Metr, FormulaId, CalcFew) Values ('").append(facCode).append("','").append(consumer.getDecryptedACode()).append("',").append(index + 1).append(",'M','").append(facCodeC).append("',CAST(CAST(GETDATE() AS DATE) AS DATETIME),'").append(buildTime).append("',").append(few).append(',').append(consumer.getCarton()).append(',').append(consumer.getPrice()).append(",NULL,NULL,'F',0,0,").append(comment).append(consumer.getHeight()).append(',').append(consumer.getWidth()).append(',').append(consumer.getCalcType());
            stringBuilder.append(",1,1,1,0,0)");
            String sb = stringBuilder.toString();
            buildArtQueries.add(sb);
            String updateExistSql = "Update Article Set Exist = Exist - " + few + " ,Exist_Mandeh = Exist_Mandeh - " + few + " Where A_Code = '" + consumer.getDecryptedACode() + '\'';
            buildArtQueries.add(updateExistSql);
        }
        for (String query : buildArtQueries) {
            TncJdbc tncJdbc = this.dbConnection.getJdbcTemplate();
            if (tncJdbc == null) continue;
            tncJdbc.execute(query);
        }
    }

    public void addProduction(@NotNull Production production, @NotNull String facCode, @NotNull String facCodeC, @NotNull LocalTime buildTime, double tPriceBs, @Nullable Integer calcType) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)production, (String)"production");
            Intrinsics.checkNotNullParameter((Object)facCode, (String)"facCode");
            Intrinsics.checkNotNullParameter((Object)facCodeC, (String)"facCodeC");
            Intrinsics.checkNotNullParameter((Object)buildTime, (String)"buildTime");
            StringBuilder sb = new StringBuilder("insert into FAC_BILD (Fac_Code, A_Code, A_Index, A_Type, Fac_Code_C, Fac_Date, Fac_Time, Few, Few2, Price_BS, Price_Hazineh, Price_Hazineh1, Price_Hazineh2, Price_Hazineh3, Comment, Extra_Field, Bild_Or_Tajzieh, Sanad_Code, resid_NO, Type_Hazineh,  Tool, Arz, ToolArzType, Ghotr, Tedad, Metr, FormulaId,CalcFew) Values (");
            double price = tPriceBs;
            Double d = production.getCost1();
            Double d2 = production.getCost2();
            Double d3 = production.getCost3();
            double sumCost = (d != null ? d : 0.0) + (d2 != null ? d2 : 0.0) + (d3 != null ? d3 : 0.0);
            price += sumCost * production.getFew();
            String comment = production.getComment() != null ? '\'' + production.getComment() + "'," : "NULL, ";
            double few = production.getFew() * production.getCalculatedData(calcType);
            StringBuilder stringBuilder = sb.append("'").append(facCode).append("',").append("'").append(production.getDecryptedACode()).append("',").append(0).append(",").append("'").append("T").append("',").append("'").append(facCodeC).append("',").append("CAST(CAST(GETDATE() AS DATE) AS DATETIME)").append(",").append("" + '\'' + buildTime + '\'').append(",").append(few).append(",").append(production.getCarton()).append(",").append(price /= production.getFew() * production.getCalculatedData(calcType)).append(",").append("'").append(sumCost * production.getFew()).append("',").append("'");
            Double d4 = production.getCost1();
            Double d5 = production.getCost2();
            Double d6 = production.getCost3();
            stringBuilder.append((d4 != null ? d4 : 0.0) * production.getFew()).append("',").append("'").append((d5 != null ? d5 : 0.0) * production.getFew()).append("',").append("'").append((d6 != null ? d6 : 0.0) * production.getFew()).append("',").append(comment).append("NULL,").append("'").append("F").append("',").append(0).append(",").append(0).append(",").append(0).append(",").append(production.getHeight()).append(",").append(production.getWidth()).append(",").append(calcType).append(",").append(1).append(",").append(1).append(",").append(1).append(",").append("0,").append(0).append(")");
            System.out.println((Object)sb.toString());
            TncJdbc tncJdbc = this.dbConnection.getJdbcTemplate();
            if (tncJdbc != null) {
                tncJdbc.execute(sb.toString());
            }
            String updateExistSql = "Update Article Set Exist = Exist + " + few + " ,Exist_Mandeh = Exist_Mandeh + " + few + " Where A_Code = '" + production.getDecryptedACode() + '\'';
            TncJdbc tncJdbc2 = this.dbConnection.getJdbcTemplate();
            if (tncJdbc2 == null) break block1;
            tncJdbc2.execute(updateExistSql);
        }
    }

    private static final void getNextFacCode$lambda$2(Ref.ObjectRef $facCode, ResultSet it) {
        Intrinsics.checkNotNullParameter((Object)$facCode, (String)"$facCode");
        String string = it.getString("Fac_Code");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        $facCode.element = string;
    }

    private static final void checkBuildErrors$lambda$4(Ref.IntRef $count, ResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)$count, (String)"$count");
        $count.element = resultSet.getInt("cnt");
    }

    private static final void checkBuildErrors$lambda$5(Ref.IntRef $count, ResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)$count, (String)"$count");
        $count.element = resultSet.getInt("cnt");
    }
}

