/*
 * Decompiled with CFR 0.152.
 */
package com.dao.use_case;

import com.dto.transfer.ProductTransferDto;
import com.dto.transfer.TransferDtlDto;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DateUtils;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0012J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0012J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0012J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0012J(\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0015H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/dao/use_case/ProductTransferUseCase;", "", "dbConnection", "Lcom/utility/DbConnection;", "(Lcom/utility/DbConnection;)V", "addDetails", "", "productTransferDto", "Lcom/dto/transfer/ProductTransferDto;", "facCode", "", "addFacture", "facCodeC", "", "addProcess", "checkErrors", "settingLoader", "Lcom/service/SettingLoader;", "checkExist", "aCode", "few", "", "date", "getFacTime", "Ljava/time/LocalTime;", "getNextFacCode", "getNextFacCodeC", "invoke", "", "updateExist", "detail", "Lcom/dto/transfer/TransferDtlDto;", "buyPrice", "TNCHolooWebService"})
@SourceDebugExtension(value={"SMAP\nProductTransferUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductTransferUseCase.kt\ncom/dao/use_case/ProductTransferUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,264:1\n1855#2,2:265\n1864#2,3:267\n1549#2:271\n1620#2,3:272\n1549#2:275\n1620#2,3:276\n1855#2:279\n766#2:280\n857#2,2:281\n1477#2:283\n1502#2,3:284\n1505#2,3:294\n1856#2:301\n1#3:270\n372#4,7:287\n125#5:297\n152#5,3:298\n*S KotlinDebug\n*F\n+ 1 ProductTransferUseCase.kt\ncom/dao/use_case/ProductTransferUseCase\n*L\n40#1:265,2\n64#1:267,3\n214#1:271\n214#1:272,3\n215#1:275\n215#1:276,3\n238#1:279\n259#1:280\n259#1:281,2\n259#1:283\n259#1:284,3\n259#1:294,3\n238#1:301\n259#1:287,7\n260#1:297\n260#1:298,3\n*E\n"})
public class ProductTransferUseCase {
    @NotNull
    private final DbConnection dbConnection;

    @Autowired
    public ProductTransferUseCase(@NotNull DbConnection dbConnection) {
        Intrinsics.checkNotNullParameter((Object)dbConnection, (String)"dbConnection");
        this.dbConnection = dbConnection;
    }

    public boolean invoke(@NotNull ProductTransferDto productTransferDto) {
        Intrinsics.checkNotNullParameter((Object)productTransferDto, (String)"productTransferDto");
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, this.dbConnection.setToken());
        this.checkErrors(productTransferDto, settingLoader);
        String facCode = this.getNextFacCode();
        Integer n = productTransferDto.getFactureCode();
        int facCodeC = n != null ? n.intValue() : this.getNextFacCodeC();
        this.addFacture(productTransferDto, facCode, facCodeC);
        this.addDetails(productTransferDto, facCode);
        this.addProcess(productTransferDto, facCode, facCodeC);
        return true;
    }

    private void addProcess(ProductTransferDto productTransferDto, String facCode, int facCodeC) {
        block1: {
            String facDate = new SimpleDateFormat("yyyy/MM/dd").format(new Date());
            String time = new SimpleDateFormat("HH:mm").format(new Date());
            Ref.IntRef procId = new Ref.IntRef();
            procId.element = 1;
            this.dbConnection.getJdbcTemplate().query("SELECT ISNULL(MAX(ProcID), 0) + 1 as procId FROM Process", arg_0 -> ProductTransferUseCase.addProcess$lambda$0(procId, arg_0));
            List list = productTransferDto.getDetails();
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TransferDtlDto it = (TransferDtlDto)element$iv;
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("EXEC sp_SaveProcess;1 'A','H','").append(facCode).append("','','").append(facDate).append("','").append(time).append("', '\u062d\u0648\u0627\u0644\u0647 \u0628\u064a\u0646 \u0627\u0646\u0628\u0627\u0631\u0647\u0627 \u0643\u0627\u0644\u0627\u064a \u0645\u0628\u062f\u0627: ").append(it.getSName()).append(" \u0643\u0627\u0644\u0627\u064a \u0645\u0642\u0635\u062f: ").append(it.getDName()).append(" \u0628\u0647 \u0645\u0642\u062f\u0627\u0631: ").append(it.getFew()).append(" \u0648 \u062a\u0639\u062f\u0627\u062f: ").append(it.getCarton()).append(" \u0648 \u0634\u0645\u0627\u0631\u0647 \u062d\u0648\u0627\u0644\u0647: ").append(facCodeC).append(":::\u0627\u0646\u0628\u0627\u0631 \u0645\u0628\u062f\u0627 =").append(it.getSGroup()).append(" \u0648 \u0627\u0646\u0628\u0627\u0631 \u0645\u0642\u0635\u062f= ").append(it.getDGroup()).append("'\n,-1,").append(procId.element).append('\n');
                String sqlStr = stringBuilder.toString();
                this.dbConnection.getJdbcTemplate().execute(sqlStr);
            }
        }
    }

    private void updateExist(TransferDtlDto detail, double buyPrice) {
        String sqlStr = "Update Article Set Exist = Exist - " + detail.getFew() + ", Exist_Mandeh = Exist_Mandeh - " + detail.getFew() + ", Exist2 = Exist2 - " + detail.getCarton() + "  Where A_Code = '" + detail.getSourceId() + "' \n\n Update Article Set Exist = Exist + " + detail.getFew() + ", Exist_Mandeh = Exist_Mandeh + " + detail.getFew() + ", Exist2 = Exist2 + " + detail.getCarton() + ", Buy_Price = " + buyPrice + " Where A_Code = '" + detail.getDestinationId() + '\'';
        this.dbConnection.getJdbcTemplate().update(sqlStr);
    }

    /*
     * WARNING - void declaration
     */
    private void addDetails(ProductTransferDto productTransferDto, String facCode) {
        block2: {
            List list = productTransferDto.getDetails();
            if (list == null) break block2;
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void detail;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TransferDtlDto transferDtlDto = (TransferDtlDto)item$iv;
                int index = n;
                boolean bl = false;
                Ref.ObjectRef sACodeC = new Ref.ObjectRef();
                sACodeC.element = "";
                Ref.DoubleRef sFewInCarton = new Ref.DoubleRef();
                Ref.DoubleRef sFewInBox = new Ref.DoubleRef();
                Ref.DoubleRef dFewInCarton = new Ref.DoubleRef();
                Ref.DoubleRef dFewInBox = new Ref.DoubleRef();
                Ref.ObjectRef dACodeC = new Ref.ObjectRef();
                dACodeC.element = "";
                Ref.DoubleRef sBuyPrice = new Ref.DoubleRef();
                Ref.DoubleRef dExist = new Ref.DoubleRef();
                Ref.DoubleRef dBuyPrice = new Ref.DoubleRef();
                Ref.DoubleRef sEndBuyPrice = new Ref.DoubleRef();
                Ref.DoubleRef dEndBuyPrice = new Ref.DoubleRef();
                StringBuilder stringBuilder = new StringBuilder().append("SELECT A_Name, m.M_groupname groupName, A_Code_C, Exist, isNull(Buy_Price, 0) buyPrice, IsNull(EndBuy_Price, 0) endBuyPrice, isNull(karton, 0) karton , isNull(basteh, 0) basteh FROM ARTICLE \nLEFT JOIN M_GROUP m ON m.M_groupcode = '");
                String string = detail.getSourceId().substring(0, 2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String sqlStr = stringBuilder.append(string).append("' \nWHERE A_Code = '").append(detail.getSourceId()).append('\'').toString();
                this.dbConnection.getJdbcTemplate().query(sqlStr, arg_0 -> ProductTransferUseCase.addDetails$lambda$4$lambda$2(sBuyPrice, sEndBuyPrice, sACodeC, sFewInCarton, sFewInBox, (TransferDtlDto)detail, arg_0));
                StringBuilder stringBuilder2 = new StringBuilder().append("SELECT A_Name, m.M_groupname groupName, A_Code_C, Exist, isNull(Buy_Price, 0) buyPrice, IsNull(EndBuy_Price, 0) endBuyPrice, isNull(karton, 0) karton, isNull(basteh, 0) basteh FROM ARTICLE \nLEFT JOIN M_GROUP m ON m.M_groupcode = '");
                String string2 = detail.getDestinationId().substring(0, 2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                sqlStr = stringBuilder2.append(string2).append("' \nWHERE A_Code = '").append(detail.getDestinationId()).append('\'').toString();
                this.dbConnection.getJdbcTemplate().query(sqlStr, arg_0 -> ProductTransferUseCase.addDetails$lambda$4$lambda$3(dBuyPrice, dEndBuyPrice, dExist, dACodeC, dFewInCarton, dFewInBox, (TransferDtlDto)detail, arg_0));
                double price = dExist.element < 0.0 ? sBuyPrice.element : (dBuyPrice.element * dExist.element + sBuyPrice.element * detail.getFew()) / (dExist.element + detail.getFew());
                this.updateExist((TransferDtlDto)detail, price);
                StringBuilder stringBuilder3 = new StringBuilder();
                stringBuilder3.append("INSERT INTO FactArt (Fac_Code, Fac_Type, A_Code, A_Index, Few_Article, Few_Article2, Price_BS, FacArtic_Comment, Buy_Price, FewKarton, FewBasteh, ACode_C, EndBuy_Price, FewinBasteh, A_IndexK_FacCode, loadFromOldYaer) VALUES ('").append(facCode).append("', 'S', '").append(detail.getSourceId()).append("', ").append(index + 1).append(", ").append(detail.getFew()).append(", ").append(detail.getCarton()).append(", 1, '").append(detail.getComment()).append("', ").append(sBuyPrice.element).append(", ").append(sFewInCarton.element).append(", ").append(sFewInBox.element).append(", '").append((String)sACodeC.element).append("', ").append(sEndBuyPrice.element).append(", ");
                stringBuilder3.append(sFewInBox.element).append(", 0, 0)");
                String insert = stringBuilder3.toString();
                this.dbConnection.getJdbcTemplate().update(insert);
                StringBuilder stringBuilder4 = new StringBuilder();
                stringBuilder4.append("INSERT INTO FactArt (Fac_Code, Fac_Type, A_Code, A_Index, Few_Article, Few_Article2, Price_BS, FacArtic_Comment, Buy_Price, FewKarton, FewBasteh, ACode_C, EndBuy_Price, FewinBasteh, A_IndexK_FacCode, loadFromOldYaer) VALUES ('").append(facCode).append("', 'D', '").append(detail.getDestinationId()).append("', ").append(index + 1).append(", ").append(detail.getFew()).append(", ").append(detail.getCarton()).append(", 1, '").append(detail.getComment()).append("', ").append(sBuyPrice.element).append(", ").append(dFewInCarton.element).append(", ").append(dFewInBox.element).append(", '").append((String)dACodeC.element).append("', ").append(dEndBuyPrice.element).append(", ");
                stringBuilder4.append(dFewInBox.element).append(", 0, 0)");
                String insert2 = stringBuilder4.toString();
                this.dbConnection.getJdbcTemplate().update(insert2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addFacture(ProductTransferDto productTransferDto, String facCode, int facCodeC) {
        LocalTime facTime = this.getFacTime();
        List list = productTransferDto.getDetails();
        Intrinsics.checkNotNull((Object)list);
        Iterable iterable = list;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            TransferDtlDto transferDtlDto = (TransferDtlDto)t;
            double d2 = d;
            boolean bl = false;
            double d3 = it.getFew();
            d = d2 + d3;
        }
        double sumFew = d;
        String sql = "EXEC sp_HavFactureAppend @Fac_Code = '" + facCode + "', @Fac_Code_C = '" + facCodeC + "', \n @Fac_Date = '" + productTransferDto.getDate() + " 00:00:00.000', @Fac_Time = '1899-12-30 " + facTime + ".000', @C_Code = '00000', \n @Fac_Comment = '" + productTransferDto.getComment() + "', @Sanad_Code = 0, @Set_AutoFacCode_C = 0, @HazFactK = NULL, @UserCode = " + this.dbConnection.setToken().userCodeInc + ", @Sum_Few = " + sumFew + ", \n @Fac_Code_Out = null, @Fac_Code_C_Out = null, @FNUM = 0";
        this.dbConnection.getJdbcTemplate().execute(sql);
    }

    public void checkExist(@NotNull SettingLoader settingLoader, @NotNull String aCode, double few, @NotNull String date) {
        Intrinsics.checkNotNullParameter((Object)settingLoader, (String)"settingLoader");
        Intrinsics.checkNotNullParameter((Object)aCode, (String)"aCode");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        double exist = 0.0;
        String sqlStr = "declare @Exist float \n set @Exist=0 \n declare @Exist2 float \n set @Exist2=0 \n exec sp_ReturnArtExistWithKardex1;1 N'" + aCode + "','" + date + " 00:00:01','1899-12-30 00:00:01',@Exist output,@Exist2 output \n select @Exist as Exist ";
        SqlRowSet sqlRowSet = this.dbConnection.getJdbcTemplate().queryForRowSet(sqlStr);
        Intrinsics.checkNotNullExpressionValue((Object)sqlRowSet, (String)"queryForRowSet(...)");
        SqlRowSet rowSet = sqlRowSet;
        if (rowSet.next()) {
            exist = rowSet.getDouble("Exist");
        }
        double allSell = 0.0;
        sqlStr = "Select AllForoosh from ArticlesExistInResturant Where A_Code = '" + aCode + '\'';
        SqlRowSet sqlRowSet2 = this.dbConnection.getJdbcTemplate().queryForRowSet(sqlStr);
        Intrinsics.checkNotNullExpressionValue((Object)sqlRowSet2, (String)"queryForRowSet(...)");
        rowSet = sqlRowSet2;
        if (rowSet.next()) {
            allSell = rowSet.getDouble("AllForoosh");
        }
        if (few > exist - allSell && !settingLoader.negativeInvoiceEnabled()) {
            throw new TncException(TncExceptionMessages.BELOW_PRODUCTS_HAVE_NO_STORE);
        }
    }

    @NotNull
    public LocalTime getFacTime() {
        LocalTime localTime;
        DateTimeFormatter formatterWithoutSeconds = DateTimeFormatter.ofPattern("HH:mm");
        DateTimeFormatter formatterWithSeconds = DateTimeFormatter.ofPattern("HH:mm:ss");
        try {
            localTime = LocalTime.parse(DateUtils.getNowTimeStr(), formatterWithSeconds);
        }
        catch (Exception e) {
            localTime = LocalTime.parse(DateUtils.getNowTimeStr(), formatterWithoutSeconds);
        }
        LocalTime time = localTime;
        Intrinsics.checkNotNull((Object)time);
        return time;
    }

    @NotNull
    public String getNextFacCode() {
        Ref.ObjectRef facCode;
        block0: {
            String sqlStr = "Select dbo.produccode(Isnull(Max(Fac_Code), 0) + 1) Fac_Code From FACTURE";
            facCode = new Ref.ObjectRef();
            facCode.element = "";
            TncJdbc tncJdbc = this.dbConnection.getJdbcTemplate();
            if (tncJdbc == null) break block0;
            tncJdbc.query(sqlStr, arg_0 -> ProductTransferUseCase.getNextFacCode$lambda$6(facCode, arg_0));
        }
        return (String)facCode.element;
    }

    public int getNextFacCodeC() {
        Ref.IntRef facCodeC;
        block0: {
            String sqlStr = "Select dbo.produccode(Isnull(Max(Fac_Code_C), 0) + 1) Fac_Code_C From FACTURE";
            facCodeC = new Ref.IntRef();
            TncJdbc tncJdbc = this.dbConnection.getJdbcTemplate();
            if (tncJdbc == null) break block0;
            tncJdbc.query(sqlStr, arg_0 -> ProductTransferUseCase.getNextFacCodeC$lambda$7(facCodeC, arg_0));
        }
        return facCodeC.element;
    }

    /*
     * WARNING - void declaration
     */
    private void checkErrors(ProductTransferDto productTransferDto, SettingLoader settingLoader) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate();
        Collection collection2 = productTransferDto.getDetails();
        if (collection2 == null || collection2.isEmpty()) {
            throw new TncException(TncExceptionMessages.WRONG_JSON_STRUCT);
        }
        Iterable $this$map$iv = productTransferDto.getDetails();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            TransferDtlDto transferDtlDto = (TransferDtlDto)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSourceId());
        }
        List uniqueSourceIds = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = productTransferDto.getDetails();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Object[] destination$iv$iv2 = (Object[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TransferDtlDto bl = (TransferDtlDto)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getDestinationId());
        }
        List uniqueDestinationIds = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
        List uniqueList = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)uniqueSourceIds, (Iterable)uniqueDestinationIds));
        String sqlStr = null;
        sqlStr = "SELECT Count(*) cnt FROM Article Where A_Code in (" + ConvertStr.commaBindStringsWithQuotes((Collection)uniqueList) + ')';
        Ref.IntRef count = new Ref.IntRef();
        TncJdbc tncJdbc = jdbcTemplate;
        if (tncJdbc != null) {
            tncJdbc.query(sqlStr, arg_0 -> ProductTransferUseCase.checkErrors$lambda$10(count, arg_0));
        }
        if (count.element != uniqueList.size()) {
            throw new TncException(TncExceptionMessages.INVALID_PRODUCT_CODE);
        }
        if (productTransferDto.getFactureCode() != null) {
            sqlStr = "SELECT COUNT(*) cnt FROM FACTURE WHERE Fac_Code_C = '" + productTransferDto.getFactureCode() + "' AND Fac_Type in ('S', 'D')";
            count.element = 0;
            TncJdbc tncJdbc2 = jdbcTemplate;
            if (tncJdbc2 != null) {
                tncJdbc2.query(sqlStr, arg_0 -> ProductTransferUseCase.checkErrors$lambda$11(count, arg_0));
            }
            if (count.element != 0) {
                destination$iv$iv2 = new Object[]{productTransferDto.getFactureCode()};
                throw new TncException(TncExceptionMessages.DUPLICATE_INVOICE_CODE.setArgs(destination$iv$iv2));
            }
        }
        Iterable $this$forEach$iv = productTransferDto.getDetails();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            void $this$groupByTo$iv$iv;
            Object $this$groupBy$iv;
            TransferDtlDto it;
            void $this$filterTo$iv$iv;
            Object[] objectArray;
            TransferDtlDto dtl = (TransferDtlDto)element$iv;
            boolean bl = false;
            if (dtl.getFew() <= 0.0) {
                objectArray = new Object[]{dtl.getSourceId()};
                throw new TncException(TncExceptionMessages.INVALID_PRODUCT_AMOUNT.setArgs(objectArray));
            }
            String string = dtl.getSourceId().substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = dtl.getDestinationId().substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            if (Intrinsics.areEqual((Object)string, (Object)string2) && !settingLoader.transferArticleInSameGroup()) {
                objectArray = new Object[]{dtl.getSourceErpCode(), dtl.getDestinationErpCode()};
                throw new TncException(TncExceptionMessages.FORBIDDEN_TRANSFER_SAME_GROUP.setArgs(objectArray));
            }
            if (settingLoader.transferArticlesWithSameCodes()) {
                sqlStr = "SELECT CASE\n WHEN (SELECT a_Code_c FROM Article WHERE A_Code = '" + dtl.getSourceId() + "') = (SELECT a_Code_c FROM Article WHERE A_Code = '" + dtl.getDestinationId() + "')\n THEN 'Y'\n ELSE 'N'\n END AS IsEqual";
                jdbcTemplate.query(sqlStr, arg_0 -> ProductTransferUseCase.checkErrors$lambda$17$lambda$12(dtl, arg_0));
            }
            Iterable $this$filter$iv = productTransferDto.getDetails();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Object destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TransferDtlDto)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getSourceId(), (Object)dtl.getSourceId())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv3 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                it = (TransferDtlDto)element$iv$iv;
                boolean bl4 = false;
                String key$iv$iv = it.getSourceId();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv3;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv3;
            boolean $i$f$map3 = false;
            $this$groupByTo$iv$iv = $this$map$iv3;
            destination$iv$iv3 = new ArrayList($this$map$iv3.size());
            boolean $i$f$mapTo3 = false;
            Iterator<Object> iterator = $this$mapTo$iv$iv3.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
                Object object = destination$iv$iv3;
                boolean bl6 = false;
                List items = (List)entry.getValue();
                Iterable iterable3 = items;
                double d = 0.0;
                for (Object t : iterable3) {
                    void it2;
                    TransferDtlDto transferDtlDto = (TransferDtlDto)t;
                    double d2 = d;
                    boolean bl7 = false;
                    double d3 = it2.getFew();
                    d = d2 + d3;
                }
                object.add(d);
            }
            List sumFew = (List)destination$iv$iv3;
            this.checkExist(settingLoader, dtl.getSourceId(), ((Number)sumFew.get(0)).doubleValue(), productTransferDto.getDate());
        }
    }

    private static final void addProcess$lambda$0(Ref.IntRef $procId, ResultSet it) {
        Intrinsics.checkNotNullParameter((Object)$procId, (String)"$procId");
        $procId.element = it.getInt("procId");
    }

    private static final void addDetails$lambda$4$lambda$2(Ref.DoubleRef $sBuyPrice, Ref.DoubleRef $sEndBuyPrice, Ref.ObjectRef $sACodeC, Ref.DoubleRef $sFewInCarton, Ref.DoubleRef $sFewInBox, TransferDtlDto $detail, ResultSet it) {
        Intrinsics.checkNotNullParameter((Object)$sBuyPrice, (String)"$sBuyPrice");
        Intrinsics.checkNotNullParameter((Object)$sEndBuyPrice, (String)"$sEndBuyPrice");
        Intrinsics.checkNotNullParameter((Object)$sACodeC, (String)"$sACodeC");
        Intrinsics.checkNotNullParameter((Object)$sFewInCarton, (String)"$sFewInCarton");
        Intrinsics.checkNotNullParameter((Object)$sFewInBox, (String)"$sFewInBox");
        Intrinsics.checkNotNullParameter((Object)$detail, (String)"$detail");
        $sBuyPrice.element = it.getDouble("buyPrice");
        $sEndBuyPrice.element = it.getDouble("endBuyPrice");
        String string = it.getString("A_Code_C");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        $sACodeC.element = string;
        $sFewInCarton.element = it.getDouble("karton");
        $sFewInBox.element = it.getDouble("basteh");
        $detail.setSName(it.getString("A_Name"));
        $detail.setSGroup(it.getString("groupName"));
    }

    private static final void addDetails$lambda$4$lambda$3(Ref.DoubleRef $dBuyPrice, Ref.DoubleRef $dEndBuyPrice, Ref.DoubleRef $dExist, Ref.ObjectRef $dACodeC, Ref.DoubleRef $dFewInCarton, Ref.DoubleRef $dFewInBox, TransferDtlDto $detail, ResultSet it) {
        Intrinsics.checkNotNullParameter((Object)$dBuyPrice, (String)"$dBuyPrice");
        Intrinsics.checkNotNullParameter((Object)$dEndBuyPrice, (String)"$dEndBuyPrice");
        Intrinsics.checkNotNullParameter((Object)$dExist, (String)"$dExist");
        Intrinsics.checkNotNullParameter((Object)$dACodeC, (String)"$dACodeC");
        Intrinsics.checkNotNullParameter((Object)$dFewInCarton, (String)"$dFewInCarton");
        Intrinsics.checkNotNullParameter((Object)$dFewInBox, (String)"$dFewInBox");
        Intrinsics.checkNotNullParameter((Object)$detail, (String)"$detail");
        $dBuyPrice.element = it.getDouble("buyPrice");
        $dEndBuyPrice.element = it.getDouble("endBuyPrice");
        $dExist.element = it.getDouble("Exist");
        String string = it.getString("A_Code_C");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        $dACodeC.element = string;
        $dFewInCarton.element = it.getDouble("karton");
        $dFewInBox.element = it.getDouble("basteh");
        $detail.setDName(it.getString("A_Name"));
        $detail.setDGroup(it.getString("groupName"));
    }

    private static final void getNextFacCode$lambda$6(Ref.ObjectRef $facCode, ResultSet it) {
        Intrinsics.checkNotNullParameter((Object)$facCode, (String)"$facCode");
        String string = it.getString("Fac_Code");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        $facCode.element = string;
    }

    private static final void getNextFacCodeC$lambda$7(Ref.IntRef $facCodeC, ResultSet it) {
        Intrinsics.checkNotNullParameter((Object)$facCodeC, (String)"$facCodeC");
        $facCodeC.element = it.getInt("Fac_Code_C");
    }

    private static final void checkErrors$lambda$10(Ref.IntRef $count, ResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)$count, (String)"$count");
        $count.element = resultSet.getInt("cnt");
    }

    private static final void checkErrors$lambda$11(Ref.IntRef $count, ResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)$count, (String)"$count");
        $count.element = resultSet.getInt("cnt");
    }

    private static final void checkErrors$lambda$17$lambda$12(TransferDtlDto $dtl, ResultSet result) {
        Intrinsics.checkNotNullParameter((Object)$dtl, (String)"$dtl");
        if (Intrinsics.areEqual((Object)result.getString("IsEqual"), (Object)"N")) {
            Object[] objectArray = new Object[]{$dtl.getSourceErpCode(), $dtl.getDestinationErpCode()};
            throw new TncException(TncExceptionMessages.ARTICLE_CODES_ARE_NOT_EQUAL.setArgs(objectArray));
        }
    }
}

