/*
 * Decompiled with CFR 0.152.
 */
package com.dao.util;

import com.dao.util.BulkInsertHelper;
import com.dto.SettingDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import java.util.List;
import java.util.stream.Collectors;

public class SettingBulkInsert
extends BulkInsertHelper<SettingDto> {
    public SettingBulkInsert(DbConnection dbConnection) {
        super(dbConnection);
    }

    protected boolean getIdentityInsertOn() {
        return false;
    }

    protected List<String> getAllIds(List<SettingDto> dtoList) {
        return dtoList.stream().map(dto -> String.valueOf(dto.getName())).collect(Collectors.toList());
    }

    protected String getIdFieldName() {
        return "[NAME]";
    }

    protected String appendInsertValues(SettingDto dto) {
        return "'" + dto.getName() + "'," + ConvertStr.getBoolToInt((Boolean)dto.getFboolean()) + "," + dto.getFinteger() + "," + dto.getFdouble() + ",'" + dto.getFstring() + "','" + dto.getFtext() + "'";
    }

    protected String getTableName() {
        return "MSETUP2";
    }

    protected String[] getColumnsToInsertInto() {
        return new String[]{"[Name]", "[Boolean]", "[Integer]", "[Double]", "[String]", "[Text]"};
    }
}

