/*
 * Decompiled with CFR 0.152.
 */
package com.dao.util;

import com.utility.ConvertStr;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.JdbcTemplate;

public class StringListInquiry {
    private final JdbcTemplate jdbcTemplate;

    public StringListInquiry(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public <T> List<T> findInclusiveFromTable(Collection<T> objectsToSearch, String tableToSearchFrom, String queryFields, String whereStr, Function<? super T, String> mapper) {
        return this.find(true, objectsToSearch, tableToSearchFrom, queryFields, whereStr, mapper);
    }

    public <T> List<T> findExclusiveFromTable(Collection<T> objectsToSearch, String tableToSearchFrom, String queryFields, String whereStr, Function<? super T, String> mapper) {
        return this.find(false, objectsToSearch, tableToSearchFrom, queryFields, whereStr, mapper);
    }

    private <T> List<T> find(boolean inclusive, Collection<T> objectsToSearch, String tableToSearchFrom, String queryFields, String whereStr, Function<? super T, String> mapper) {
        HashSet<String> res = new HashSet<String>();
        for (T toSearch : objectsToSearch) {
            res.add(mapper.apply(toSearch));
        }
        String valuesStr = ConvertStr.bindStringsWrapByCharacter(res, (String)"('", (String)"')");
        List resultMapList = this.jdbcTemplate.queryForList(" SELECT DISTINCT * FROM (VALUES " + valuesStr + ") AS SEARCHLIST(M_SEARCH_VALUE) WHERE SEARCHLIST.M_SEARCH_VALUE " + (inclusive ? "IN" : "NOT IN") + " (SELECT " + queryFields + " FROM " + tableToSearchFrom + whereStr + ")");
        Set foundFields = resultMapList.stream().map(map -> map.getOrDefault("M_SEARCH_VALUE", "")).collect(Collectors.toSet());
        return objectsToSearch.stream().filter(dto -> foundFields.contains(mapper.apply(dto))).distinct().collect(Collectors.toList());
    }
}

