/*
 * Decompiled with CFR 0.152.
 */
package com.dao.util.calculatur;

import com.dao.util.calculatur.ArticleCalcData;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J'\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/dao/util/calculatur/InvoiceUtils;", "", "()V", "getVertexDate", "Ljava/util/Date;", "invoiceDate", "dtlList", "", "Lcom/dao/util/calculatur/ArticleCalcData;", "getXDaysLaterSinceDate", "x", "", "date", "roundToWholeNumber", "", "amount", "", "roundXDecimalPoints", "", "value", "roundUp", "", "numOfDecimals", "(DLjava/lang/Boolean;I)Ljava/lang/String;", "TNCHolooWebService"})
public final class InvoiceUtils {
    @NotNull
    public static final InvoiceUtils INSTANCE = new InvoiceUtils();

    private InvoiceUtils() {
    }

    @JvmStatic
    @NotNull
    public static final Date getVertexDate(@NotNull Date invoiceDate, @NotNull List<ArticleCalcData> dtlList) {
        Intrinsics.checkNotNullParameter((Object)invoiceDate, (String)"invoiceDate");
        Intrinsics.checkNotNullParameter(dtlList, (String)"dtlList");
        double vertexOfDues = 0.0;
        double sumOfPrices = 0.0;
        for (ArticleCalcData dtl : dtlList) {
            Double d = dtl.getModdat();
            double due = d != null ? d : 0.0;
            double fullPrice = dtl.getAmount() * dtl.getPrice();
            sumOfPrices += fullPrice;
            vertexOfDues += fullPrice * due;
        }
        return InvoiceUtils.getXDaysLaterSinceDate((int)((int)InvoiceUtils.roundToWholeNumber((double)(vertexOfDues /= sumOfPrices))), (Date)invoiceDate);
    }

    @JvmStatic
    @NotNull
    public static final Date getXDaysLaterSinceDate(int x, @NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, x);
        Date date2 = c.getTime();
        Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"getTime(...)");
        return date2;
    }

    @JvmStatic
    public static final long roundToWholeNumber(double amount) {
        return (long)Double.parseDouble(InvoiceUtils.roundXDecimalPoints((double)amount, null, (int)0));
    }

    @JvmStatic
    @NotNull
    public static final String roundXDecimalPoints(double value, @Nullable Boolean roundUp, int numOfDecimals) {
        StringBuilder sb = new StringBuilder("#.");
        for (int i = 0; i < numOfDecimals; ++i) {
            sb.append("#");
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.ENGLISH);
        DecimalFormat df = new DecimalFormat(sb.toString(), symbols);
        if (roundUp == null) {
            df.setRoundingMode(RoundingMode.HALF_UP);
            String string = df.format(value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }
        df.setRoundingMode(roundUp != false ? RoundingMode.UP : RoundingMode.DOWN);
        String string = df.format(value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }
}

