/*
 * Decompiled with CFR 0.152.
 */
package com.dto;

import com.dto.CheckDto;
import com.dto.PaymentDetailDto;
import com.dto.PaymentDetailSndIndxDto;
import com.dto.PaymentDto;
import com.utility.ConvertStr;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.lang.Nullable;

public class PaymentDto {
    private String id;
    private String date;
    private String time;
    private Double cash;
    private String cashsarfasl;
    private String vaultcashsarfasl;
    private List<CheckDto> checks;
    private Double bank;
    private String banksarfasl;
    private List<BankPaymentData> partialbankpayments;
    private Double discount;
    private String customersarfasl;
    private int sanadtype;
    private String comment;
    private Integer action;
    private List<PaymentDetailDto> detail;
    private List<PaymentDetailSndIndxDto> detailsndindx;
    private String inputid;
    private int fixsanadcode;
    private int sanadcode;
    private int sanadcode2;
    private String customerCode;
    private String customerName;
    private String bankHeadingName;
    private int sanadCodeC;
    private int sanadCodeC2;
    private Boolean endsave;
    private Boolean savefromfacture;
    private Boolean savefromauto;
    private int usercodeinc;
    private int sanadstate;
    private boolean isReceive;

    public boolean isReceive() {
        return this.sanadtype == 4;
    }

    public boolean checksNotAllowed() {
        return this.sanadtype != 4 && this.sanadtype != 5;
    }

    @Nullable
    public CheckDto thereIsDuplicateCheckNumber() {
        if (this.checks == null || this.checks.isEmpty()) {
            return null;
        }
        HashSet<CheckDto> uniques = new HashSet<CheckDto>();
        for (CheckDto check : this.checks) {
            if (uniques.add(check)) continue;
            return check;
        }
        return null;
    }

    public String getDocCode() {
        if (this.getSanadCodeC2() > 0) {
            return this.getSanadCodeC() + "/" + this.getSanadCodeC2();
        }
        return String.valueOf(this.getSanadCodeC());
    }

    private double calcExtraPosPayments() {
        return ConvertStr.sum((List)this.partialbankpayments, BankPaymentData::getBank);
    }

    public double calcBankAmounts() {
        if (this.hasPartialPayments()) {
            return this.calcExtraPosPayments();
        }
        return this.bank;
    }

    public void addBankToPosPayments() {
        if (ConvertStr.isNullOrZero((Double)this.bank)) {
            return;
        }
        this.partialbankpayments.add(new BankPaymentData(this.bank.doubleValue(), this.banksarfasl));
    }

    public String fetchBankTafsili() {
        return this.banksarfasl.length() > 7 ? this.banksarfasl.substring(7) : "";
    }

    public boolean hasPartialPayments() {
        return !ConvertStr.isNullOrEmpty((Collection)this.partialbankpayments);
    }

    PaymentDto(String id, String date, String time, Double cash, String cashsarfasl, String vaultcashsarfasl, List<CheckDto> checks, Double bank, String banksarfasl, List<BankPaymentData> partialbankpayments, Double discount, String customersarfasl, int sanadtype, String comment, Integer action, List<PaymentDetailDto> detail, List<PaymentDetailSndIndxDto> detailsndindx, String inputid, int fixsanadcode, int sanadcode, int sanadcode2, String customerCode, String customerName, String bankHeadingName, int sanadCodeC, int sanadCodeC2, Boolean endsave, Boolean savefromfacture, Boolean savefromauto, int usercodeinc, int sanadstate, boolean isReceive) {
        this.id = id;
        this.date = date;
        this.time = time;
        this.cash = cash;
        this.cashsarfasl = cashsarfasl;
        this.vaultcashsarfasl = vaultcashsarfasl;
        this.checks = checks;
        this.bank = bank;
        this.banksarfasl = banksarfasl;
        this.partialbankpayments = partialbankpayments;
        this.discount = discount;
        this.customersarfasl = customersarfasl;
        this.sanadtype = sanadtype;
        this.comment = comment;
        this.action = action;
        this.detail = detail;
        this.detailsndindx = detailsndindx;
        this.inputid = inputid;
        this.fixsanadcode = fixsanadcode;
        this.sanadcode = sanadcode;
        this.sanadcode2 = sanadcode2;
        this.customerCode = customerCode;
        this.customerName = customerName;
        this.bankHeadingName = bankHeadingName;
        this.sanadCodeC = sanadCodeC;
        this.sanadCodeC2 = sanadCodeC2;
        this.endsave = endsave;
        this.savefromfacture = savefromfacture;
        this.savefromauto = savefromauto;
        this.usercodeinc = usercodeinc;
        this.sanadstate = sanadstate;
        this.isReceive = isReceive;
    }

    public static PaymentDtoBuilder builder() {
        return new PaymentDtoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getDate() {
        return this.date;
    }

    public String getTime() {
        return this.time;
    }

    public Double getCash() {
        return this.cash;
    }

    public String getCashsarfasl() {
        return this.cashsarfasl;
    }

    public String getVaultcashsarfasl() {
        return this.vaultcashsarfasl;
    }

    public List<CheckDto> getChecks() {
        return this.checks;
    }

    public Double getBank() {
        return this.bank;
    }

    public String getBanksarfasl() {
        return this.banksarfasl;
    }

    public List<BankPaymentData> getPartialbankpayments() {
        return this.partialbankpayments;
    }

    public Double getDiscount() {
        return this.discount;
    }

    public String getCustomersarfasl() {
        return this.customersarfasl;
    }

    public int getSanadtype() {
        return this.sanadtype;
    }

    public String getComment() {
        return this.comment;
    }

    public Integer getAction() {
        return this.action;
    }

    public List<PaymentDetailDto> getDetail() {
        return this.detail;
    }

    public List<PaymentDetailSndIndxDto> getDetailsndindx() {
        return this.detailsndindx;
    }

    public String getInputid() {
        return this.inputid;
    }

    public int getFixsanadcode() {
        return this.fixsanadcode;
    }

    public int getSanadcode() {
        return this.sanadcode;
    }

    public int getSanadcode2() {
        return this.sanadcode2;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public String getBankHeadingName() {
        return this.bankHeadingName;
    }

    public int getSanadCodeC() {
        return this.sanadCodeC;
    }

    public int getSanadCodeC2() {
        return this.sanadCodeC2;
    }

    public Boolean getEndsave() {
        return this.endsave;
    }

    public Boolean getSavefromfacture() {
        return this.savefromfacture;
    }

    public Boolean getSavefromauto() {
        return this.savefromauto;
    }

    public int getUsercodeinc() {
        return this.usercodeinc;
    }

    public int getSanadstate() {
        return this.sanadstate;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public void setCash(Double cash) {
        this.cash = cash;
    }

    public void setCashsarfasl(String cashsarfasl) {
        this.cashsarfasl = cashsarfasl;
    }

    public void setVaultcashsarfasl(String vaultcashsarfasl) {
        this.vaultcashsarfasl = vaultcashsarfasl;
    }

    public void setChecks(List<CheckDto> checks) {
        this.checks = checks;
    }

    public void setBank(Double bank) {
        this.bank = bank;
    }

    public void setBanksarfasl(String banksarfasl) {
        this.banksarfasl = banksarfasl;
    }

    public void setPartialbankpayments(List<BankPaymentData> partialbankpayments) {
        this.partialbankpayments = partialbankpayments;
    }

    public void setDiscount(Double discount) {
        this.discount = discount;
    }

    public void setCustomersarfasl(String customersarfasl) {
        this.customersarfasl = customersarfasl;
    }

    public void setSanadtype(int sanadtype) {
        this.sanadtype = sanadtype;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setAction(Integer action) {
        this.action = action;
    }

    public void setDetail(List<PaymentDetailDto> detail) {
        this.detail = detail;
    }

    public void setDetailsndindx(List<PaymentDetailSndIndxDto> detailsndindx) {
        this.detailsndindx = detailsndindx;
    }

    public void setInputid(String inputid) {
        this.inputid = inputid;
    }

    public void setFixsanadcode(int fixsanadcode) {
        this.fixsanadcode = fixsanadcode;
    }

    public void setSanadcode(int sanadcode) {
        this.sanadcode = sanadcode;
    }

    public void setSanadcode2(int sanadcode2) {
        this.sanadcode2 = sanadcode2;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public void setBankHeadingName(String bankHeadingName) {
        this.bankHeadingName = bankHeadingName;
    }

    public void setSanadCodeC(int sanadCodeC) {
        this.sanadCodeC = sanadCodeC;
    }

    public void setSanadCodeC2(int sanadCodeC2) {
        this.sanadCodeC2 = sanadCodeC2;
    }

    public void setEndsave(Boolean endsave) {
        this.endsave = endsave;
    }

    public void setSavefromfacture(Boolean savefromfacture) {
        this.savefromfacture = savefromfacture;
    }

    public void setSavefromauto(Boolean savefromauto) {
        this.savefromauto = savefromauto;
    }

    public void setUsercodeinc(int usercodeinc) {
        this.usercodeinc = usercodeinc;
    }

    public void setSanadstate(int sanadstate) {
        this.sanadstate = sanadstate;
    }

    public void setReceive(boolean isReceive) {
        this.isReceive = isReceive;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentDto)) {
            return false;
        }
        PaymentDto other = (PaymentDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getSanadtype() != other.getSanadtype()) {
            return false;
        }
        if (this.getFixsanadcode() != other.getFixsanadcode()) {
            return false;
        }
        if (this.getSanadcode() != other.getSanadcode()) {
            return false;
        }
        if (this.getSanadcode2() != other.getSanadcode2()) {
            return false;
        }
        if (this.getSanadCodeC() != other.getSanadCodeC()) {
            return false;
        }
        if (this.getSanadCodeC2() != other.getSanadCodeC2()) {
            return false;
        }
        if (this.getUsercodeinc() != other.getUsercodeinc()) {
            return false;
        }
        if (this.getSanadstate() != other.getSanadstate()) {
            return false;
        }
        if (this.isReceive() != other.isReceive()) {
            return false;
        }
        Double this$cash = this.getCash();
        Double other$cash = other.getCash();
        if (this$cash == null ? other$cash != null : !((Object)this$cash).equals(other$cash)) {
            return false;
        }
        Double this$bank = this.getBank();
        Double other$bank = other.getBank();
        if (this$bank == null ? other$bank != null : !((Object)this$bank).equals(other$bank)) {
            return false;
        }
        Double this$discount = this.getDiscount();
        Double other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        Integer this$action = this.getAction();
        Integer other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)this$action).equals(other$action)) {
            return false;
        }
        Boolean this$endsave = this.getEndsave();
        Boolean other$endsave = other.getEndsave();
        if (this$endsave == null ? other$endsave != null : !((Object)this$endsave).equals(other$endsave)) {
            return false;
        }
        Boolean this$savefromfacture = this.getSavefromfacture();
        Boolean other$savefromfacture = other.getSavefromfacture();
        if (this$savefromfacture == null ? other$savefromfacture != null : !((Object)this$savefromfacture).equals(other$savefromfacture)) {
            return false;
        }
        Boolean this$savefromauto = this.getSavefromauto();
        Boolean other$savefromauto = other.getSavefromauto();
        if (this$savefromauto == null ? other$savefromauto != null : !((Object)this$savefromauto).equals(other$savefromauto)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        String this$time = this.getTime();
        String other$time = other.getTime();
        if (this$time == null ? other$time != null : !this$time.equals(other$time)) {
            return false;
        }
        String this$cashsarfasl = this.getCashsarfasl();
        String other$cashsarfasl = other.getCashsarfasl();
        if (this$cashsarfasl == null ? other$cashsarfasl != null : !this$cashsarfasl.equals(other$cashsarfasl)) {
            return false;
        }
        String this$vaultcashsarfasl = this.getVaultcashsarfasl();
        String other$vaultcashsarfasl = other.getVaultcashsarfasl();
        if (this$vaultcashsarfasl == null ? other$vaultcashsarfasl != null : !this$vaultcashsarfasl.equals(other$vaultcashsarfasl)) {
            return false;
        }
        List this$checks = this.getChecks();
        List other$checks = other.getChecks();
        if (this$checks == null ? other$checks != null : !((Object)this$checks).equals(other$checks)) {
            return false;
        }
        String this$banksarfasl = this.getBanksarfasl();
        String other$banksarfasl = other.getBanksarfasl();
        if (this$banksarfasl == null ? other$banksarfasl != null : !this$banksarfasl.equals(other$banksarfasl)) {
            return false;
        }
        List this$partialbankpayments = this.getPartialbankpayments();
        List other$partialbankpayments = other.getPartialbankpayments();
        if (this$partialbankpayments == null ? other$partialbankpayments != null : !((Object)this$partialbankpayments).equals(other$partialbankpayments)) {
            return false;
        }
        String this$customersarfasl = this.getCustomersarfasl();
        String other$customersarfasl = other.getCustomersarfasl();
        if (this$customersarfasl == null ? other$customersarfasl != null : !this$customersarfasl.equals(other$customersarfasl)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        List this$detail = this.getDetail();
        List other$detail = other.getDetail();
        if (this$detail == null ? other$detail != null : !((Object)this$detail).equals(other$detail)) {
            return false;
        }
        List this$detailsndindx = this.getDetailsndindx();
        List other$detailsndindx = other.getDetailsndindx();
        if (this$detailsndindx == null ? other$detailsndindx != null : !((Object)this$detailsndindx).equals(other$detailsndindx)) {
            return false;
        }
        String this$inputid = this.getInputid();
        String other$inputid = other.getInputid();
        if (this$inputid == null ? other$inputid != null : !this$inputid.equals(other$inputid)) {
            return false;
        }
        String this$customerCode = this.getCustomerCode();
        String other$customerCode = other.getCustomerCode();
        if (this$customerCode == null ? other$customerCode != null : !this$customerCode.equals(other$customerCode)) {
            return false;
        }
        String this$customerName = this.getCustomerName();
        String other$customerName = other.getCustomerName();
        if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) {
            return false;
        }
        String this$bankHeadingName = this.getBankHeadingName();
        String other$bankHeadingName = other.getBankHeadingName();
        return !(this$bankHeadingName == null ? other$bankHeadingName != null : !this$bankHeadingName.equals(other$bankHeadingName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSanadtype();
        result = result * 59 + this.getFixsanadcode();
        result = result * 59 + this.getSanadcode();
        result = result * 59 + this.getSanadcode2();
        result = result * 59 + this.getSanadCodeC();
        result = result * 59 + this.getSanadCodeC2();
        result = result * 59 + this.getUsercodeinc();
        result = result * 59 + this.getSanadstate();
        result = result * 59 + (this.isReceive() ? 79 : 97);
        Double $cash = this.getCash();
        result = result * 59 + ($cash == null ? 43 : ((Object)$cash).hashCode());
        Double $bank = this.getBank();
        result = result * 59 + ($bank == null ? 43 : ((Object)$bank).hashCode());
        Double $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        Integer $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
        Boolean $endsave = this.getEndsave();
        result = result * 59 + ($endsave == null ? 43 : ((Object)$endsave).hashCode());
        Boolean $savefromfacture = this.getSavefromfacture();
        result = result * 59 + ($savefromfacture == null ? 43 : ((Object)$savefromfacture).hashCode());
        Boolean $savefromauto = this.getSavefromauto();
        result = result * 59 + ($savefromauto == null ? 43 : ((Object)$savefromauto).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        String $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : $time.hashCode());
        String $cashsarfasl = this.getCashsarfasl();
        result = result * 59 + ($cashsarfasl == null ? 43 : $cashsarfasl.hashCode());
        String $vaultcashsarfasl = this.getVaultcashsarfasl();
        result = result * 59 + ($vaultcashsarfasl == null ? 43 : $vaultcashsarfasl.hashCode());
        List $checks = this.getChecks();
        result = result * 59 + ($checks == null ? 43 : ((Object)$checks).hashCode());
        String $banksarfasl = this.getBanksarfasl();
        result = result * 59 + ($banksarfasl == null ? 43 : $banksarfasl.hashCode());
        List $partialbankpayments = this.getPartialbankpayments();
        result = result * 59 + ($partialbankpayments == null ? 43 : ((Object)$partialbankpayments).hashCode());
        String $customersarfasl = this.getCustomersarfasl();
        result = result * 59 + ($customersarfasl == null ? 43 : $customersarfasl.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        List $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : ((Object)$detail).hashCode());
        List $detailsndindx = this.getDetailsndindx();
        result = result * 59 + ($detailsndindx == null ? 43 : ((Object)$detailsndindx).hashCode());
        String $inputid = this.getInputid();
        result = result * 59 + ($inputid == null ? 43 : $inputid.hashCode());
        String $customerCode = this.getCustomerCode();
        result = result * 59 + ($customerCode == null ? 43 : $customerCode.hashCode());
        String $customerName = this.getCustomerName();
        result = result * 59 + ($customerName == null ? 43 : $customerName.hashCode());
        String $bankHeadingName = this.getBankHeadingName();
        result = result * 59 + ($bankHeadingName == null ? 43 : $bankHeadingName.hashCode());
        return result;
    }

    public String toString() {
        return "PaymentDto(id=" + this.getId() + ", date=" + this.getDate() + ", time=" + this.getTime() + ", cash=" + this.getCash() + ", cashsarfasl=" + this.getCashsarfasl() + ", vaultcashsarfasl=" + this.getVaultcashsarfasl() + ", checks=" + this.getChecks() + ", bank=" + this.getBank() + ", banksarfasl=" + this.getBanksarfasl() + ", partialbankpayments=" + this.getPartialbankpayments() + ", discount=" + this.getDiscount() + ", customersarfasl=" + this.getCustomersarfasl() + ", sanadtype=" + this.getSanadtype() + ", comment=" + this.getComment() + ", action=" + this.getAction() + ", detail=" + this.getDetail() + ", detailsndindx=" + this.getDetailsndindx() + ", inputid=" + this.getInputid() + ", fixsanadcode=" + this.getFixsanadcode() + ", sanadcode=" + this.getSanadcode() + ", sanadcode2=" + this.getSanadcode2() + ", customerCode=" + this.getCustomerCode() + ", customerName=" + this.getCustomerName() + ", bankHeadingName=" + this.getBankHeadingName() + ", sanadCodeC=" + this.getSanadCodeC() + ", sanadCodeC2=" + this.getSanadCodeC2() + ", endsave=" + this.getEndsave() + ", savefromfacture=" + this.getSavefromfacture() + ", savefromauto=" + this.getSavefromauto() + ", usercodeinc=" + this.getUsercodeinc() + ", sanadstate=" + this.getSanadstate() + ", isReceive=" + this.isReceive() + ")";
    }
}

